/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendAcmDependentes
extends Observador {
    private ColecaoRendAcmDependente colecaoRendAcm = null;
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosRendAcmDependentes(ColecaoRendAcmDependente colecao, DeclaracaoIRPF dec) {
        this.colecaoRendAcm = colecao;
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                RendAcmDependente rendPJ = (RendAcmDependente)valorNovo;
                rendPJ.addObservador((Observador)this);
                this.calculaTotaisRendRecebidos();
                this.calculaTotaisContribPrev();
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisImpostoDevidoRRA();
                this.calculaTotaisJuros();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                RendAcmDependente rendPJ = (RendAcmDependente)valorNovo;
                rendPJ.removeObservador((Observador)this);
                this.calculaTotaisRendRecebidos();
                this.calculaTotaisContribPrev();
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisImpostoDevidoRRA();
                this.calculaTotaisJuros();
            } else if (nomePropriedade.equals("Op\u00e7\u00e3o pela Forma de Tributa\u00e7\u00e3o")) {
                this.calculaTotaisRendRecebidos();
                this.calculaTotaisContribPrev();
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisImpostoDevidoRRA();
            } else if (nomePropriedade.equals("Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial")) {
                this.calculaTotaisContribPrev();
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Pens\u00e3o Aliment\u00edcia")) {
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Imposto Retido na Fonte")) {
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Rendimentos Tribut\u00e1veis")) {
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Rendimentos recebidos tribut\u00e1veis")) {
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Imposto Devido RRA")) {
                this.calculaTotaisImpostoDevidoRRA();
            } else if (nomePropriedade.equals("Valor recebido referente a juros")) {
                this.calculaTotaisJuros();
            }
        }
    }

    private void calculaTotaisImpostoRetido() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        for (RendAcmDependente rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getImpostoRetidoFonte());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getImpostoRetidoFonte());
            }
            total.append('+', (Valor)rendAtual.getImpostoRetidoFonte());
        }
        this.colecaoRendAcm.getTotaisImpostoRetidoFonte().setConteudo(total);
        this.colecaoRendAcm.getTotaisImpostoRetidoFonteAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisImpostoRetidoFonteExclusiva().setConteudo(totalExclusiva);
    }

    private void calculaTotaisPensaoAlimenticia() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        for (RendAcmDependente rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getPensaoAlimenticia());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getPensaoAlimenticia());
            }
            total.append('+', (Valor)rendAtual.getPensaoAlimenticia());
        }
        this.colecaoRendAcm.getTotaisPensaoAlimenticiaAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisPensaoAlimenticiaExclusiva().setConteudo(totalExclusiva);
        this.colecaoRendAcm.getTotaisPensaoAlimenticia().setConteudo(total);
    }

    private void calculaTotaisContribPrev() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        for (RendAcmDependente rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getContribuicaoPrevOficial());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getContribuicaoPrevOficial());
            }
            total.append('+', (Valor)rendAtual.getContribuicaoPrevOficial());
        }
        this.colecaoRendAcm.getTotaisContribuicaoPrevOficial().setConteudo(total);
        this.colecaoRendAcm.getTotaisContribuicaoPrevOficialAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisContribuicaoPrevOficialExclusiva().setConteudo(totalExclusiva);
    }

    private void calculaTotaisRendRecebidos() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        Valor totalDependentes = new Valor();
        for (RendAcmTitular rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getRendRecebidos());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getRendRecebidos());
                Valor totalRraDependentesAux = new Valor();
                totalRraDependentesAux.append('+', (Valor)rendAtual.getRendRecebidos());
                totalRraDependentesAux.append('-', (Valor)rendAtual.getContribuicaoPrevOficial());
                totalRraDependentesAux.append('-', (Valor)rendAtual.getPensaoAlimenticia());
                totalRraDependentesAux.append('-', (Valor)rendAtual.getImpostoRetidoFonte());
                if (totalRraDependentesAux.comparacao(">", "0,00")) {
                    totalDependentes.append('+', totalRraDependentesAux);
                }
            }
            total.append('+', (Valor)rendAtual.getRendRecebidos());
        }
        this.colecaoRendAcm.getTotaisRendRecebidos().setConteudo(total);
        this.colecaoRendAcm.getTotaisRendRecebidosAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisRendRecebidosExclusiva().setConteudo(totalExclusiva);
        this.declaracaoIRPF.getRendTributacaoExclusiva().getRraDependentes().setConteudo(totalDependentes);
    }

    private void calculaTotaisImpostoDevidoRRA() {
        Valor total = new Valor();
        for (RendAcmDependente rendAtual : this.colecaoRendAcm.itens()) {
            total.append('+', (Valor)rendAtual.getImpostoDevidoRRA());
        }
        this.colecaoRendAcm.getTotaisImpostoDevidoRRA().setConteudo(total);
    }

    private void calculaTotaisJuros() {
        Valor total = new Valor();
        for (RendAcmDependente rendAtual : this.colecaoRendAcm.itens()) {
            total.append('+', (Valor)rendAtual.getValorJuros());
        }
        this.colecaoRendAcm.getTotaisJuros().setConteudo(total);
    }
}

