/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJComExigibilidadeTitular
extends Observador {
    private ColecaoRendPJComExigibilidadeTitular colecaoRendPJComExigibilidade = null;

    public CalculosRendPJComExigibilidadeTitular(ColecaoRendPJComExigibilidadeTitular colecao) {
        this.colecaoRendPJComExigibilidade = colecao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                RendPJComExigibilidadeTitular rendPJ = (RendPJComExigibilidadeTitular)valorNovo;
                rendPJ.addObservador((Observador)this);
                this.calculaTotaisRendExigSuspensa();
                this.calculaTotaisDepositoJudicial();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                RendPJComExigibilidadeTitular rendPJ = (RendPJComExigibilidadeTitular)valorNovo;
                rendPJ.removeObservador((Observador)this);
                this.calculaTotaisRendExigSuspensa();
                this.calculaTotaisDepositoJudicial();
            } else if (nomePropriedade.equals("Dep\u00f3sito Judicial")) {
                this.calculaTotaisDepositoJudicial();
            } else if (nomePropriedade.equals("Rendimentos Tribut\u00e1veis (Imposto com Exigibilidade Suspensa)") || nomePropriedade.equals("CPF/CNPJ da Fonte Pagadora")) {
                this.calculaTotaisRendExigSuspensa();
            }
        }
    }

    private void calculaTotaisDepositoJudicial() {
        Valor total = new Valor();
        for (RendPJComExigibilidadeTitular rendAtual : this.colecaoRendPJComExigibilidade.itens()) {
            total.append('+', (Valor)rendAtual.getDepositoJudicial());
        }
        this.colecaoRendPJComExigibilidade.getTotaisDepositoJudicial().setConteudo(total);
    }

    private void calculaTotaisRendExigSuspensa() {
        Valor total = new Valor();
        for (RendPJComExigibilidadeTitular rendAtual : this.colecaoRendPJComExigibilidade.itens()) {
            total.append('+', (Valor)rendAtual.getRendExigSuspensa());
        }
        this.colecaoRendPJComExigibilidade.getTotaisRendPJExigSuspensa().setConteudo(total);
    }
}

