/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.HashMap;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJTitular
extends Observador {
    private ColecaoRendPJTitular colecaoRendPJ = null;
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosRendPJTitular(ColecaoRendPJTitular colecao, DeclaracaoIRPF dec) {
        this.colecaoRendPJ = colecao;
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                RendPJTitular rendPJ = (RendPJTitular)valorNovo;
                rendPJ.addObservador((Observador)this);
                this.calculaTotaisRendRecebidoPJ();
                this.calculaTotaisContribPrev();
                this.calculaTotaisDecimoTerceiro();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisIRRFDecimoTerceiro();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                RendPJTitular rendPJ = (RendPJTitular)valorNovo;
                rendPJ.removeObservador((Observador)this);
                this.calculaTotaisRendRecebidoPJ();
                this.calculaTotaisContribPrev();
                this.calculaTotaisDecimoTerceiro();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisIRRFDecimoTerceiro();
            } else if (nomePropriedade.equals("Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial")) {
                this.calculaTotaisContribPrev();
            } else if (nomePropriedade.equals("13\u00ba Sal\u00e1rio")) {
                this.calculaTotaisDecimoTerceiro();
            } else if (nomePropriedade.equals("Imposto Retido na Fonte")) {
                this.calculaTotaisImpostoRetido();
            } else if (nomePropriedade.equals("IRRF sobre o 13\u00ba Sal\u00e1rio")) {
                this.calculaTotaisIRRFDecimoTerceiro();
            } else if (nomePropriedade.equals("Rendimentos Recebidos de Pessoa Jur\u00eddica") || nomePropriedade.equals("CPF/CNPJ da Fonte Pagadora")) {
                this.calculaTotaisRendRecebidoPJ();
            }
        }
    }

    private void calculaTotaisIRRFDecimoTerceiro() {
        Valor total = new Valor();
        for (RendPJTitular rendAtual : this.colecaoRendPJ.itens()) {
            total.append('+', (Valor)rendAtual.getIRRFDecimoTerceiro());
        }
        this.colecaoRendPJ.getTotaisIRRFDecimoTerceiro().setConteudo(total);
    }

    private void calculaTotaisImpostoRetido() {
        Valor total = new Valor();
        for (RendPJTitular rendAtual : this.colecaoRendPJ.itens()) {
            total.append('+', rendAtual.getImpostoRetidoFonte());
        }
        this.colecaoRendPJ.getTotaisImpostoRetidoFonte().setConteudo(total);
    }

    private void calculaTotaisDecimoTerceiro() {
        Valor total = new Valor();
        for (RendPJTitular rendAtual : this.colecaoRendPJ.itens()) {
            total.append('+', rendAtual.getDecimoTerceiro());
        }
        this.declaracaoIRPF.getRendTributacaoExclusiva().getDecimoTerceiro().setConteudo(total);
        this.colecaoRendPJ.getTotaisDecimoTerceiro().setConteudo(total);
    }

    private void calculaTotaisContribPrev() {
        Valor total = new Valor();
        for (RendPJTitular rendAtual : this.colecaoRendPJ.itens()) {
            total.append('+', rendAtual.getContribuicaoPrevOficial());
        }
        this.colecaoRendPJ.getTotaisContribuicaoPrevOficial().setConteudo(total);
    }

    private void calculaTotaisRendRecebidoPJ() {
        RendPJTitular rendMaiorFonte = null;
        HashMap<String, Valor> niRendimentos = new HashMap<String, Valor>();
        Valor totaisRendRecebidoPJ = new Valor();
        for (RendPJTitular rendAtual : this.colecaoRendPJ.itens()) {
            Valor rendMaior;
            Valor rend;
            totaisRendRecebidoPJ.append('+', rendAtual.getRendRecebidoPJ());
            if (!niRendimentos.containsKey(rendAtual.getNIFontePagadora().naoFormatado())) {
                rend = new Valor();
                rend.setConteudo(rendAtual.getRendRecebidoPJ().formatado());
                niRendimentos.put(rendAtual.getNIFontePagadora().naoFormatado(), rend);
            } else {
                rend = (Valor)niRendimentos.get(rendAtual.getNIFontePagadora().naoFormatado());
                rend.append('+', rendAtual.getRendRecebidoPJ().formatado());
            }
            if (rendMaiorFonte == null) {
                rendMaiorFonte = rendAtual;
                continue;
            }
            rend = (Valor)niRendimentos.get(rendAtual.getNIFontePagadora().naoFormatado());
            if (!rend.comparacao(">", (rendMaior = (Valor)niRendimentos.get(rendMaiorFonte.getNIFontePagadora().naoFormatado())).formatado())) continue;
            rendMaiorFonte = rendAtual;
        }
        if (rendMaiorFonte == null) {
            this.colecaoRendPJ.getNiMaiorFontePagadora().clear();
        } else {
            this.colecaoRendPJ.getNiMaiorFontePagadora().setConteudo(rendMaiorFonte.getNIFontePagadora().formatado());
        }
        this.colecaoRendPJ.getTotaisRendRecebidoPJ().setConteudo(totaisRendRecebidoPJ);
    }
}

