/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendTributacaoExclusiva
extends Observador {
    private RendTributacaoExclusiva rendTributacao;
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosRendTributacaoExclusiva(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
        this.rendTributacao = this.declaracaoIRPF.getRendTributacaoExclusiva();
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    private void calculaTotal() {
        Valor total = new Valor(this.rendTributacao.getDecimoTerceiro().naoFormatado());
        total.append('+', this.rendTributacao.getDecimoTerceiroDependentes());
        total.append('+', this.rendTributacao.getGanhosCapital());
        total.append('+', this.rendTributacao.getGanhosCapitalEmEspecie());
        total.append('+', this.rendTributacao.getGanhosCapitalEstrangeira());
        total.append('+', this.rendTributacao.getGanhosRendaVariavel());
        total.append('+', this.rendTributacao.getRendAplicacoes());
        total.append('+', (Valor)this.rendTributacao.getRraTitular());
        total.append('+', (Valor)this.rendTributacao.getRraDependentes());
        total.append('+', this.rendTributacao.getJurosCapitalProprio());
        total.append('+', this.rendTributacao.getParticipacaoLucrosResultados());
        total.append('+', (Valor)this.rendTributacao.getLei14754());
        total.append('+', this.rendTributacao.getOutros());
        this.rendTributacao.getTotal().setConteudo(total);
    }
}

