/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.positioners;

import java.awt.Point;
import java.awt.Rectangle;
import net.java.balloontip.positioners.BalloonTipPositioner;

public abstract class BasicBalloonTipPositioner
extends BalloonTipPositioner {
    protected int x = 0;
    protected int y = 0;
    protected int hOffset = 0;
    protected boolean flipX = false;
    protected boolean flipY = false;
    protected int preferredHorizontalOffset;
    protected int preferredVerticalOffset;
    protected int minimumHorizontalOffset;
    protected boolean offsetCorrection = true;
    protected boolean orientationCorrection = true;
    protected boolean fixedAttachLocation = false;
    protected float attachLocationX = 0.0f;
    protected float attachLocationY = 0.0f;

    public BasicBalloonTipPositioner(int hO, int vO) {
        this.preferredHorizontalOffset = hO;
        this.preferredVerticalOffset = vO;
    }

    protected void onStyleChange() {
        this.balloonTip.getStyle().setHorizontalOffset(this.preferredHorizontalOffset);
        this.balloonTip.getStyle().setVerticalOffset(this.preferredVerticalOffset);
        this.minimumHorizontalOffset = this.balloonTip.getStyle().getMinimalHorizontalOffset();
    }

    public int getPreferredHorizontalOffset() {
        return this.preferredHorizontalOffset;
    }

    public void setPreferredHorizontalOffset(int preferredHorizontalOffset) {
        this.preferredHorizontalOffset = preferredHorizontalOffset;
        this.balloonTip.getStyle().setHorizontalOffset(preferredHorizontalOffset);
        this.balloonTip.repaint();
    }

    public int getPreferredVerticalOffset() {
        return this.preferredVerticalOffset;
    }

    public void setPreferredVerticalOffset(int preferredVerticalOffset) {
        this.preferredVerticalOffset = preferredVerticalOffset;
        this.minimumHorizontalOffset = 2 * preferredVerticalOffset;
        this.balloonTip.getStyle().setVerticalOffset(preferredVerticalOffset);
    }

    public boolean isOffsetCorrected() {
        return this.offsetCorrection;
    }

    public void enableOffsetCorrection(boolean offsetCorrection) {
        this.offsetCorrection = offsetCorrection;
    }

    public boolean isOrientationCorrected() {
        return this.orientationCorrection;
    }

    public void enableOrientationCorrection(boolean orientationCorrection) {
        this.orientationCorrection = orientationCorrection;
    }

    public boolean isFixedAttachLocation() {
        return this.fixedAttachLocation;
    }

    public void enableFixedAttachLocation(boolean fixedAttachLocation) {
        this.fixedAttachLocation = fixedAttachLocation;
    }

    public float getAttachLocationX() {
        return this.attachLocationX;
    }

    public float getAttachLocationY() {
        return this.attachLocationY;
    }

    public void setAttachLocation(float attachLocationX, float attachLocationY) {
        this.attachLocationX = attachLocationX;
        this.attachLocationY = attachLocationY;
    }

    public Point getTipLocation() {
        int tipX = this.x + this.hOffset;
        int tipY = this.y + this.balloonTip.getHeight();
        if (this.flipX) {
            tipX = this.x + this.hOffset;
        }
        if (this.flipY) {
            tipY = this.y;
        }
        return new Point(tipX, tipY);
    }

    protected void applyOffsetCorrection() {
        int overflow = -this.x;
        int balloonWidth = this.balloonTip.getPreferredSize().width;
        if (overflow > 0) {
            this.x += overflow;
            this.hOffset -= overflow;
            if (this.hOffset < this.minimumHorizontalOffset) {
                this.hOffset = this.minimumHorizontalOffset;
                this.x = this.flipX ? (this.x += -overflow + (balloonWidth - this.preferredHorizontalOffset) - this.minimumHorizontalOffset) : (this.x += -overflow + this.preferredHorizontalOffset - this.minimumHorizontalOffset);
            }
        }
        if ((overflow = this.x + balloonWidth - this.balloonTip.getTopLevelContainer().getWidth()) > 0) {
            this.x -= overflow;
            this.hOffset += overflow;
            if (this.hOffset > balloonWidth - this.minimumHorizontalOffset) {
                this.hOffset = balloonWidth - this.minimumHorizontalOffset;
                this.x = this.flipX ? (this.x += overflow + this.preferredHorizontalOffset + this.minimumHorizontalOffset) : (this.x += overflow - (balloonWidth - this.preferredHorizontalOffset) + this.minimumHorizontalOffset);
            }
        }
    }

    public void determineAndSetLocation(Rectangle attached) {
        this.determineLocation(attached);
        if (this.flipX) {
            this.balloonTip.getStyle().setHorizontalOffset(this.balloonTip.getPreferredSize().width - this.hOffset);
        } else {
            this.balloonTip.getStyle().setHorizontalOffset(this.hOffset);
        }
        this.balloonTip.getStyle().flip(this.flipX, this.flipY);
        this.balloonTip.setBounds(this.x, this.y, this.balloonTip.getPreferredSize().width, this.balloonTip.getPreferredSize().height);
        this.balloonTip.revalidate();
        if (this.hOffset != this.preferredHorizontalOffset) {
            this.balloonTip.repaint();
        }
    }

    protected abstract void determineLocation(Rectangle var1);
}

