/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import serpro.ppgd.app.PlataformaIRPFPGD;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.VisualizadorHelp;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.SplashScreen;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public abstract class PGDAb {
    protected abstract boolean getPermiteMaisDeUmaInstanciaAplicacao();

    protected abstract void posCriar(PlataformaPPGD var1);

    public PGDAb(Class<?> pJanelaPrincipal) throws IOException, InterruptedException {
        this.verificarLock();
        SplashScreen splash = new SplashScreen(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/imagens/splash.jpg"), null, 1500);
        PlataformaPPGD.setPlataforma((PlataformaPPGD)new PlataformaIRPFPGD());
        final PlataformaPPGD lPlataformaPPGD = PlataformaPPGD.getPlataforma();
        lPlataformaPPGD.carrega(pJanelaPrincipal);
        IRPFFacade.getInstancia().verificarIdDeclaracoes();
        String tooltipdelay = FabricaUtilitarios.getProperties().getProperty("aplicacao.tooltipdelay", "");
        if (tooltipdelay.length() > 0) {
            try {
                ToolTipManager.sharedInstance().setDismissDelay(Integer.parseInt(tooltipdelay));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        splash.setShowing(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                lPlataformaPPGD.exibe();
            }
        });
        lPlataformaPPGD.getJanelaPrincipal().setExtendedState(lPlataformaPPGD.getJanelaPrincipal().getExtendedState() | 6);
        this.posCriar(lPlataformaPPGD);
    }

    protected static void verificaVersaoMinimaJava(String pVersaoRequerida) throws Exception {
        boolean versaoIncompativel = false;
        Object lVersaoJava = System.getProperty("java.version");
        try {
            int lNumVersaoSegunda;
            float lNumVersaoEspecificacao;
            float lNumVersaoEspecificacaoRequerida = Float.parseFloat(pVersaoRequerida.substring(0, 3));
            int lNumVersaoSegundaRequerida = Integer.parseInt("" + pVersaoRequerida.charAt(4));
            if (!((String)lVersaoJava).contains(".")) {
                lVersaoJava = (String)lVersaoJava + ".0.0";
            }
            if ((lNumVersaoEspecificacao = Float.parseFloat(((String)lVersaoJava).substring(0, 3))) < lNumVersaoEspecificacaoRequerida) {
                versaoIncompativel = true;
            } else if (lNumVersaoEspecificacao == lNumVersaoEspecificacaoRequerida && (lNumVersaoSegunda = Integer.parseInt("" + ((String)lVersaoJava).charAt(4))) < lNumVersaoSegundaRequerida) {
                versaoIncompativel = true;
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            versaoIncompativel = true;
        }
        if (versaoIncompativel) {
            String msg = MensagemUtil.getMensagem((String)"VersaoJavaIncompativel", (String[])new String[]{lVersaoJava, pVersaoRequerida});
            throw new Exception(msg);
        }
    }

    public static void verificaVersaoMinimaJava() throws Exception {
        boolean versaoIncompativel = false;
        Object lVersaoJava = System.getProperty("java.version");
        try {
            if (!((String)lVersaoJava).contains(".")) {
                lVersaoJava = (String)lVersaoJava + ".0.0";
            }
            if (!((String)lVersaoJava).contains("_")) {
                lVersaoJava = (String)lVersaoJava + "_00";
            }
            float lNumVersaoEspecificacao = Float.parseFloat(((String)lVersaoJava).substring(0, 3));
            String pVersaoRequerida = "1.7.0_111";
            if (lNumVersaoEspecificacao == Float.valueOf("1.8").floatValue()) {
                pVersaoRequerida = "1.8.0_101";
            }
            float lNumVersaoEspecificacaoRequerida = Float.parseFloat(pVersaoRequerida.substring(0, 3));
            int lNumVersaoSegundaRequerida = Integer.parseInt("" + pVersaoRequerida.charAt(4));
            int lNumVersaoBuildRequerida = Integer.parseInt(pVersaoRequerida.substring(6));
            if (lNumVersaoEspecificacao < lNumVersaoEspecificacaoRequerida) {
                versaoIncompativel = true;
            } else if (lNumVersaoEspecificacao == lNumVersaoEspecificacaoRequerida) {
                int lNumVersaoBuild;
                int lNumVersaoSegunda = Integer.parseInt("" + ((String)lVersaoJava).charAt(4));
                if (lNumVersaoSegunda < lNumVersaoSegundaRequerida) {
                    versaoIncompativel = true;
                }
                if ((lNumVersaoBuild = Integer.parseInt(((String)lVersaoJava).substring(6))) < lNumVersaoBuildRequerida) {
                    versaoIncompativel = true;
                }
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            versaoIncompativel = true;
        }
        String archModel = System.getProperty("sun.arch.data.model");
        archModel = archModel == null || !archModel.equals("64") ? "" : "(64 bits)";
        if (versaoIncompativel) {
            String msg = MensagemUtil.getMensagem((String)"VersaoBuildJavaIncompativel", (String[])new String[]{lVersaoJava, archModel});
            throw new Exception(msg);
        }
    }

    protected static void verificarSO() throws Exception {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows 95")) {
            String msg = MensagemUtil.getMensagem((String)"ErroCompatibilidadeSO");
            throw new Exception(msg);
        }
    }

    protected static void mostrarHelp() {
        VisualizadorHelp visualizador = new VisualizadorHelp();
        visualizador.exibe();
    }

    protected void verificarLock() throws IOException {
        if (!this.getPermiteMaisDeUmaInstanciaAplicacao() && PGDAb.verificaPGDEmExecucao()) {
            GuiUtil.mostrarAviso((String)"CopiaJaEmExecucao", (String[])new String[]{AplicacaoPropertiesUtil.getTituloVersao()});
            System.exit(1);
        }
    }

    protected static boolean verificaPGDEmExecucao() throws IOException {
        boolean ret = false;
        Object arquivoLock = null;
        arquivoLock = FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac() ? UtilitariosArquivo.getPathUsuario() : UtilitariosArquivo.getPathAplicacao();
        File diretorio = new File((String)arquivoLock);
        if (!diretorio.exists() && !diretorio.mkdirs()) {
            throw new IOException("Ocorreu um erro ao criar arquivo TryLock!");
        }
        arquivoLock = (String)arquivoLock + "TryLock" + ConstantesGlobais.EXERCICIO + ".txt";
        try (RandomAccessFile raf = new RandomAccessFile((String)arquivoLock, "rw");){
            FileLock lock = raf.getChannel().tryLock();
            if (lock == null) {
                ret = true;
            }
        }
        return ret;
    }
}

