/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.atividaderural;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.DocumentoTXT;
import serpro.ppgd.formatosexternos.txt.DocumentoTXTDefault;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.MesReceitaDespesa;
import serpro.ppgd.irpf.atividaderural.exterior.ApuracaoResultadoExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ColecaoReceitasDespesas;
import serpro.ppgd.irpf.atividaderural.exterior.ReceitaDespesa;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.irpf.txt.importacao.RelatorioRepositorioTxtDadosAb;
import serpro.ppgd.irpf.txt.importacao.VersaoDecInvalidaException;
import serpro.ppgd.irpf.txt.importacao.atividaderural.DadoAtividadeRuralBrasil;
import serpro.ppgd.irpf.txt.importacao.atividaderural.DadoAtividadeRuralExterior;
import serpro.ppgd.irpf.txt.importacao.atividaderural.ItemMensalARBrasil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Valor;
import serpro.util.PLong;

public class RepositorioTxtDadosAtividadeRural
extends RelatorioRepositorioTxtDadosAb {
    private String pathArquivo = null;
    private DocumentoTXT documentoTXT = null;
    private Map<String, DadoAtividadeRuralBrasil> mapPaises = new HashMap<String, DadoAtividadeRuralBrasil>();
    private Map<String, DadoAtividadeRuralExterior> mapPaisesExterior = new HashMap<String, DadoAtividadeRuralExterior>();

    public RepositorioTxtDadosAtividadeRural(String _pathArquivo) {
        this.pathArquivo = _pathArquivo;
        this.documentoTXT = new DocumentoTXTDefault("ARQ_IMPORTACAO_ATIV_RURAL", this.pathArquivo);
        this.setContabilizarSucessosErros(false);
    }

    public void validarVersaoAtividadeRural() throws Exception {
        try {
            this.documentoTXT.ler();
            this.verificaCRC();
        }
        catch (IOException | GeracaoTxtException gex) {
            throw new GeracaoTxtException("Arquivo corrompido.");
        }
        List header = this.documentoTXT.getRegistrosTxt("IR");
        String versao = ((RegistroTxt)header.get(0)).fieldByName("NR_VERSAO").asString();
        if (!versao.equals("110")) {
            String exercicio = ConstantesGlobais.EXERCICIO_ANTERIOR;
            throw new VersaoDecInvalidaException(MensagemUtil.getMensagem((String)"versao_arquivo_ar_errado", (String[])new String[]{exercicio, exercicio}));
        }
    }

    public String importaDados() throws Exception {
        String erro = null;
        try {
            this.validarVersaoAtividadeRural();
            this.importaDadosAR();
            this.incrementarQuantidadeSucessos();
        }
        catch (Exception ex) {
            this.incrementarQuantidadeErros();
            if (!this.isContabilizarSucessosErros()) {
                throw ex;
            }
            erro = ex.getMessage();
        }
        return erro;
    }

    private void importaDadosAR() throws GeracaoTxtException, IOException {
        this.resetQuantidadeSucessos();
        this.resetQuantidadeErros();
        Iterator it = null;
        List registros = this.documentoTXT.getRegistrosTxt("04");
        Collections.sort(registros, new Comparator<RegistroTxt>(){

            @Override
            public int compare(RegistroTxt registroUm, RegistroTxt registroDois) {
                String paisUm = "";
                String paisDois = "";
                String mesUm = "";
                String mesDois = "";
                try {
                    paisUm = registroUm.fieldByName("CD_PAIS").asString();
                    paisDois = registroDois.fieldByName("CD_PAIS").asString();
                }
                catch (GeracaoTxtException e) {
                    e.printStackTrace();
                }
                int sComp = paisUm.compareTo(paisDois);
                if (sComp != 0) {
                    return sComp;
                }
                try {
                    mesUm = registroUm.fieldByName("Flag Mes").asString();
                    mesDois = registroDois.fieldByName("Flag Mes").asString();
                }
                catch (GeracaoTxtException e) {
                    e.printStackTrace();
                }
                return mesUm.compareTo(mesDois);
            }
        });
        for (RegistroTxt reg : registros) {
            String cdPais = reg.fieldByName("CD_PAIS").asString();
            Valor receitas = reg.fieldByName("receitas").asValor();
            Valor despesas = reg.fieldByName("despesas").asValor();
            Valor produtosEntregueAdiantamento = reg.fieldByName("ProdutosEntregueAdiantamento").asValor();
            Valor adiantamentoRecebido = reg.fieldByName("AdiantamentoRecebido").asValor();
            if (cdPais.equals("105")) {
                DadoAtividadeRuralBrasil dadoAtividadeRuralBrasil = null;
                if (this.mapPaises.containsKey(cdPais)) {
                    dadoAtividadeRuralBrasil = this.mapPaises.get(cdPais);
                } else {
                    dadoAtividadeRuralBrasil = new DadoAtividadeRuralBrasil();
                    this.mapPaises.put(cdPais, dadoAtividadeRuralBrasil);
                }
                ItemMensalARBrasil itemMensalARBrasil = new ItemMensalARBrasil();
                itemMensalARBrasil.receita.setConteudo(receitas);
                itemMensalARBrasil.despesa.setConteudo(despesas);
                itemMensalARBrasil.produtoEntregueAdiantamento.setConteudo(produtosEntregueAdiantamento);
                itemMensalARBrasil.adiantamentoRecebido.setConteudo(adiantamentoRecebido);
                dadoAtividadeRuralBrasil.add(itemMensalARBrasil);
                dadoAtividadeRuralBrasil.totalAdiantamentoRecebido.append('+', itemMensalARBrasil.adiantamentoRecebido);
                dadoAtividadeRuralBrasil.totalProdutoEntregueAdiantamento.append('+', itemMensalARBrasil.produtoEntregueAdiantamento);
                continue;
            }
            DadoAtividadeRuralExterior dadoAtividadeRuralExterior = null;
            if (this.mapPaisesExterior.containsKey(cdPais)) {
                dadoAtividadeRuralExterior = this.mapPaisesExterior.get(cdPais);
            } else {
                dadoAtividadeRuralExterior = new DadoAtividadeRuralExterior(cdPais);
                this.mapPaisesExterior.put(cdPais, dadoAtividadeRuralExterior);
            }
            dadoAtividadeRuralExterior.totalReceitas.append('+', receitas);
            dadoAtividadeRuralExterior.totalDespesas.append('+', despesas);
        }
        this.importaBrasil();
        this.importaExterior();
    }

    private void importaExterior() {
        Iterator<DadoAtividadeRuralExterior> itPaises = this.mapPaisesExterior.values().iterator();
        ColecaoReceitasDespesas receitasDespesasExterior = IRPFFacade.getInstancia().getAtividadeRural().getExterior().getReceitasDespesas();
        receitasDespesasExterior.clear();
        while (itPaises.hasNext()) {
            DadoAtividadeRuralExterior dadoAtividadeRuralExterior = itPaises.next();
            ReceitaDespesa receita = new ReceitaDespesa();
            receita.getPais().setConteudo(dadoAtividadeRuralExterior.codPais);
            receita.getReceitaBruta().setConteudo(dadoAtividadeRuralExterior.totalReceitas);
            receita.getDespesaCusteio().setConteudo(dadoAtividadeRuralExterior.totalDespesas);
            receitasDespesasExterior.itens().add(receita);
            ApuracaoResultadoExterior apuracaoResultadoExterior = IRPFFacade.getInstancia().getAtividadeRural().getExterior().getApuracaoResultado();
            apuracaoResultadoExterior.getReceitaRecebidaContaVenda().setConteudo(dadoAtividadeRuralExterior.totalAdiantamentoRecebido);
            apuracaoResultadoExterior.getValorAdiantamento().setConteudo(dadoAtividadeRuralExterior.totalProdutoEntregueAdiantamento);
        }
    }

    private boolean verificaMesSaida(int mes) {
        String mesCondicaoResidente;
        Saida saida = IRPFFacade.getInstancia().getSaida();
        String mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
        String string = mesCondicaoResidente = saida.getDtCondicaoResidente().isVazio() ? "1" : saida.getDtCondicaoResidente().getMes();
        return mes + 1 >= Integer.valueOf(mesCondicaoResidente) && mes + 1 <= Integer.valueOf(mesCondicaoNaoResidente);
    }

    private boolean verificaMesEspolio(int mes) {
        String mesDecisaoJudicial;
        Espolio espolio = IRPFFacade.getInstancia().getEspolio();
        Data dtLimite = espolio.obterDataLimiteParaCalculos();
        return dtLimite.isVazio() || (mesDecisaoJudicial = dtLimite.getMes()).isEmpty() || mes <= Integer.valueOf(mesDecisaoJudicial) - 1;
    }

    private void importaBrasil() {
        DadoAtividadeRuralBrasil dadoAtividadeRuralBrasil = this.mapPaises.remove("105");
        if (dadoAtividadeRuralBrasil != null) {
            for (int i = 0; i < dadoAtividadeRuralBrasil.size(); ++i) {
                if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio()) {
                    if (!this.verificaMesEspolio(i)) continue;
                    this.preencheItemBrasil(i, dadoAtividadeRuralBrasil);
                    continue;
                }
                if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isSaida()) {
                    if (!this.verificaMesSaida(i)) continue;
                    this.preencheItemBrasil(i, dadoAtividadeRuralBrasil);
                    continue;
                }
                this.preencheItemBrasil(i, dadoAtividadeRuralBrasil);
            }
            ApuracaoResultadoBrasil apuracaoResultadoBrasil = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getApuracaoResultado();
            apuracaoResultadoBrasil.getReceitaRecebidaContaVenda().setConteudo(dadoAtividadeRuralBrasil.totalAdiantamentoRecebido);
            apuracaoResultadoBrasil.getValorAdiantamento().setConteudo(dadoAtividadeRuralBrasil.totalProdutoEntregueAdiantamento);
        }
    }

    private void preencheItemBrasil(int i, DadoAtividadeRuralBrasil dadoAtividadeRuralBrasil) {
        ItemMensalARBrasil itemMensalARBrasil = (ItemMensalARBrasil)dadoAtividadeRuralBrasil.get(i);
        MesReceitaDespesa mesReceitaDespesa = new MesReceitaDespesa();
        switch (i) {
            case 0: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getJaneiro();
                break;
            }
            case 1: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getFevereiro();
                break;
            }
            case 2: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getMarco();
                break;
            }
            case 3: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getAbril();
                break;
            }
            case 4: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getMaio();
                break;
            }
            case 5: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getJunho();
                break;
            }
            case 6: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getJulho();
                break;
            }
            case 7: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getAgosto();
                break;
            }
            case 8: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getSetembro();
                break;
            }
            case 9: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getOutubro();
                break;
            }
            case 10: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getNovembro();
                break;
            }
            case 11: {
                mesReceitaDespesa = IRPFFacade.getInstancia().getAtividadeRural().getBrasil().getReceitasDespesas().getDezembro();
            }
        }
        mesReceitaDespesa.getReceitaBrutaMensal().setConteudo(itemMensalARBrasil.receita);
        mesReceitaDespesa.getDespesaCusteioInvestimento().setConteudo(itemMensalARBrasil.despesa);
    }

    public void verificaCRC() throws GeracaoTxtException {
        String crcLido;
        PLong pLongAcumulado = new PLong();
        Crc32 crc32Acumulado = new Crc32();
        long hashCalculadoLinhaAnterior = 0L;
        for (int i = 0; i < this.documentoTXT.arquivo().size() - 1; ++i) {
            String linha = (String)this.documentoTXT.arquivo().get(i);
            if (hashCalculadoLinhaAnterior != 0L) {
                pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
            }
            hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
        }
        String crcAcumuladoFinal = String.valueOf(hashCalculadoLinhaAnterior);
        try {
            RegistroTxt reg = (RegistroTxt)this.documentoTXT.getRegistrosTxt("99").get(0);
            crcLido = reg.fieldByName("HASHCODE").asString();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new GeracaoTxtException("Arquivo corrompido.");
        }
        if (!crcLido.equals(crcAcumuladoFinal)) {
            throw new GeracaoTxtException("Arquivo corrompido");
        }
    }
}

