/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.gcap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import serpro.ppgd.irpf.txt.importacao.gcap.DefaultTagHandler;
import serpro.ppgd.irpf.txt.importacao.gcap.MapeamentoXmlReader;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

public class ObjetoNegocioXMLReaderTagHandler
extends DefaultTagHandler {
    private Element tipoArquivo = null;
    private Stack<Element> registros = new Stack();
    private Element campo = null;
    private ObjetoNegocio objetoNegocio;
    private MapeamentoXmlReader mapeamento;

    public ObjetoNegocioXMLReaderTagHandler(ObjetoNegocio objetoNegocio) {
        this.mapeamento = new MapeamentoXmlReader();
        this.objetoNegocio = objetoNegocio;
    }

    public ObjetoNegocioXMLReaderTagHandler(ObjetoNegocio objetoNegocio, String chaveMapeamentoXML) {
        this.mapeamento = new MapeamentoXmlReader(chaveMapeamentoXML);
        this.objetoNegocio = objetoNegocio;
    }

    @Override
    public void characters(String tagPath, String texto) {
    }

    protected String obterTextoFormatado(String texto) {
        return texto.replaceAll("(\\A(\\n|\\s|\\t)+)|((\\n|\\s|\\t)+\\z)", "");
    }

    @Override
    public void endElement(String tagPath, String textoCompleto) throws SAXException {
        String nomeTipo;
        if (this.campo != null) {
            Element registro = this.registros.peek();
            String tagPathCampo = registro.getAttribute("Nome") + "/" + this.campo.getAttribute("Nome");
            if (tagPathCampo.toLowerCase().equals(tagPath)) {
                String atributo = this.campo.getAttribute("atributoObjetoNegocio");
                if (atributo != null && atributo.length() > 0) {
                    Object o = ObjetoNegocioXMLReaderTagHandler.obterCampo(this.objetoNegocio, atributo);
                    if (o instanceof Informacao) {
                        Informacao info = (Informacao)o;
                        info.setConteudo(this.obterTextoFormatado(textoCompleto));
                    } else {
                        throw new SAXException(tagPath + "@" + atributo + " n\u00e3o \u00e9 um objeto Informacao.");
                    }
                }
                this.campo = null;
            }
        } else if (!this.registros.empty()) {
            Element registro = this.registros.peek();
            String atributo = registro.getAttribute("Nome");
            if (atributo.toLowerCase().equals(tagPath)) {
                registro = this.registros.pop();
            }
        } else if (this.tipoArquivo != null && (nomeTipo = this.tipoArquivo.getAttribute("TipoArquivo")) != null && nomeTipo.toLowerCase().equals(tagPath)) {
            this.tipoArquivo = null;
        }
    }

    @Override
    public void startElement(String tagPath, Attributes attributes) throws SAXException {
        if (this.tipoArquivo == null) {
            this.tipoArquivo = this.mapeamento.getMapeamentoTipoArquivo(tagPath);
        } else {
            Element camp;
            Element reg = this.mapeamento.getMapeamentoRegistro(tagPath, this.tipoArquivo);
            if (reg != null) {
                this.registros.push(reg);
                String atributoColecao = reg.getAttribute("Colecao");
                if (atributoColecao != null && atributoColecao.trim().length() > 0) {
                    Object o = ObjetoNegocioXMLReaderTagHandler.obterCampo(this.objetoNegocio, atributoColecao);
                    if (o instanceof Colecao) {
                        Colecao col = (Colecao)o;
                        col.novoObjeto();
                    } else {
                        throw new SAXException(tagPath + "@" + atributoColecao + " n\u00e3o \u00e9 uma Cole\u00e7\u00e3o.");
                    }
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String atributo;
                    String nomeCampo = attributes.getQName(i);
                    String valor = attributes.getValue(i);
                    valor = UtilitariosString.retiraCaracteresEspeciais((String)UtilitariosString.removeAcentos((String)valor));
                    String tagPathCampo = tagPath + "/" + nomeCampo.toLowerCase();
                    Element campo = this.mapeamento.getMapeamentoCampo(tagPathCampo, this.registros.peek());
                    if (campo == null || (atributo = campo.getAttribute("atributoObjetoNegocio")) == null || atributo.length() <= 0) continue;
                    Object o = ObjetoNegocioXMLReaderTagHandler.obterCampo(this.objetoNegocio, atributo);
                    if (o instanceof Informacao) {
                        Informacao info = (Informacao)o;
                        info.setConteudo(valor);
                        continue;
                    }
                    throw new SAXException(tagPathCampo + "@" + atributo + " n\u00e3o \u00e9 um objeto Informacao.");
                }
            } else if (!this.registros.empty() && (camp = this.mapeamento.getMapeamentoCampo(tagPath, this.registros.peek())) != null) {
                this.campo = camp;
            }
        }
    }

    public static Object getObjectField(Object obj, String fieldName) {
        Object field = null;
        try {
            Class<?> c = obj.getClass();
            StringBuffer methodName = new StringBuffer("get");
            methodName.append(fieldName.substring(0, 1).toUpperCase());
            methodName.append(fieldName.substring(1));
            Method m = null;
            m = c.getMethod(methodName.toString(), new Class[0]);
            field = m.invoke(obj, new Object[0]);
        }
        catch (SecurityException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        return field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object obterCampo(ObjetoNegocio obj, String nomeCampo) {
        String[] listaObj = nomeCampo.split("\\.");
        Object objAtual = obj;
        for (int i = 0; i < listaObj.length; ++i) {
            String nomeCampoCurto = null;
            Integer indiceColecao = null;
            if (listaObj[i].matches("(\\w)+\\[(\\d)*\\]")) {
                int beginIndex = listaObj[i].lastIndexOf(91) + 1;
                int endIndex = listaObj[i].length() - 1;
                if (endIndex - beginIndex <= 0) {
                    indiceColecao = new Integer("-1");
                } else {
                    try {
                        indiceColecao = new Integer(listaObj[i].substring(beginIndex, endIndex));
                    }
                    catch (Exception e) {
                        LogPPGD.erro((String)e.getMessage());
                        return null;
                    }
                }
                nomeCampoCurto = listaObj[i].substring(0, beginIndex - 1);
            } else {
                nomeCampoCurto = listaObj[i];
            }
            if (nomeCampoCurto == null) return null;
            Object o = null;
            try {
                o = ObjetoNegocioXMLReaderTagHandler.getObjectField(objAtual, nomeCampoCurto);
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
                return null;
            }
            if (indiceColecao != null) {
                if (!(o instanceof Colecao)) {
                    return null;
                }
                int tqdElementos = ((Colecao)o).itens().size();
                if (indiceColecao < 0) {
                    indiceColecao = new Integer(tqdElementos - 1);
                }
                if (indiceColecao < 0 || indiceColecao >= tqdElementos) return null;
                o = ((Colecao)o).itens().get(indiceColecao);
            }
            objAtual = o;
        }
        return objAtual;
    }

    public ObjetoNegocio getObjetoNegocio() {
        return this.objetoNegocio;
    }

    public void setObjetoNegocio(ObjetoNegocio objetoNegocio) {
        this.objetoNegocio = objetoNegocio;
    }
}

