/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.gcap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.mozilla.intl.chardet.nsDetector;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import serpro.hash.Crc32;
import serpro.ppgd.irpf.gcap.DemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.txt.importacao.gcap.ObjetoNegocioXMLReaderTagHandler;
import serpro.ppgd.irpf.txt.importacao.gcap.XMLSaxHandler;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.util.PLong;

public class RepositorioXMLDadosGCAP {
    private String strXml = null;

    private String obterCharset(File arquivo) {
        String defaultCharset = "ISO-8859-1";
        try (FileInputStream fis = new FileInputStream(arquivo);){
            int nread;
            byte[] buf = new byte[1024];
            nsDetector detector = new nsDetector();
            while ((nread = fis.read(buf)) > 0) {
                detector.HandleData(buf, nread);
            }
            detector.DataEnd();
            String[] encoding = detector.getProbableCharsets();
            if (encoding != null) {
                if (encoding.length >= 0 && encoding[0].length() > 0) {
                    defaultCharset = encoding[0];
                }
            } else {
                System.out.println("Tipo de codifica\u00e7\u00e3o de caracteres utilizada no demonstrativo n\u00e3o detectada");
            }
            detector.Reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultCharset;
    }

    public void lerArquivoXML(File arquivo) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(arquivo), this.obterCharset(arquivo)));){
            this.strXml = reader.readLine();
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            throw new Exception("Ocorreu um erro durante leitura do arquivo.", e);
        }
    }

    public static String calcularHashCRC32(String pTexto) {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        pLong.setValue(0L);
        crc32.CalcCrc32(pTexto, pTexto.length(), pLong);
        return crc32.getStrCrc32();
    }

    public DemonstrativoGCAP importaDados(File arquivo) throws Exception {
        this.lerArquivoXML(arquivo);
        return this.importaDados();
    }

    public DemonstrativoGCAP importaDados() throws Exception {
        IdDemonstrativoGCAP idDemonstrativoGCAP = new IdDemonstrativoGCAP();
        DemonstrativoGCAP demonstrativoGCAP = new DemonstrativoGCAP(idDemonstrativoGCAP);
        if (this.strXml == null) {
            throw new Exception("Para importar dados \u00e9 necess\u00e1rio executar o m\u00e9todo de leitura.");
        }
        SAXParser parser = null;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            throw new Exception("Ocorreu um erro durante inicializa\u00e7\u00e3o do SAXParser.", e);
        }
        ObjetoNegocioXMLReaderTagHandler tagHandler = new ObjetoNegocioXMLReaderTagHandler((ObjetoNegocio)demonstrativoGCAP, "aplicacao.formatosexternos.mapeamentoXmlGCAP");
        XMLSaxHandler handler = new XMLSaxHandler();
        handler.addDefaultTagHandler(tagHandler);
        try {
            InputSource in = new InputSource(new StringReader(this.strXml));
            parser.parse(in, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            LogPPGD.erro((String)e.getMessage());
            throw new Exception("N\u00e3o \u00e9 poss\u00edvel importar dados. O arquivo est\u00e1 corrompido.", e);
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            throw new Exception("Ocorreu um erro durante a leitura do arquivo de dados.", e);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.strXml = null;
        }
        return demonstrativoGCAP;
    }
}

