/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.carregador;

import java.io.File;
import java.util.prefs.Preferences;
import serpro.receitanet.carregador.ExcecaoInformacaoIncorreta;

public class Configuracao {
    protected static final String CHAVE_CAMINHO = "Path";
    protected static final String CHAVE_VERSAO = "Versao";
    private static final String NO_RECEITANET = "br/gov/serpro/receitanet";
    private static Preferences preferencias_sistema = Preferences.systemRoot().node("br/gov/serpro/receitanet");
    private static Preferences preferencias_usuario = Preferences.userRoot().node("br/gov/serpro/receitanet");
    private File _caminho;
    private int _versao;

    public Configuracao() {
        try {
            this.obterConfiguracoes(preferencias_sistema);
        }
        catch (ExcecaoInformacaoIncorreta e) {
            this.obterConfiguracoes(preferencias_usuario);
        }
    }

    private void obterConfiguracoes(Preferences preferencias) {
        int INVALIDA = -1;
        String caminho = preferencias.get(CHAVE_CAMINHO, null);
        if (caminho == null) {
            throw new ExcecaoInformacaoIncorreta("Localiza\u00e7\u00e3o do Receitanet n\u00e3o foi encontrada nas configura\u00e7\u00f5es.");
        }
        this._caminho = new File(caminho, "receitanet.jar");
        this._versao = preferencias.getInt(CHAVE_VERSAO, -1);
        if (this._versao == -1) {
            throw new ExcecaoInformacaoIncorreta("N\u00e3o foi poss\u00edvel determinar a vers\u00e3o do Receitanet.");
        }
    }

    public File obterCaminhoDoPrograma() {
        return this._caminho;
    }

    public int obterVersao() {
        return this._versao;
    }
}

