/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditMemo;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.TransferFocus;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaDividasBrasilDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Demonstrativo da Atividade Rural/Atividade Rural - Fichas/D\u00edvidas Vinculadas \u00e0 Atividade Rural";
    private DividaAR dividaAR = null;
    private boolean emEdicao;
    private DividaAR itemInicial = null;
    private JEditMemo edtDiscriminacao;
    private JEditValor edtSituacaoAnterior;
    private JEditValor edtSituacaoAtual;
    private JEditValor edtValorPgtoAnual;
    private JPanel jPanel2;
    private JLabel lbValorPgtoAnual;
    private JLabel lblDiscriminacao;
    private JLabel lblSituacaoAnterior;
    private JLabel lblSituacaoAtual;
    private JLabel lblTitulo;

    public PainelAbaDividasBrasilDetalhe(DividaAR dividaAR, boolean emEdicao) {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        this.dividaAR = dividaAR;
        this.emEdicao = emEdicao;
        this.associarInformacao();
        if (emEdicao) {
            this.itemInicial = dividaAR.obterCopia();
        }
        TransferFocus.patch((Component)this.edtDiscriminacao.getComponenteFoco());
    }

    private void associarInformacao() {
        this.edtDiscriminacao.setInformacao((Informacao)this.dividaAR.getDiscriminacao());
        this.edtSituacaoAnterior.setInformacao((Informacao)this.dividaAR.getContraidasAteExercicioAnterior());
        this.edtSituacaoAtual.setInformacao((Informacao)this.dividaAR.getContraidasAteExercicioAtual());
        this.edtValorPgtoAnual.setInformacao((Informacao)this.dividaAR.getValorPagamentoAnual());
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_AR_DIVIDAS);
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBrasil().getDividas().itens().indexOf(this.dividaAR);
            ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBrasil().getDividas().remove((ObjetoNegocio)this.dividaAR);
            ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBrasil().getDividas().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBrasil().getDividas().remove((ObjetoNegocio)this.dividaAR);
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_AR_DIVIDAS);
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblDiscriminacao = new JLabel();
        this.edtDiscriminacao = new JEditMemo();
        this.lblSituacaoAnterior = new JLabel();
        this.edtSituacaoAnterior = new JEditValor();
        this.lblSituacaoAtual = new JLabel();
        this.edtSituacaoAtual = new JEditValor();
        this.edtValorPgtoAnual = new JEditValor();
        this.lbValorPgtoAnual = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.lblTitulo.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo.setForeground(new Color(0, 74, 106));
        this.lblTitulo.setText("Dados da D\u00edvida");
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblDiscriminacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDiscriminacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDiscriminacao.setText("Discrimina\u00e7\u00e3o");
        this.edtDiscriminacao.setMaxChars(512);
        this.lblSituacaoAnterior.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSituacaoAnterior.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSituacaoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.lblSituacaoAtual.setFont(FontesUtil.FONTE_NORMAL);
        this.lblSituacaoAtual.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblSituacaoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        this.lbValorPgtoAnual.setFont(FontesUtil.FONTE_NORMAL);
        this.lbValorPgtoAnual.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbValorPgtoAnual.setText("Valor Pago em " + ConstantesGlobais.ANO_BASE + " (R$)");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.edtDiscriminacao, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblDiscriminacao).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.edtSituacaoAnterior, -2, 216, -2).add((Component)this.lblSituacaoAnterior)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.edtSituacaoAtual, -2, 170, -2).add((Component)this.lblSituacaoAtual)))).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.edtValorPgtoAnual, -2, 216, -2).add((Component)this.lbValorPgtoAnual)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.edtSituacaoAnterior, this.edtSituacaoAtual}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblDiscriminacao).add(2, 2, 2).add((Component)this.edtDiscriminacao, -2, 103, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblSituacaoAnterior).add(2, 2, 2).add((Component)this.edtSituacaoAnterior, -2, -1, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.lblSituacaoAtual).add((Component)this.lbValorPgtoAnual)).add(2, 2, 2).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.edtSituacaoAtual, -2, -1, -2).add((Component)this.edtValorPgtoAnual, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.edtDiscriminacao.getAccessibleContext().setAccessibleName("Discrimina\u00e7\u00e3o");
        this.edtSituacaoAnterior.getAccessibleContext().setAccessibleName("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.edtSituacaoAtual.getAccessibleContext().setAccessibleName("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.lblTitulo)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblTitulo).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public JComponent getDefaultFocus() {
        return this.edtDiscriminacao;
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/AR_dividas.png");
    }

    public String getTituloPainel() {
        return "D\u00edvidas Vinculadas \u00e0 Atividade Rural";
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public void preExibir() {
        this.alterarLabel();
    }

    private boolean isEspolio() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio();
    }

    private boolean isSaida() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida();
    }

    private void alterarLabel() {
        if (this.isEspolio()) {
            this.lblSituacaoAtual.setText("Situa\u00e7\u00e3o na data da partilha (R$)");
        } else if (this.isSaida()) {
            if (ControladorGui.getDemonstrativoAberto().entrouSaiuNoMesmoAno()) {
                this.lblSituacaoAnterior.setText("<HTML>Situa\u00e7\u00e3o na data da caracteriza\u00e7\u00e3o<BR>da condi\u00e7\u00e3o de residente (R$)</HTML>");
            } else {
                this.lblSituacaoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            }
            this.lblSituacaoAtual.setText("<HTML>Situa\u00e7\u00e3o na data da caracteriza\u00e7\u00e3o<BR>da condi\u00e7\u00e3o de n\u00e3o residente (R$)</HTML>");
        } else {
            this.lblSituacaoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        }
    }

    public boolean isTelaComFavoritos() {
        return false;
    }
}

