/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditMemo;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.TransferFocus;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelBensARDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Bens da Atividade Rural";
    private static final String HELP_ID = "Demonstrativo da Atividade Rural/Atividade Rural - Fichas/Bens da Atividade Rural";
    private BemAR bemAR = null;
    private BemAR itemInicial = null;
    private boolean emEdicao;
    private JButton btnRepetir;
    private JAutoCompleteEditCodigo cmbCodigo;
    private JAutoCompleteEditCodigo cmbPais;
    private JEditMemo edtDiscriminacao;
    private JEditValor edtValorAnterior;
    private JEditValor edtValorAtual;
    private JLabel lbRepetir;
    private JLabel lbSituacaoAnoAnterior;
    private JLabel lbSituacaoAnoAtual;
    private JLabel lblCodigo;
    private JLabel lblDiscriminacao;
    private JLabel lblPais;
    private JLabel lblTitulo;
    private JPanel pnlPrincipal;

    public PainelBensARDetalhe(BemAR bemAR, boolean emEdicao) {
        this.bemAR = bemAR;
        this.emEdicao = emEdicao;
        if (emEdicao) {
            this.itemInicial = bemAR.obterCopia();
        }
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        this.associarInformacao();
        TransferFocus.patch((Component)this.edtDiscriminacao.getComponenteFoco());
    }

    private void associarInformacao() {
        this.cmbCodigo.setInformacao((Informacao)this.bemAR.getCodigo());
        this.cmbPais.setInformacao((Informacao)this.bemAR.getPais());
        this.edtDiscriminacao.setInformacao((Informacao)this.bemAR.getDiscriminacao());
        this.edtValorAnterior.setInformacao((Informacao)this.bemAR.getValorExercicioAnterior());
        this.edtValorAtual.setInformacao((Informacao)this.bemAR.getValorExercicioAtual());
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_AR_BENS);
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBens().itens().indexOf(this.bemAR);
            ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBens().remove((ObjetoNegocio)this.bemAR);
            ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBens().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getAtividadeRural().getBens().remove((ObjetoNegocio)this.bemAR);
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_AR_BENS);
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.pnlPrincipal = new JPanel();
        this.lblCodigo = new JLabel();
        this.cmbCodigo = new JAutoCompleteEditCodigo();
        this.lblPais = new JLabel();
        this.cmbPais = new JAutoCompleteEditCodigo();
        this.lblDiscriminacao = new JLabel();
        this.edtDiscriminacao = new JEditMemo();
        this.lbSituacaoAnoAnterior = new JLabel();
        this.edtValorAnterior = new JEditValor();
        this.lbSituacaoAnoAtual = new JLabel();
        this.edtValorAtual = new JEditValor();
        this.btnRepetir = new JButton();
        this.lbRepetir = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.lblTitulo.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo.setForeground(new Color(0, 74, 106));
        this.lblTitulo.setText("Dados do Bem");
        this.pnlPrincipal.setBackground(new Color(255, 255, 255));
        this.pnlPrincipal.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblCodigo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCodigo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCodigo.setLabelFor((Component)this.cmbCodigo);
        this.lblCodigo.setText("C\u00f3digo");
        this.lblPais.setFont(FontesUtil.FONTE_NORMAL);
        this.lblPais.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblPais.setLabelFor((Component)this.cmbCodigo);
        this.lblPais.setText("Pa\u00eds");
        this.lblDiscriminacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDiscriminacao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDiscriminacao.setText("Discrimina\u00e7\u00e3o");
        this.edtDiscriminacao.setMaxChars(512);
        this.lbSituacaoAnoAnterior.setFont(FontesUtil.FONTE_NORMAL);
        this.lbSituacaoAnoAnterior.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbSituacaoAnoAnterior.setLabelFor((Component)this.edtValorAnterior);
        this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
        this.lbSituacaoAnoAnterior.setVerticalAlignment(3);
        this.lbSituacaoAnoAnterior.setBorder(null);
        this.lbSituacaoAnoAtual.setFont(FontesUtil.FONTE_NORMAL);
        this.lbSituacaoAnoAtual.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lbSituacaoAnoAtual.setLabelFor((Component)this.edtValorAnterior);
        this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
        this.lbSituacaoAnoAtual.setVerticalAlignment(3);
        this.btnRepetir.setMnemonic('R');
        this.btnRepetir.setText("Repetir");
        this.btnRepetir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelBensARDetalhe.this.btnRepetirActionPerformed(evt);
            }
        });
        this.lbRepetir.setText("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o valor<BR>em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        this.lbRepetir.setVerticalAlignment(1);
        GroupLayout pnlPrincipalLayout = new GroupLayout((Container)this.pnlPrincipal);
        this.pnlPrincipal.setLayout((LayoutManager)pnlPrincipalLayout);
        pnlPrincipalLayout.setHorizontalGroup((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((Component)this.edtDiscriminacao, -2, 643, -2).add((Component)this.cmbCodigo, -2, 659, -2).add((Component)this.lblCodigo).add((Component)this.cmbPais, -2, 659, -2).add((Component)this.lblPais).add((Component)this.lblDiscriminacao).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((Component)this.lbSituacaoAnoAnterior).add((Component)this.edtValorAnterior, -2, 170, -2)).add(2, 2, 2).add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().add((Component)this.edtValorAtual, -2, 170, -2).add(18, 18, 18).add((Component)this.btnRepetir).add(18, 18, 18).add((Component)this.lbRepetir, -2, 219, -2)).add((Component)this.lbSituacaoAnoAtual)))).addContainerGap(35, Short.MAX_VALUE)));
        pnlPrincipalLayout.setVerticalGroup((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().addContainerGap().add((Component)this.lblCodigo).add(2, 2, 2).add((Component)this.cmbCodigo, -2, -1, -2).addPreferredGap(0).add((Component)this.lblPais).add(2, 2, 2).add((Component)this.cmbPais, -2, -1, -2).addPreferredGap(0).add((Component)this.lblDiscriminacao).add(2, 2, 2).add((Component)this.edtDiscriminacao, -2, 103, -2).add(18, 18, 18).add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1, false).add((Component)this.lbSituacaoAnoAtual, -1, 40, Short.MAX_VALUE).add((Component)this.lbSituacaoAnoAnterior, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(3).add((Component)this.edtValorAnterior, -2, -1, -2).add((Component)this.edtValorAtual, -2, -1, -2).add((Component)this.btnRepetir)).add(0, 14, Short.MAX_VALUE)).add((Component)this.lbRepetir, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.cmbCodigo.getAccessibleContext().setAccessibleName("C\u00f3digo");
        this.edtDiscriminacao.getAccessibleContext().setAccessibleName("Discrimina\u00e7\u00e3o");
        this.edtValorAnterior.getAccessibleContext().setAccessibleName("Valor anterior");
        this.edtValorAtual.getAccessibleContext().setAccessibleName("Valor Atual");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblTitulo).add(0, 0, Short.MAX_VALUE)).add((Component)this.pnlPrincipal, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblTitulo).addPreferredGap(0).add((Component)this.pnlPrincipal, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnRepetirActionPerformed(ActionEvent evt) {
        this.edtValorAtual.getInformacao().setConteudo(this.edtValorAnterior.getInformacao().formatado());
    }

    public JComponent getDefaultFocus() {
        return this.cmbCodigo;
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/AR_bens.png");
    }

    public String getTituloPainel() {
        return TITULO;
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public void preExibir() {
        this.alterarLabel();
    }

    private void alterarLabel() {
        if (this.isEspolio()) {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o na data da partilha (R$)");
            this.lbRepetir.setText("<HTML>Se valor na data da partilha for igual<BR>ao valor de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        } else if (this.isSaida()) {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            this.lbSituacaoAnoAtual.setText("<HTML>Situa\u00e7\u00e3o na data da<BR>caracteriza\u00e7\u00e3o de n\u00e3o residente (R$)</HTML>");
            this.lbRepetir.setText("<HTML>Se o valor na data da caracteriza\u00e7\u00e3o de n\u00e3o residente for igual ao valor de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        } else {
            this.lbSituacaoAnoAnterior.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + " (R$)");
            this.lbSituacaoAnoAtual.setText("Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.ANO_BASE + " (R$)");
            this.lbRepetir.setText("<HTML>Repete em 31/12/" + ConstantesGlobais.ANO_BASE + " o valor<BR>em reais de 31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR + "</HTML>");
        }
    }

    private boolean isEspolio() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio();
    }

    private boolean isSaida() {
        return IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida();
    }
}

