/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.brasil.MesReceitaDespesa;
import serpro.ppgd.irpf.atividaderural.brasil.ReceitasDespesas;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelReceitasDespesasBrasil
extends IRPFTableModelAb {
    private static final long serialVersionUID = 1L;
    private static final String TIT_MES = "<html><center>M\u00eas</center></html>";
    private static final String TIT_RECEITA_BRUTA = "<html><center>Receita bruta</center></html>";
    private static final String TIT_DESPESAS = "<html><center>Despesa de custeio <br>e investimento</center></html>";
    private ReceitasDespesas receitasDespesas;

    public TableModelReceitasDespesasBrasil(ReceitasDespesas aReceitasDespesas) {
        super((ObjetoNegocio)aReceitasDespesas);
        this.receitasDespesas = aReceitasDespesas;
    }

    public void setObjetoNegocio(ObjetoNegocio pObj) {
        super.setObjetoNegocio(pObj);
        this.receitasDespesas = (ReceitasDespesas)pObj;
    }

    public Informacao getInformacaoAt(int row, int col) {
        MesReceitaDespesa mes = null;
        switch (row) {
            case 0: {
                mes = this.receitasDespesas.getJaneiro();
                break;
            }
            case 1: {
                mes = this.receitasDespesas.getFevereiro();
                break;
            }
            case 2: {
                mes = this.receitasDespesas.getMarco();
                break;
            }
            case 3: {
                mes = this.receitasDespesas.getAbril();
                break;
            }
            case 4: {
                mes = this.receitasDespesas.getMaio();
                break;
            }
            case 5: {
                mes = this.receitasDespesas.getJunho();
                break;
            }
            case 6: {
                mes = this.receitasDespesas.getJulho();
                break;
            }
            case 7: {
                mes = this.receitasDespesas.getAgosto();
                break;
            }
            case 8: {
                mes = this.receitasDespesas.getSetembro();
                break;
            }
            case 9: {
                mes = this.receitasDespesas.getOutubro();
                break;
            }
            case 10: {
                mes = this.receitasDespesas.getNovembro();
                break;
            }
            case 11: {
                mes = this.receitasDespesas.getDezembro();
                break;
            }
            case 12: {
                if (col == 1) {
                    return this.receitasDespesas.getTotalReceita();
                }
                return this.receitasDespesas.getTotalDespesas();
            }
            default: {
                throw new IllegalArgumentException("M\u00eas inv\u00e1lido (row)");
            }
        }
        switch (col) {
            case 1: {
                return mes.getReceitaBrutaMensal();
            }
            case 2: {
                return mes.getDespesaCusteioInvestimento();
            }
        }
        throw new IllegalArgumentException("Coluna inv\u00e1lida (col)");
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount() - 1 && columnIndex > 0) {
            String mesLimite;
            Data dtLimite;
            if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isSaida()) {
                String mesCondicaoResidente;
                Saida saida = IRPFFacade.getInstancia().getSaida();
                String mesCondicaoNaoResidente = saida.getDtCondicaoNaoResidente().isVazio() ? "12" : saida.getDtCondicaoNaoResidente().getMes();
                String string = mesCondicaoResidente = saida.getDtCondicaoResidente().isVazio() ? "1" : saida.getDtCondicaoResidente().getMes();
                if (rowIndex > Integer.valueOf(mesCondicaoNaoResidente) - 1) {
                    return false;
                }
                if (rowIndex < Integer.valueOf(mesCondicaoResidente) - 1) {
                    return false;
                }
            } else if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio() && !IRPFFacade.getInstancia().getDeclaracao().getEspolio().isBensInventariarMarcado() && !(dtLimite = IRPFFacade.getInstancia().getEspolio().obterDataLimiteParaCalculos()).isVazio() && !(mesLimite = dtLimite.getMes()).isEmpty() && rowIndex > Integer.valueOf(mesLimite) - 1) {
                return false;
            }
            return !ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isTransmitida();
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount() - 1 && columnIndex > 0) {
            Informacao val = this.getInformacaoAt(rowIndex, columnIndex);
            val.setConteudo((String)aValue);
        }
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return TIT_MES;
            }
            case 1: {
                return TIT_RECEITA_BRUTA;
            }
            case 2: {
                return TIT_DESPESAS;
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return 13;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getCelulaMes(rowIndex);
        }
        return this.getInformacaoAt(rowIndex, columnIndex);
    }
}

