/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.atividaderural;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.atividaderural.MovimentacaoRebanhoCellRenderer;
import serpro.ppgd.irpf.gui.atividaderural.TableModelMovimentacaoRebanho;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableMovimentacaoRebanho
extends IRPFTableAb {
    private static final long serialVersionUID = 1L;
    private static final MovimentacaoRebanho vazio = new MovimentacaoRebanho();

    public TableMovimentacaoRebanho() {
        this.setaDefaultRenderers();
        this.accessibleColumnHeader = new String[]{"C\u00f3digo", "Esp\u00e9cie", "Estoque inicial", "Aquisi\u00e7\u00f5es", "Nascimentos", "Consumo e perdas", "Vendas", "Estoque final"};
        this.accessibleRowHeader = new String[]{"Bovinos e bufalinos", "Su\u00ednos", "Caprinos e ovinos", "Assininos, equinos e muares", "Outros"};
    }

    protected void setaDefaultRenderers() {
        this.setDefaultRenderer(String.class, new MovimentacaoRebanhoCellRenderer());
        this.setDefaultRenderer(Informacao.class, new MovimentacaoRebanhoCellRenderer());
    }

    protected void iniciaModelVazio() {
        this.setModel((TableModel)((Object)new TableModelMovimentacaoRebanho(vazio)));
    }

    public void setObjetoNegocio(ObjetoNegocio obj) {
        ((TableModelMovimentacaoRebanho)((Object)this.getModel())).setMovimentacao((MovimentacaoRebanho)obj);
        super.setObjetoNegocio(obj);
    }

    protected void configuraLayout() {
        super.configuraLayout();
        TableColumnModel tcm = this.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(25);
        tcm.getColumn(1).setPreferredWidth(150);
    }

    protected void executaValidacaoAposEdicao(final int col, final int row) {
        final Informacao info = ((TableModelMovimentacaoRebanho)((Object)this.getModel())).getInformacaoAt(row, col);
        info.validar();
        if (!info.isValido()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableMovimentacaoRebanho.this.selecionaCelula(col, row);
                    String msg = info.getRetornoTodasValidacoes().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
                    info.clear();
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msg, "Aten\u00e7\u00e3o", 1);
                    TableMovimentacaoRebanho.this.editarCelula(row, col);
                }
            });
        }
    }

    public void proximaCelula(int row, int col) {
        if ((col == this.getModel().getColumnCount() - 2 || col == this.getModel().getColumnCount() - 1) && row == this.getModel().getRowCount() - 1) {
            this.selecionaCelula(2, 0);
            this.editarCelula(0, 2);
        } else if (col == this.getModel().getColumnCount() - 2 || col == this.getModel().getColumnCount() - 1) {
            this.selecionaCelula(2, row + 1);
            this.editarCelula(row + 1, 2);
        } else {
            this.selecionaCelula(col + 1, row);
            this.editarCelula(row, col + 1);
        }
    }

    protected TableCellEditor instanciaCellEditor(int col) {
        if (col == 0 || col == 1 || col == 7) {
            return super.instanciaCellEditor(col);
        }
        return this.getEditorDefault();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;
            private int preferredHeight;
            {
                this.preferredHeight = -1;
            }

            private Component getHeaderRenderer(int columnIndex) {
                TableColumn aColumn = this.getColumnModel().getColumn(columnIndex);
                TableCellRenderer renderer = aColumn.getHeaderRenderer();
                if (renderer == null) {
                    renderer = this.getDefaultRenderer();
                }
                return renderer.getTableCellRendererComponent(this.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
            }

            private int getPreferredHeight() {
                if (this.preferredHeight == -1) {
                    this.preferredHeight = 0;
                    TableColumnModel columnModel = this.getColumnModel();
                    for (int column = 0; column < columnModel.getColumnCount(); ++column) {
                        Component comp = this.getHeaderRenderer(column);
                        int rendererHeight = comp.getPreferredSize().height;
                        this.preferredHeight = Math.max(this.preferredHeight, rendererHeight);
                    }
                }
                return this.preferredHeight;
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, this.getPreferredHeight());
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.preferredHeight = -1;
                super.columnAdded(e);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                this.preferredHeight = -1;
                super.columnRemoved(e);
            }
        };
    }
}

