/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.filechooser;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileChooserSelectionMode;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.gui.filechooser.JFCFileFilter;

public class JFCFileChooser
implements FileChooser {
    private final JFileChooser jfc = new JFileChooser();
    private final Map<javax.swing.filechooser.FileFilter, FileFilter> filterMap = new HashMap<javax.swing.filechooser.FileFilter, FileFilter>();

    @Override
    public void addChoosableFileFilter(FileFilter ff) {
        JFCFileFilter jfcFF = new JFCFileFilter(ff);
        this.filterMap.put(jfcFF, ff);
        this.jfc.addChoosableFileFilter(jfcFF);
    }

    @Override
    public void setFileFilter(FileFilter ff) {
        this.jfc.setFileFilter(new JFCFileFilter(ff));
    }

    @Override
    public FileFilter getFileFilter() {
        javax.swing.filechooser.FileFilter jfcFF = this.jfc.getFileFilter();
        return this.filterMap.get(jfcFF);
    }

    @Override
    public File getSelectedFile() {
        return this.jfc.getSelectedFile();
    }

    @Override
    public File[] getSelectedFiles() {
        return this.jfc.getSelectedFiles();
    }

    @Override
    public void setSelectedFile(File f) {
        this.jfc.setSelectedFile(f);
    }

    @Override
    public void setDialogTitle(String title) {
        this.jfc.setDialogTitle(title);
    }

    @Override
    public void setMultiSelectionEnabled(boolean enable) {
        this.jfc.setMultiSelectionEnabled(enable);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.jfc.setCurrentDirectory(dir);
    }

    @Override
    public FileChooserResponse showOpenDialog(Component component) {
        int ret = this.jfc.showOpenDialog(component);
        if (ret == 0) {
            return FileChooserResponse.APPROVE_OPTION;
        }
        return FileChooserResponse.CANCEL_OPTION;
    }

    @Override
    public FileChooserResponse showSaveDialog(Component parent) {
        int ret = this.jfc.showSaveDialog(parent);
        if (ret == 0) {
            return FileChooserResponse.APPROVE_OPTION;
        }
        return FileChooserResponse.CANCEL_OPTION;
    }

    public void setFileView(FileView fv) {
        this.jfc.setFileView(fv);
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean b) {
        this.jfc.setAcceptAllFileFilterUsed(b);
    }

    @Override
    public void setApproveButtonText(String approveButtonText) {
        this.jfc.setApproveButtonText(approveButtonText);
    }

    @Override
    public void setApproveButtonToolTipText(String approveButtonToolTipText) {
        this.jfc.setApproveButtonToolTipText(approveButtonToolTipText);
    }

    @Override
    public void setFileSelectionMode(FileChooserSelectionMode mode) {
        int fileSelectionMode;
        switch (mode) {
            case DIRECTORIES_ONLY: {
                fileSelectionMode = 1;
                break;
            }
            case FILES_ONLY: {
                fileSelectionMode = 0;
                break;
            }
            default: {
                fileSelectionMode = 2;
            }
        }
        this.jfc.setFileSelectionMode(fileSelectionMode);
    }

    static {
        UIManager.put("FileChooser.fileNameLabelText", "Nome do Arquivo:");
        UIManager.put("FileChooser.filesOfTypeLabelText", "Tipo do Arquivo:");
        UIManager.put("FileChooser.detailsViewButtonToolTipText", "Detalhes");
        UIManager.put("FileChooser.listViewButtonToolTipText", "Listar");
        UIManager.put("FileChooser.upFolderToolTipText", "Um n\u00edvel acima");
        UIManager.put("FileChooser.newFolderToolTipText", "Criar nova pasta");
        UIManager.put("FileChooser.homeFolderToolTipText", "\u00c1rea de Trabalho");
        UIManager.put("FileChooser.fileNameHeaderText", "Nome");
        UIManager.put("FileChooser.fileSizeHeaderText", "Tamanho");
        UIManager.put("FileChooser.fileTypeHeaderText", "Tipo");
        UIManager.put("FileChooser.fileDateHeaderText", "Modificado");
        UIManager.put("FileChooser.fileAttrHeaderText", "Atributos");
        UIManager.put("FileChooser.directoryOpenButtonText", "Abrir");
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", "Abrir pasta");
        UIManager.put("FileChooser.cancelButtonText", "Cancelar");
        UIManager.put("FileChooser.cancelButtonToolTipText", "Cancela");
    }
}

