/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.borders;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.util.ColorRoutines;

public class TinyFrameBorder
extends AbstractBorder
implements UIResource {
    public static final int FRAME_BORDER_WIDTH = 3;
    public static final int FRAME_TITLE_HEIGHT = 29;
    public static final int FRAME_INTERNAL_TITLE_HEIGHT = 25;
    public static final int FRAME_PALETTE_TITLE_HEIGHT = 21;
    public static Color buttonUpperDisabledColor;
    public static Color buttonLowerDisabledColor;
    private static final Rectangle theRect;
    private static TinyFrameBorder onlyInstance;
    private Window window;
    private int titleHeight;
    private boolean isActive;

    public static TinyFrameBorder getInstance() {
        if (onlyInstance == null) {
            onlyInstance = new TinyFrameBorder();
        }
        return onlyInstance;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.window = SwingUtilities.getWindowAncestor(c);
        this.isActive = this.window.isActive();
        this.titleHeight = this.window instanceof JFrame ? 29 : (this.window instanceof JDialog ? 29 : 25);
        if (this.isActive) {
            g.setColor(Theme.frameBorderColor.getColor());
        } else {
            g.setColor(Theme.frameBorderDisabledColor.getColor());
        }
        this.drawXpBorder(g, x, y, w, h);
    }

    private void drawXpBorder(Graphics g, int x, int y, int w, int h) {
        g.drawLine(x, y + 6, x, y + h - 1);
        g.drawLine(x + 2, y + this.titleHeight, x + 2, y + h - 3);
        g.drawLine(x + w - 1, y + 6, x + w - 1, y + h - 1);
        g.drawLine(x + w - 3, y + this.titleHeight, x + w - 3, y + h - 3);
        g.drawLine(x + 2, y + h - 3, x + w - 3, y + h - 3);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        if (TinyLookAndFeel.ROBOT != null) {
            int wx = this.window.getLocationOnScreen().x - 4;
            int wy = this.window.getLocationOnScreen().y;
            theRect.setBounds(wx, wy, 4, 4);
            g.drawImage(TinyLookAndFeel.ROBOT.createScreenCapture(theRect), x, y, null);
            wx = this.window.getLocationOnScreen().x + this.window.getWidth() + 1;
            theRect.setBounds(wx, wy, 4, 4);
            g.drawImage(TinyLookAndFeel.ROBOT.createScreenCapture(theRect), x + w - 4, y, null);
        } else {
            g.setColor(Theme.backColor.getColor());
            g.fillRect(0, 0, w, 3);
        }
        if (this.isActive) {
            g.setColor(Theme.frameCaptionColor.getColor());
        } else {
            g.setColor(Theme.frameCaptionDisabledColor.getColor());
        }
        g.drawLine(x + 1, y + this.titleHeight, x + 1, y + h - 2);
        g.drawLine(x + w - 2, y + this.titleHeight, x + w - 2, y + h - 2);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        ColorUIResource c = null;
        c = this.isActive ? Theme.frameBorderColor.getColor() : Theme.frameBorderDisabledColor.getColor();
        g.setColor(ColorRoutines.getAlphaColor(c, 82));
        g.drawLine(x, y + 3, x, y + 3);
        g.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
        g.setColor(ColorRoutines.getAlphaColor(c, 156));
        g.drawLine(x, y + 4, x, y + 4);
        g.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
        g.setColor(ColorRoutines.getAlphaColor(c, 215));
        g.drawLine(x, y + 5, x, y + 5);
        g.drawLine(x + w - 1, y + 5, x + w - 1, y + 5);
        c = this.isActive ? Theme.frameCaptionColor.getColor() : Theme.frameCaptionDisabledColor.getColor();
        int spread1 = Theme.frameSpreadDarkDisabled.getValue();
        int spread2 = Theme.frameSpreadLightDisabled.getValue();
        ColorUIResource borderColor = null;
        if (this.isActive) {
            borderColor = Theme.frameBorderColor.getColor();
            spread1 = Theme.frameSpreadDark.getValue();
            spread2 = Theme.frameSpreadLight.getValue();
        }
        int y2 = 1;
        Color c2 = ColorRoutines.darken(c, 4 * spread1);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 23));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        c2 = ColorRoutines.darken(c, 6 * spread1);
        g.setColor(c2);
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.getAlphaColor(c2, 139));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(c);
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 6 * spread1));
        g.drawLine(x + 1, ++y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 2, y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 2, ++y2, x + 2, y2);
        g.drawLine(x + w - 3, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.drawLine(x + 1, y2, x + 1, y2);
        g.drawLine(x + w - 2, y2, x + w - 2, y2);
        g.setColor(ColorRoutines.darken(c, 4 * spread1));
        g.fillRect(x + 1, ++y2, 2, 2);
        g.fillRect(x + w - 3, y2, 2, 2);
        g.setColor(ColorRoutines.darken(c, 3 * spread1));
        g.fillRect(x + 1, y2 += 2, 2, 4);
        g.fillRect(x + w - 3, y2, 2, 4);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.fillRect(x + 1, y2 += 4, 2, 3);
        g.fillRect(x + w - 3, y2, 2, 3);
        g.setColor(ColorRoutines.darken(c, 1 * spread1));
        g.fillRect(x + 1, y2 += 3, 2, 2);
        g.fillRect(x + w - 3, y2, 2, 2);
        g.setColor(c);
        g.fillRect(x + 1, y2 += 2, 2, 2);
        g.fillRect(x + w - 3, y2, 2, 2);
        g.setColor(ColorRoutines.lighten(c, 2 * spread2));
        g.drawLine(x + 1, y2 += 2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 5 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 6 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 8 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 9 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 10 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.lighten(c, 4 * spread2));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        g.setColor(ColorRoutines.darken(c, 2 * spread1));
        g.drawLine(x + 1, ++y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
        ++y2;
        if (this.isActive) {
            g.setColor(Theme.frameLightColor.getColor());
        } else {
            g.setColor(Theme.frameLightDisabledColor.getColor());
        }
        g.drawLine(x + 1, y2, x + 2, y2);
        g.drawLine(x + w - 2, y2, x + w - 3, y2);
    }

    public Insets getBorderInsets(Component c) {
        Frame f;
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w != null && w instanceof Frame && (f = (Frame)w).getExtendedState() == (f.getExtendedState() | 6)) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(0, 3, 3, 3);
    }

    static {
        theRect = new Rectangle();
    }
}

