/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.util;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import serpro.receitanet.util.Base64;

public class Conversoes {
    private static SimpleDateFormat _xsdDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat _xsdDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static SimpleDateFormat _dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String dateToXsdDate(Date data) {
        return _xsdDateFormatter.format(data);
    }

    public static String dateToXsdDateTime(Date data) {
        return _xsdDateTimeFormatter.format(data);
    }

    public static String dateToString(Date data) {
        return _dateFormatter.format(data);
    }

    public static Date stringToDate(String data) throws ParseException {
        return _dateFormatter.parse(data);
    }

    public static Date xsdDateTimeToDate(String data) throws ParseException {
        return _xsdDateTimeFormatter.parse(data);
    }

    public static Date xsdDateToDate(String data) throws ParseException {
        return _xsdDateFormatter.parse(data);
    }

    public static long longFromBytes(byte[] buffer, int offset, int numBytes) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (numBytes < 1 || numBytes > 8) {
            throw new IllegalArgumentException("Foi pedido um inteiro de " + numBytes + " bytes.");
        }
        if (offset >= buffer.length) {
            throw new IllegalArgumentException("O offset " + offset + " est\u00e1 acima do limite de " + (buffer.length - 1));
        }
        if (offset + numBytes > buffer.length) {
            throw new IllegalArgumentException("O buffer, de tamanho " + buffer.length + " \u00e9 menor que " + (offset + numBytes));
        }
        long valor = 0L;
        int i = offset;
        while (i < offset + numBytes) {
            valor <<= 8;
            valor |= (long)(buffer[i] & 0xFF);
            ++i;
        }
        return valor;
    }

    public static String extrairString(byte[] bytes, int inicio, int tamanho) {
        String saida;
        if (inicio >= bytes.length || tamanho <= 0) {
            return "";
        }
        if (inicio < 0) {
            inicio = 0;
        }
        if (tamanho > bytes.length - inicio) {
            tamanho = bytes.length - inicio;
        }
        try {
            saida = new String(bytes, inicio, tamanho, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            saida = new String(bytes, inicio, tamanho);
        }
        return saida;
    }

    public static String extrairString(byte[] bytes) {
        return Conversoes.extrairString(bytes, 0, bytes.length);
    }

    public static String stringFromBytes(byte[] bytes) {
        return Conversoes.extrairString(bytes, 0, bytes.length);
    }

    public static String stringFromBytes(byte[] bytes, int inicio) {
        return Conversoes.extrairString(bytes, inicio, bytes.length - inicio);
    }

    public static String stringFromBytes(byte[] bytes, int inicio, int tamanho) {
        return Conversoes.extrairString(bytes, inicio, tamanho);
    }

    public static byte[] bytesFromString(String string) {
        byte[] saida;
        try {
            saida = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            saida = string.getBytes();
        }
        return saida;
    }

    public static byte[] UTF8BytesFromString(String string) throws UnsupportedEncodingException {
        byte[] saida = string.getBytes("UTF-8");
        return saida;
    }

    public static String base64StringFromString(String string) {
        return Base64.encodeBytes(Conversoes.bytesFromString(string), 8);
    }

    public static byte[] base64BytesFromString(String string) {
        return Conversoes.bytesFromString(Conversoes.base64StringFromString(string));
    }

    public static byte[] base64BytesFromBytes(byte[] bytes) {
        return Conversoes.bytesFromString(Base64.encodeBytes(bytes, 8));
    }

    public static byte[] bytesFromBase64String(String string) {
        byte[] fonte = Conversoes.bytesFromString(string);
        return Base64.decode(fonte, 0, fonte.length);
    }

    public static byte[] bytesFromBase64Bytes(byte[] bytes) {
        return Base64.decode(bytes, 0, bytes.length);
    }

    public static byte[] bytesFromBase64Bytes(byte[] bytes, int offset, int length) {
        return Base64.decode(bytes, offset, length);
    }

    public static byte[] bytesFromLong(long valor) {
        byte[] s = new byte[8];
        int i = 7;
        while (i >= 0) {
            s[i] = (byte)(valor & 0xFFL);
            valor >>= 8;
            --i;
        }
        return s;
    }

    public static String stringFromBase64String(String string) {
        return Conversoes.stringFromBytes(Conversoes.bytesFromBase64String(string));
    }

    public static byte[] base64BytesFromBytes(byte[] bytes, int offset) {
        return Conversoes.bytesFromString(Base64.encodeBytes(bytes, offset, bytes.length - offset, 8));
    }

    public static String hexStringFromBytes(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                sb.append("0");
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] bytesFromHexString(String stHex) throws NumberFormatException {
        int tamanho = stHex.length();
        byte[] s = new byte[tamanho / 2];
        int i = 0;
        while (i < tamanho / 2) {
            String hexByte = stHex.substring(2 * i, 2 * i + 2);
            int b = Integer.parseInt(hexByte, 16);
            s[i] = (byte)b;
            ++i;
        }
        return s;
    }

    public static String base64StringFromBytes(byte[] bytes) {
        return Conversoes.stringFromBytes(Conversoes.base64BytesFromBytes(bytes));
    }
}

