/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class DialogoOcupado
extends JWindow {
    private boolean duracaoIndeterminada = true;
    private int min = 0;
    private int max = 100;
    private JLabel mensagem;
    private JProgressBar progress;

    public DialogoOcupado() {
        this.buildComponente("");
    }

    public DialogoOcupado(String msg) {
        this.buildComponente(msg);
    }

    public DialogoOcupado(int aMin, int aMax, String msg) {
        this.duracaoIndeterminada = false;
        this.min = aMin;
        this.max = aMax;
        this.buildComponente(msg);
    }

    private void buildComponente(String msg) {
        JPanel content = new JPanel();
        this.progress = new JProgressBar(this.min, this.max);
        this.progress.setIndeterminate(this.duracaoIndeterminada);
        this.mensagem = new JLabel(msg);
        content.setLayout(new BorderLayout());
        content.add((Component)this.progress, "Center");
        content.add((Component)this.mensagem, "South");
        content.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.setContentPane(content);
    }

    public void atualiza(String novaMsg) {
        this.mensagem.setText(novaMsg);
        if (!this.duracaoIndeterminada) {
            this.progress.setValue(this.progress.getValue() + 1);
        }
    }

    public void atualiza() {
        if (!this.duracaoIndeterminada) {
            this.progress.setValue(this.progress.getValue() + 1);
        }
    }

    public void atualiza(int valor, String novaMsg) {
        this.mensagem.setText(novaMsg);
        this.progress.setValue(valor);
    }

    public void atualiza(int valor) {
        this.progress.setValue(valor);
    }

    public void finaliza() {
        this.setVisible(false);
        this.dispose();
    }

    public static DialogoOcupado exibeDialogo() {
        DialogoOcupado dialogo = new DialogoOcupado();
        dialogo.pack();
        dialogo.setSize(250, 30);
        dialogo.setLocationRelativeTo(null);
        dialogo.setVisible(true);
        return dialogo;
    }

    public static DialogoOcupado exibeDialogo(String msg) {
        DialogoOcupado dialogo = new DialogoOcupado(msg);
        dialogo.pack();
        dialogo.setSize(250, 40);
        dialogo.setLocationRelativeTo(null);
        dialogo.setVisible(true);
        return dialogo;
    }

    public static DialogoOcupado exibeDialogo(int min, int max, String msg) {
        DialogoOcupado dialogo = new DialogoOcupado(min, max, msg);
        dialogo.pack();
        dialogo.setSize(250, 40);
        dialogo.setLocationRelativeTo(null);
        dialogo.setVisible(true);
        return dialogo;
    }

    public boolean isDuracaoIndeterminada() {
        return this.duracaoIndeterminada;
    }

    public String getMensagem() {
        return this.mensagem.getText();
    }
}

