/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.updater;

import br.gov.serpro.updater.AtualizacaoException;
import br.gov.serpro.updater.DialogoOcupado;
import br.gov.serpro.updater.ReleaseUpdateProperties;
import br.gov.serpro.updater.ReleaseUpdatePropertiesXMLParser;
import br.gov.serpro.updater.UpdaterUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.IconUIResource;
import javax.xml.parsers.ParserConfigurationException;
import jupar.Downloader;
import jupar.Updater;
import jupar.objects.Modes;
import jupar.objects.Release;
import jupar.parsers.ReleaseXMLParser;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import org.xml.sax.SAXException;

public class PgdUpdater {
    private final Logger logger = Logger.getLogger(PgdUpdater.class.getName());
    protected Downloader.DownloadProgress downloadProgress = null;
    protected String releasePropertiesPath = null;
    private ReleaseUpdateProperties properties = null;
    private File logFile = null;
    protected final String DOWNLOAD_FILE_NAME = "download.xml";
    protected final String UPDATE_FILE_NAME = "update.xml";
    protected final String UPDATE_LOG_FILE_NAME = "update_log.txt";
    public static final String APP_NAME_PARAMETER = "-appName";
    public static final String TEMP_DIR_PARAMETER = "-tempDir";
    public static final String DEST_DIR_PARAMETER = "-destDir";
    public static final String SERVER_ADDRESS_PARAMETER = "-serverAddress";
    public static final String ZIP_FILE_NAME_PARAMETER = "-zipFile";
    public static final String APP_EXECUTE_COMMAND_PARAMETER = "-appComand";
    public static final String APP_EXECUTE_COMMAND_SEPARATOR_PARAMETER = "-appComandSeparator";
    public static final String RELEASE_PROPERTIES_FILE_NAME_PARAMETER = "-releaseUpdateProperties";
    public static final String URL_PARAMETER = "-url";
    public static final String USE_WINDOW_COMMAND = "-W";
    public static final String UPDATE_COMMAND = "-U";
    public static final String DOWNLOAD_COMMAND = "-D";
    public static final String OPEN_BROWSER_COMMAND = "-B";
    public static final String LOG_FILE_PARAMETER = "-logFile";

    public PgdUpdater() {
        this.logger.setUseParentHandlers(false);
    }

    public static void main(String[] args) {
        String serverAddress = null;
        ExecAction action = null;
        String appName = null;
        String tempDir = null;
        String destDir = null;
        String zipName = null;
        String releaseUpdateProperties = null;
        String appComand = null;
        String appComandSeparator = null;
        String url = null;
        String logFile = null;
        PgdUpdater updater = new PgdUpdater();
        String parameter = null;
        int i = 0;
        while (i < args.length) {
            block109: {
                block107: {
                    if (parameter != null) break block107;
                    switch (args[i]) {
                        case "-U": {
                            action = ExecAction.UpdateAction;
                            break;
                        }
                        case "-D": {
                            action = ExecAction.DownloadAction;
                            break;
                        }
                        case "-B": {
                            action = ExecAction.OpenBrowserAction;
                            break;
                        }
                        case "-destDir": 
                        case "-serverAddress": 
                        case "-appComandSeparator": 
                        case "-tempDir": 
                        case "-url": 
                        case "-appName": 
                        case "-appComand": 
                        case "-zipFile": 
                        case "-logFile": 
                        case "-releaseUpdateProperties": {
                            parameter = args[i];
                            break;
                        }
                    }
                    break block109;
                }
                System.out.println("- Parametro de entrada:" + parameter);
                switch (parameter) {
                    case "-appName": {
                        appName = args[i];
                        break;
                    }
                    case "-tempDir": {
                        tempDir = args[i];
                        break;
                    }
                    case "-destDir": {
                        destDir = args[i];
                        break;
                    }
                    case "-serverAddress": {
                        serverAddress = args[i];
                        break;
                    }
                    case "-zipFile": {
                        zipName = args[i];
                        break;
                    }
                    case "-releaseUpdateProperties": {
                        releaseUpdateProperties = args[i];
                        break;
                    }
                    case "-appComand": {
                        appComand = args[i];
                        break;
                    }
                    case "-appComandSeparator": {
                        appComandSeparator = args[i];
                        break;
                    }
                    case "-url": {
                        url = args[i];
                        break;
                    }
                    case "-logFile": {
                        logFile = args[i];
                        break;
                    }
                }
                parameter = null;
            }
            ++i;
        }
        if (logFile != null) {
            try {
                updater.setLogFile(new File(logFile));
            }
            catch (AtualizacaoException e) {
                JOptionPane.showMessageDialog(null, "Ocorreu um erro durante inicializa\u00e7\u00e3o do Atualizador - " + e.getMessage(), "Inicializa\u00e7\u00e3o do Atualizador", 0);
                return;
            }
        }
        String logPath = null;
        try {
            logPath = String.valueOf(updater.obterPastaBase().getAbsolutePath()) + File.separator + updater.UPDATE_LOG_FILE_NAME;
            PrintStream print = new PrintStream(logPath);
            System.setOut(print);
            System.setErr(print);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Ocorreu um erro durante inicializa\u00e7\u00e3o do Atualizador - N\u00e3o foi poss\u00edvel criar arquivo de Log:'" + logPath + "'.", "Inicializa\u00e7\u00e3o do Atualizador", 0);
            e.printStackTrace();
            return;
        }
        if (action == ExecAction.UpdateAction) {
            if (tempDir == null) {
                updater.getLogger().severe("Campo -tempDir n\u00e3o informado.");
                return;
            }
            if (appName == null) {
                updater.getLogger().severe("Campo -appName n\u00e3o informado.");
                return;
            }
            if (destDir == null) {
                updater.getLogger().severe("Campo -destDir n\u00e3o informado.");
                return;
            }
            if (zipName == null) {
                updater.getLogger().severe("Campo -zipFile n\u00e3o informado.");
                return;
            }
            if (releaseUpdateProperties != null) {
                updater.setReleasePropertiesPath(releaseUpdateProperties);
            }
            DialogoOcupado dlg = null;
            try {
                UIManager.setLookAndFeel("net.sf.tinylaf.TinyLookAndFeel");
                URL lUrl = TinyLookAndFeel.class.getResource("/Default-flat.theme");
                Theme.loadTheme(lUrl);
                UIManager.put("OptionPane.okButtonText", "Ok");
                UIManager.put("OptionPane.okButtonMnemonic", "79");
                UIManager.put("OptionPane.errorIcon", new IconUIResource(new ImageIcon(PgdUpdater.class.getResource("/icones/erro.png"))));
                UIManager.put("OptionPane.informationIcon", new IconUIResource(new ImageIcon(PgdUpdater.class.getResource("/icones/info.png"))));
                UIManager.put("OptionPane.warningIcon", new IconUIResource(new ImageIcon(PgdUpdater.class.getResource("/icones/atencao.png"))));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                updater.getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
            try {
                dlg = DialogoOcupado.exibeDialogo("Atualizando arquivos do " + appName + "...");
            }
            catch (Exception e) {
                updater.getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
            try {
                updater.updateFiles(tempDir, destDir, zipName);
                if (dlg != null) {
                    dlg.finaliza();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (dlg != null) {
                    dlg.finaliza();
                }
                String mensagem = null;
                mensagem = e instanceof AtualizacaoException ? "Ocorreu um erro durante a atualiza\u00e7\u00e3o do programa " + appName + "." : e.getMessage();
                updater.getLogger().log(Level.SEVERE, e.getMessage(), e);
                JOptionPane.showMessageDialog(null, mensagem, "Atualizar arquivos do programa " + appName, 0);
                return;
            }
            if (appComand != null) {
                if (appComandSeparator == null) {
                    appComandSeparator = "\\s";
                }
                String[] cmd = appComand.split(appComandSeparator, -1);
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                    processBuilder.start();
                }
                catch (IOException e) {
                    updater.getLogger().log(Level.SEVERE, e.getMessage(), e);
                    JOptionPane.showMessageDialog(null, "Houve um problema ao executar o aplicativo " + appName + ".", "Atualizar arquivos do programa " + appName, 0);
                }
            } else {
                updater.getLogger().info("Atualiza\u00e7\u00e3o de dados realizada com sucesso.");
                JOptionPane.showMessageDialog(null, "Atualiza\u00e7\u00e3o de dados realizada com sucesso.", "Atualizar arquivos do programa " + appName, 1);
            }
        } else if (action == ExecAction.DownloadAction) {
            if (tempDir == null) {
                updater.getLogger().severe("Campo -tempDir n\u00e3o informado.");
            }
            if (serverAddress == null) {
                updater.getLogger().severe("Campo -serverAddress n\u00e3o informado.");
                return;
            }
            if (zipName == null) {
                updater.getLogger().severe("Campo -zipFile n\u00e3o informado.");
                return;
            }
            try {
                updater.executarDownload(serverAddress, tempDir, zipName);
                updater.getLogger().info("Transfer\u00eancia de dados realizada com sucesso.");
                JOptionPane.showMessageDialog(null, "Transfer\u00eancia de dados realizada com sucesso.", "Atualizar arquivos do programa " + appName, 1);
            }
            catch (AtualizacaoException e) {
                updater.getLogger().log(Level.SEVERE, e.getMessage(), e);
                JOptionPane.showMessageDialog(null, e.getMessage(), "Atualizar arquivos do programa " + appName, 0);
            }
        } else if (action == ExecAction.OpenBrowserAction) {
            if (appName == null) {
                updater.getLogger().severe("Campo -appName n\u00e3o informado.");
                return;
            }
            if (url == null) {
                updater.getLogger().severe("Campo -url n\u00e3o informado.");
                return;
            }
            try {
                UpdaterUtil.executarNavegador(url);
            }
            catch (Exception e) {
                updater.getLogger().log(Level.SEVERE, e.getMessage(), e);
                JOptionPane.showMessageDialog(null, "Ocorreu um erro ao tentar abrir o site\ncontendo a nova vers\u00e3o do programa" + appName + ".", "Nova vers\u00e3o do " + appName, 0);
            }
        } else {
            System.out.println("A a\u00e7\u00e3o n\u00e3o foi informada (-U, -D ou -B).");
        }
    }

    private File obterPastaBase() throws AtualizacaoException {
        File pastaBase = null;
        try {
            pastaBase = new File(PgdUpdater.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AtualizacaoException("N\u00e3o \u00e9 poss\u00edvel obter diret\u00f3rio base.", e);
        }
        if (pastaBase.isFile()) {
            pastaBase = pastaBase.getParentFile();
        }
        return pastaBase;
    }

    public ReleaseUpdateProperties getReleaseUpdateProperties() throws AtualizacaoException {
        if (this.releasePropertiesPath != null && new File(this.releasePropertiesPath).exists()) {
            ReleaseUpdatePropertiesXMLParser parse = new ReleaseUpdatePropertiesXMLParser();
            try {
                return parse.parse(this.releasePropertiesPath);
            }
            catch (IOException | InterruptedException | ParserConfigurationException | SAXException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new AtualizacaoException("Erro durante leitura do arquivo " + this.releasePropertiesPath + ".", e);
            }
        }
        return null;
    }

    private void saveReleaseUpdateProperties(ReleaseUpdateProperties releaseProperties) throws AtualizacaoException {
        if (this.releasePropertiesPath != null) {
            File releaseFile = new File(this.releasePropertiesPath);
            StringBuilder conteudo = new StringBuilder("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><information><pubDate>").append("</pubDate><pkgver>").append(releaseProperties.getLatestRelease().getPkgver()).append("</pkgver><pkgrel>").append(releaseProperties.getLatestRelease().getPkgrel()).append("</pkgrel><severity>").append(releaseProperties.getLatestRelease().getSeverity()).append("</severity><queryDate>").append(releaseProperties.getQueryDate()).append("</queryDate><updateStatus>").append((Object)releaseProperties.getUpdateStatus()).append("</updateStatus><extra><message>").append(releaseProperties.getLatestRelease().getMessage()).append("</message></extra></information>");
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(releaseFile), "ISO-8859-1"));){
                    writer.write(conteudo.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new AtualizacaoException("Erro ao salvar arquivo " + releaseFile.getName() + ".", e);
            }
        }
    }

    public void saveRelease(Release release, File releaseFile) throws AtualizacaoException {
        try {
            this.saveRelease(release, new FileOutputStream(releaseFile));
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AtualizacaoException("Erro ao salvar arquivo " + releaseFile.getName() + ".", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveRelease(Release release, OutputStream releaseStream) throws AtualizacaoException {
        StringBuilder conteudo = new StringBuilder("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n").append("<information>\n\t<pubDate>").append(release.getPubDate()).append("</pubDate>\n\t<pkgver>").append(release.getPkgver()).append("</pkgver>\n\t<pkgrel>").append(release.getPkgrel()).append("</pkgrel>\n\t<severity>").append(release.getSeverity()).append("</severity>\n\t<extra>\n\t\t<message>").append(release.getMessage()).append("</message>\n\t\t<files>");
        for (Release.FileInfo fileInfo : release.getFiles().values()) {
            conteudo.append("\n\t\t\t<file>\n\t\t\t\t<fileId>").append(fileInfo.getId());
            conteudo.append("</fileId>\n\t\t\t\t<fileVersion>").append(fileInfo.getVersion());
            conteudo.append("</fileVersion>\n\t\t\t\t<fileHash>").append(fileInfo.getHash());
            conteudo.append("</fileHash>\n\t\t\t\t<filePath>").append(fileInfo.getPath());
            conteudo.append("</filePath>\n\t\t\t\t<filePackageName>").append(fileInfo.getPackName());
            conteudo.append("</filePackageName>\n\t\t\t</file>");
        }
        conteudo.append("\n\t\t</files>\n\t</extra>\n</information>");
        try {
            Throwable throwable = null;
            Iterator<Release.FileInfo> iterator = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(releaseStream, "ISO-8859-1"));){
                writer.write(conteudo.toString());
            }
            catch (Throwable throwable2) {
                void var4_10;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var4_10;
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, iOException.getMessage(), iOException);
            throw new AtualizacaoException("Erro ao salvar arquivo.", iOException);
        }
    }

    public Release verificarVersao(String latestFileUrl, String versao, String release) throws AtualizacaoException {
        Release rl = new Release();
        rl.setPkgver(versao);
        rl.setPkgrel(release);
        Release latest = this.getLatestRelease(latestFileUrl);
        if (latest.compareTo(rl) > 0) {
            this.logger.info("Nova vers\u00e3o encontrada: " + latest.getPkgver() + "_" + latest.getPkgrel() + ".");
            return latest;
        }
        return null;
    }

    public Release getLatestRelease(String latestFileUrl) throws AtualizacaoException {
        ReleaseXMLParser parser = new ReleaseXMLParser();
        Release latest = null;
        try {
            latest = parser.parse(latestFileUrl, Modes.URL);
        }
        catch (IOException | InterruptedException | ParserConfigurationException | SAXException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AtualizacaoException("Ocorreu um erro durante a verifica\u00e7\u00e3o da \u00faltima vers\u00e3o do aplicativo.", e);
        }
        if (this.releasePropertiesPath != null) {
            ReleaseUpdateProperties releaseProperties = new ReleaseUpdateProperties();
            releaseProperties.setLatestRelease(latest);
            releaseProperties.setQueryDate(this.getDateTime(new Date()));
            releaseProperties.setUpdateStatus(ReleaseUpdateProperties.UpdateStatus.NotStarted);
            this.saveReleaseUpdateProperties(releaseProperties);
        }
        return latest;
    }

    public String getDateTime(String patern, Date date) {
        SimpleDateFormat format = new SimpleDateFormat(patern);
        format.setLenient(false);
        return format.format(date);
    }

    public String getDateTime(Date date) {
        return this.getDateTime("YYYYMMddHHmm", date);
    }

    public void resetUpdateStatus() {
        this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.NotStarted);
    }

    protected boolean registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus status) {
        try {
            if (this.releasePropertiesPath != null) {
                if (this.properties == null) {
                    this.properties = this.getReleaseUpdateProperties();
                }
                if (this.properties != null) {
                    this.properties.setUpdateStatus(status);
                    this.saveReleaseUpdateProperties(this.properties);
                    this.logger.info("Registrando estado atual:" + (Object)((Object)status));
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public ReleaseUpdateProperties registerUpdateStatusUpdateNotStarted() throws AtualizacaoException {
        ReleaseUpdateProperties releaseProperties = this.getReleaseUpdateProperties();
        if (releaseProperties != null && releaseProperties.getUpdateStatus() == ReleaseUpdateProperties.UpdateStatus.DownloadCompleted) {
            this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.UpdateNotStarted);
            return releaseProperties;
        }
        return null;
    }

    public void executarDownload(String serverAddress, String tempDir, String zipFileName) throws AtualizacaoException {
        this.executarDownload(serverAddress, tempDir, new String[]{zipFileName});
    }

    public void executarDownload(String serverAddress, String tempDir, String[] zipFilesNames) throws AtualizacaoException {
        this.logger.info("Iniciando download dos pacotes de instala\u00e7\u00e3o: '" + zipFilesNames + "'.");
        this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.Downloading);
        try {
            String conteudoDownload = this.montarArquivoDownloadXml(serverAddress, zipFilesNames);
            this.salvarArquivoXml("download.xml", tempDir, conteudoDownload);
            this.downloadFiles("download.xml", tempDir);
            if (this.downloadProgress == null || !this.downloadProgress.isCanceled()) {
                this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.DownloadCompleted);
            } else {
                this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.DownloadCanceled);
            }
        }
        catch (AtualizacaoException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.DownloadError);
            throw e;
        }
    }

    private void downloadFiles(String downloadXmlFileName, String tempDir) throws AtualizacaoException {
        try {
            Downloader dl = new Downloader();
            if (this.downloadProgress == null) {
                dl.download(String.valueOf(tempDir) + File.separator + downloadXmlFileName, tempDir, Modes.FILE);
            } else {
                dl.download(String.valueOf(tempDir) + File.separator + downloadXmlFileName, tempDir, Modes.FILE, this.downloadProgress);
            }
        }
        catch (IOException | InterruptedException | SAXException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AtualizacaoException("Ocorreu um erro durante a transfer\u00eancia de arquivos do aplicativo.", e);
        }
    }

    public String montarArquivoUpdateXml(String[] filesPaths) {
        StringBuilder strFiles = new StringBuilder("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><update>");
        String[] stringArray = filesPaths;
        int n = filesPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            strFiles.append("<instruction><action>MOVE</action><file>").append(path).append("</file>");
            strFiles.append("<destination>").append(path).append("</destination></instruction>");
            ++n2;
        }
        strFiles.append("</update>");
        return strFiles.toString();
    }

    public void updateFiles(String tempDir, String destDir, String[] zipFilesNames, String[] filesPaths) throws AtualizacaoException {
        String conteudoUpdateXml = this.montarArquivoUpdateXml(filesPaths);
        this.salvarArquivoXml("update.xml", tempDir, conteudoUpdateXml);
        File[] zipFiles = new File[zipFilesNames.length];
        int i = 0;
        while (i < zipFiles.length) {
            zipFiles[i] = new File(String.valueOf(tempDir) + File.separator + zipFilesNames[i]);
            ++i;
        }
        this.updateFiles(tempDir, destDir, zipFiles);
    }

    public void updateFiles(String tempDir, String destDir, String zipName) throws AtualizacaoException {
        File zipFile = new File(String.valueOf(tempDir) + File.separator + zipName);
        this.updateFiles(tempDir, destDir, new File[]{zipFile});
    }

    public void updateFiles(String tempDir, String destDir, File[] zipFiles) throws AtualizacaoException {
        this.logger.info("Iniciando decompacta\u00e7\u00e3o dos arquivos do pacote na pasta tempor\u00e1ria: '" + tempDir + "'.");
        this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.Updtating);
        File[] fileArray = zipFiles;
        int n = zipFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File zipFile = fileArray[n2];
            try {
                ZipHelper zip = new ZipHelper();
                zip.unzip(zipFile, zipFile.getParentFile());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.UpdateError);
                throw new AtualizacaoException("Ocorreu um erro durante a atualiza\u00e7\u00e3o dos arquivos do aplicativo. Erro ocorrido na descompacta\u00e7\u00e3o de arquivos.", e);
            }
            ++n2;
        }
        this.updateFiles(tempDir, destDir);
    }

    public void updateFiles(String tempDir, String destDir) throws AtualizacaoException {
        this.logger.info("Iniciando a atualiza\u00e7\u00e3o dos arquivos.");
        this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.Updtating);
        try {
            Updater update = new Updater();
            update.update("update.xml", tempDir, destDir, Modes.FILE);
            this.deleteFile(new File(tempDir));
            this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.UpdateCompleted);
        }
        catch (IOException | InterruptedException | SAXException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            this.registerUpdateStatus(ReleaseUpdateProperties.UpdateStatus.UpdateError);
            throw new AtualizacaoException("Ocorreu um erro durante a atualiza\u00e7\u00e3o dos arquivos do aplicativo.", e);
        }
    }

    public void deleteFile(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                this.deleteFile(c);
                ++n2;
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    public void salvarArquivoXml(String downloadFileName, String tempDir, String conteudo) throws AtualizacaoException {
        File dir = new File(tempDir);
        if (!dir.exists()) {
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new AtualizacaoException("Ocorreu um erro durante a transfer\u00eancia de arquivos do aplicativo. Erro ao criar diret\u00f3rio tempor\u00e1rio (" + dir.getAbsolutePath() + ").", e);
            }
        }
        File downloadFile = new File(String.valueOf(tempDir) + File.separator + downloadFileName);
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(downloadFile), "ISO-8859-1"));){
                writer.write(conteudo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AtualizacaoException("Ocorreu um erro durante a transfer\u00eancia de arquivos do aplicativo. Erro ao salvar arquivo " + downloadFile.getName() + ".", e);
        }
    }

    public String obterDadosArquivoDownload(String serverAddress, String zipName) {
        return this.montarArquivoDownloadXml(serverAddress, new String[]{zipName});
    }

    public String montarArquivoDownloadXml(String serverAddress, String[] filesNames) {
        StringBuilder strFiles = new StringBuilder("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><download>");
        String[] stringArray = filesNames;
        int n = filesNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            strFiles.append("<file>").append(serverAddress).append(name);
            strFiles.append("</file>");
            ++n2;
        }
        strFiles.append("</download>");
        return strFiles.toString();
    }

    public Downloader.DownloadProgress getDownloadProgress() {
        return this.downloadProgress;
    }

    public void setDownloadProgress(Downloader.DownloadProgress downloadProgress) {
        this.downloadProgress = downloadProgress;
    }

    public String getReleasePropertiesPath() {
        return this.releasePropertiesPath;
    }

    public void setReleasePropertiesPath(String releasePropertiesPath) {
        this.releasePropertiesPath = releasePropertiesPath;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) throws AtualizacaoException {
        String logPath = null;
        logPath = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? logFile.getAbsolutePath().replaceAll("\\/", "\\\\") : logFile.getAbsolutePath().replaceAll("\\\\", "/");
        try {
            Handler[] handlers;
            FileHandler handler = new FileHandler(logPath, true);
            handler.setFormatter(new SimpleFormatter());
            Handler[] handlerArray = handlers = this.logger.getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                this.logger.removeHandler(h);
                ++n2;
            }
            this.logger.addHandler(handler);
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
            throw new AtualizacaoException("N\u00e3o foi poss\u00edvel criar arquivo de Log: '" + logPath + "'.", e);
        }
        this.logFile = logFile;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected static enum ExecAction {
        UpdateAction,
        DownloadAction,
        OpenBrowserAction;

    }

    public class ZipHelper {
        public void zip(File[] files, File outputFile) throws IOException {
            if (files != null && files.length > 0) {
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));
                Stack<File> parentDirs = new Stack<File>();
                this.zipFiles(parentDirs, files, out);
                out.close();
            }
        }

        private void zipFiles(Stack<File> parentDirs, File[] files, ZipOutputStream out) throws IOException {
            byte[] buf = new byte[1024];
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    parentDirs.push(files[i]);
                    this.zipFiles(parentDirs, files[i].listFiles(), out);
                    parentDirs.pop();
                } else {
                    int len;
                    FileInputStream in = new FileInputStream(files[i]);
                    String path = "";
                    for (File parentDir : parentDirs) {
                        path = String.valueOf(path) + parentDir.getName() + "/";
                    }
                    out.putNextEntry(new ZipEntry(String.valueOf(path) + files[i].getName()));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                ++i;
            }
        }

        /*
         * Unable to fully structure code
         */
        public void unzip(File zipFile, File dir) throws IOException {
            zip = null;
            arquivo = null;
            is = null;
            os = null;
            buffer = new byte[1024];
            try {
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!dir.exists() || !dir.isDirectory()) {
                    throw new IOException("O diret\u00f3rio " + dir.getName() + " n\u00e3o \u00e9 um diret\u00f3rio v\u00e1lido");
                }
                zip = new ZipFile(zipFile);
                e = zip.entries();
                while (e.hasMoreElements()) {
                    entrada = e.nextElement();
                    arquivo = new File(dir, entrada.getName());
                    if (entrada.isDirectory() && !arquivo.exists()) {
                        arquivo.mkdirs();
                        continue;
                    }
                    if (!arquivo.getParentFile().exists()) {
                        arquivo.getParentFile().mkdirs();
                    }
                    try {
                        is = zip.getInputStream(entrada);
                        if (arquivo.isDirectory()) continue;
                        os = new FileOutputStream(arquivo);
                        bytesLidos = 0;
                        if (is != null) ** GOTO lbl32
                        throw new ZipException("Erro ao ler a entrada do zip: " + entrada.getName());
lbl-1000:
                        // 1 sources

                        {
                            os.write(buffer, 0, bytesLidos);
lbl32:
                            // 2 sources

                            ** while ((bytesLidos = is.read((byte[])buffer)) > 0)
                        }
lbl33:
                        // 1 sources

                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception var12_14) {}
                        }
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Exception var12_15) {}
                        }
                    }
                }
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (Exception var14_19) {}
                }
            }
        }
    }
}

