/*
 * Decompiled with CFR 0.152.
 */
package jupar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jupar.objects.Instruction;
import jupar.objects.Modes;
import jupar.parsers.UpdateXMLParser;
import org.xml.sax.SAXException;

public class Updater {
    public void update(String instructionsxml, String tmp, Modes mode) throws SAXException, FileNotFoundException, IOException, InterruptedException {
        UpdateXMLParser parser = new UpdateXMLParser();
        for (Instruction instruction : parser.parse(String.valueOf(tmp) + File.separator + instructionsxml, mode)) {
            switch (instruction.getAction()) {
                case MOVE: {
                    this.copy(String.valueOf(tmp) + File.separator + instruction.getFilename(), instruction.getDestination());
                    break;
                }
                case DELETE: {
                    this.delete(instruction.getDestination());
                    break;
                }
                case EXECUTE: {
                    Runtime.getRuntime().exec("java -jar " + tmp + File.separator + instruction.getFilename());
                }
            }
        }
    }

    public void update(String instructionsxml, String tmp, String dstdir, Modes mode) throws SAXException, FileNotFoundException, IOException, InterruptedException {
        UpdateXMLParser parser = new UpdateXMLParser();
        for (Instruction instruction : parser.parse(String.valueOf(tmp) + File.separator + instructionsxml, mode)) {
            switch (instruction.getAction()) {
                case MOVE: {
                    this.copy(String.valueOf(tmp) + File.separator + instruction.getFilename(), String.valueOf(dstdir) + File.separator + instruction.getDestination());
                    break;
                }
                case DELETE: {
                    this.delete(String.valueOf(dstdir) + File.separator + instruction.getDestination());
                    break;
                }
                case EXECUTE: {
                    Runtime.getRuntime().exec("java -jar " + tmp + File.separator + instruction.getFilename());
                }
            }
        }
    }

    private void copy(String source, String destination) throws FileNotFoundException, IOException {
        int length;
        File srcfile = new File(source);
        File dstfile = new File(destination);
        File dstParent = dstfile.getParentFile();
        if (!dstParent.exists()) {
            dstParent.mkdirs();
        }
        FileInputStream in = new FileInputStream(srcfile);
        FileOutputStream out = new FileOutputStream(dstfile);
        byte[] buffer = new byte[512];
        while ((length = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void delete(String filename) {
        File file = new File(filename);
        file.delete();
    }
}

