/*
 * Decompiled with CFR 0.152.
 */
package jupar.parsers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jupar.objects.Modes;
import jupar.objects.Release;
import jupar.parsers.ReleaseXMLParserHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ReleaseXMLParser {
    private int timeout = 5000;

    public Release parse(InputSource source) throws SAXException, IOException, ParserConfigurationException {
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        ReleaseXMLParserHandler handler = new ReleaseXMLParserHandler();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.parse(source);
        return handler.getInfo();
    }

    public Release parse(String filename, Modes mode) throws SAXException, FileNotFoundException, IOException, InterruptedException, ParserConfigurationException {
        InputSource source;
        if (mode == Modes.FILE) {
            source = new InputSource(new FileReader(new File(filename)));
        } else {
            URL u = new URL(filename);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setConnectTimeout(this.getTimeout());
            conn.setReadTimeout(this.getTimeout());
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (InputStream in = conn.getInputStream();){
                    source = new InputSource(new StringReader(new String(in.readAllBytes())));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                conn.disconnect();
            }
        }
        return this.parse(source);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

