/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValidadorNomeIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class IdentificadorDeclaracao
extends ObjetoNegocio
implements Comparable<IdentificadorDeclaracao>,
IdentificadorDeclaracaoXML {
    public static final String DEC_COMPLETA = "0";
    public static final String DEC_SIMPLIFICADA = "1";
    public static final String TP_INICIADA_PGD = "01";
    public static final String TP_TRANSMITIDA_PGD = "01";
    public static final String TP_TRANSMITIDA_MIR_ECAC = "10";
    public static final String TP_TRANSMITIDA_MIR_WEB = "11";
    public static final String TP_TRANSMITIDA_MIR_APP = "12";
    public static final String NUM_RECIBO_VAZIO = "0000000000";
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF");
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private Alfa exercicio = new Alfa((ObjetoNegocio)this, "Exerc\u00edcio", 4);
    private Logico transmitida = new Logico((ObjetoNegocio)this, "");
    private Alfa tipoDeclaracao = new Alfa((ObjetoNegocio)this, "Tipo da Declara\u00e7\u00e3o", 5);
    private Alfa tipoDeclaracaoAES = new Alfa((ObjetoNegocio)this, "Tipo da Declara\u00e7\u00e3o AES", 1);
    private Alfa declaracaoRetificadora = new Alfa((ObjetoNegocio)this, "Que tipo de declara\u00e7\u00e3o voc\u00ea deseja fazer?", 2);
    private Alfa numReciboTransmitido = new Alfa((ObjetoNegocio)this, "N\u00ba do Recibo da Declara\u00e7\u00e3o Transmitido", 12);
    private Alfa numReciboDecRetif = new Alfa((ObjetoNegocio)this, "N\u00ba do Recibo Dec. Anterior", 12);
    private Alfa numeroReciboDecAnterior = new Alfa((ObjetoNegocio)this, "N\u00ba do Recibo Dec. Exerc\u00edcio Anterior", 12);
    private Alfa enderecoDiferente = new Alfa((ObjetoNegocio)this, "Houve altera\u00e7\u00e3o de dados cadastrais?", 2);
    private DataHora dataUltimoAcesso = new DataHora((ObjetoNegocio)this, "Data \u00daltimo Acesso");
    private DataHora dataCriacao = new DataHora((ObjetoNegocio)this, "Data de Cria\u00e7\u00e3o");
    private Alfa versaoBeta = new Alfa();
    private Alfa resultadoDeclaracao = new Alfa((ObjetoNegocio)this, "Resultado da Declara\u00e7\u00e3o");
    private Alfa prepreenchida = new Alfa((ObjetoNegocio)this, "Indica se a declara\u00e7\u00e3o \u00e9 pr\u00e9-preenchida", 1);
    private int numGerado;
    private Alfa tpIniciada = new Alfa((ObjetoNegocio)this, "Onde foi iniciada a declara\u00e7\u00e3o?", 2);
    private Alfa inUtilizouPGD = new Alfa((ObjetoNegocio)this, "Utilizou PGD?", 1);
    private Alfa inUtilizouAPP = new Alfa((ObjetoNegocio)this, "Utilizou APP?", 1);
    private Alfa inUtilizouOnLine = new Alfa((ObjetoNegocio)this, "Utilizou OnLine?", 1);
    private Alfa inUtilizouRascunho = new Alfa((ObjetoNegocio)this, "Utilizou Rascunho?", 1);
    private Alfa inUtilizouAssistidaFontePagadora = new Alfa((ObjetoNegocio)this, "Utilizou Assistida Fonte Pagadora?", 1);
    private Alfa inUtilizouAssistidaPlanoSaude = new Alfa((ObjetoNegocio)this, "Utilizou Assistida Fonte Plano Saude?", 1);
    private Alfa inUtilizouSalvarRecuperarOnLine = new Alfa((ObjetoNegocio)this, "Utilizou Salvar Recuperar OnLine?", 1);
    private Alfa inCLWeb = new Alfa((ObjetoNegocio)this, "Quem importou o carn\u00ea le\u00e3o?", 1);
    private Alfa tpTransmitida = new Alfa((ObjetoNegocio)this, "Onde foi transmitida a declara\u00e7\u00e3o?", 2);
    private Alfa inNovaDeclaracao = new Alfa();
    private transient Alfa inPendencia = new Alfa((ObjetoNegocio)this, "Possui pend\u00eancias de erro?", 1);
    private transient Alfa inCertificavel = new Alfa((ObjetoNegocio)this, "Indicativo se declara\u00e7\u00e3o certific\u00e1vel", 1);
    private transient Alfa inConfiabilidade = new Alfa((ObjetoNegocio)this, "Indicativo em que n\u00edvel de selo gov foi transmitida a declara\u00e7\u00e3o", 1);
    private transient CPF cpfTransmissao = new CPF((ObjetoNegocio)this, "CPF logado no momento da transmiss\u00e3o.");
    private transient Alfa inPerfilCpfTransmissao = new Alfa((ObjetoNegocio)this, "Indicador do Perfil/Papel do CPF no momento da transmiss\u00e3o:", 1);

    public Alfa getTpTransmitida() {
        return this.tpTransmitida;
    }

    public IdentificadorDeclaracao() {
        CacheNI.getInstancia().registrarNINome((NI)this.cpf, this.nome);
        this.versaoBeta.setConteudo("N");
        this.tipoDeclaracao.setConteudo(DEC_COMPLETA);
        this.tipoDeclaracaoAES.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if ((IdentificadorDeclaracao.this.tipoDeclaracaoAES.naoFormatado().equals(TipoDeclaracaoAES.ESPOLIO.getTipo()) || IdentificadorDeclaracao.this.tipoDeclaracaoAES.naoFormatado().equals(TipoDeclaracaoAES.SAIDA.getTipo())) && IdentificadorDeclaracao.this.tipoDeclaracao.naoFormatado().equals(IdentificadorDeclaracao.DEC_SIMPLIFICADA)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("msg_declaracao_simplificada_invalida"), 3);
                }
                return null;
            }
        });
        this.exercicio.setConteudo(ConstantesGlobais.EXERCICIO);
        this.prepreenchida.setConteudo(Logico.NAO);
        this.tpIniciada.setConteudo("01");
        this.inUtilizouPGD.setConteudo(Logico.SIM);
        this.inUtilizouAPP.setConteudo(Logico.NAO);
        this.inUtilizouOnLine.setConteudo(Logico.NAO);
        this.inUtilizouRascunho.setConteudo(Logico.NAO);
        this.inUtilizouAssistidaFontePagadora.setConteudo(Logico.NAO);
        this.inUtilizouAssistidaPlanoSaude.setConteudo(Logico.NAO);
        this.inUtilizouSalvarRecuperarOnLine.setConteudo(Logico.NAO);
        this.inNovaDeclaracao.setConteudo(Logico.NAO);
        this.tipoDeclaracaoAES.setConteudo(TipoDeclaracaoAES.AJUSTE.getTipo());
        this.transmitida.converteEmTipoSimNao(Logico.NAO);
        ValidadorNaoNuloIRPF validadorNaoNuloRetif = new ValidadorNaoNuloIRPF(3);
        validadorNaoNuloRetif.setMensagemValidacao(MensagemUtil.getMensagem("pergunta_dec_retificadora_branco"));
        this.declaracaoRetificadora.addValidador((ValidadorIf)validadorNaoNuloRetif);
        ValidadorNaoNuloIRPF validadorNaoNuloNumRecibo = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (IdentificadorDeclaracao.this.declaracaoRetificadora.naoFormatado().equals(Logico.NAO) || IdentificadorDeclaracao.this.declaracaoRetificadora.isVazio()) {
                    return null;
                }
                if (IdentificadorDeclaracao.this.isEspolio()) {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("num_recibo_dec_retif_espolio_branco"));
                } else if (IdentificadorDeclaracao.this.isSaida()) {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("num_recibo_dec_retif_saida_branco"));
                } else {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("num_recibo_dec_retif_branco", new String[]{ConstantesGlobais.EXERCICIO}));
                }
                return super.validarImplementado();
            }
        };
        this.numReciboDecRetif.addValidador((ValidadorIf)validadorNaoNuloNumRecibo);
        this.numReciboDecRetif.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (IdentificadorDeclaracao.this.declaracaoRetificadora.naoFormatado().equals(Logico.NAO)) {
                    return null;
                }
                if (!this.getInformacao().naoFormatado().equals("000000000000") && Validador.validarNrRecibo((String)this.getInformacao().naoFormatado())) {
                    return null;
                }
                return new RetornoValidacao(MensagemUtil.getMensagem("num_recibo_invalido", new String[]{ConstantesGlobais.EXERCICIO}), this.getSeveridade());
            }
        });
        this.numeroReciboDecAnterior.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!this.getInformacao().naoFormatado().equals("000000000000") && Validador.validarNrRecibo((String)this.getInformacao().naoFormatado())) {
                    return null;
                }
                return new RetornoValidacao(MensagemUtil.getMensagem("num_recibo_ano_anterior_invalido", new String[]{ConstantesGlobais.EXERCICIO_ANTERIOR}), this.getSeveridade());
            }
        });
        this.cpf.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.cpf.addValidador((ValidadorIf)new ValidadorCPF(3){

            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("campo_invalido", new String[]{IdentificadorDeclaracao.this.cpf.getNomeCampo()}));
                return super.validarImplementado();
            }
        });
        this.nome.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("nome_branco")));
        this.nome.addValidador((ValidadorIf)new ValidadorNomeIRPF());
        this.nome.addObservador((Observador)new ObservadorEspacosDuplicados());
        ValidadorNaoNuloIRPF validadorNaoNuloEnderDif = new ValidadorNaoNuloIRPF(3);
        validadorNaoNuloEnderDif.setMensagemValidacao(MensagemUtil.getMensagem("pergunta_mudanca_endereco_branco"));
        this.getEnderecoDiferente().addValidador((ValidadorIf)validadorNaoNuloEnderDif);
    }

    public IdentificadorDeclaracao(String cpf, String recibo) {
        this();
        this.getCpf().setConteudo(cpf);
        this.getNumReciboTransmitido().setConteudo(recibo);
    }

    public String obterIdentificador(String cpf, String recibo) {
        if (recibo == null || recibo.trim().isEmpty()) {
            recibo = NUM_RECIBO_VAZIO;
        }
        return cpf + "-" + recibo;
    }

    public String obterIdentificador() {
        return this.obterIdentificador(this.getCpf().naoFormatado(), this.getNumReciboTransmitido().naoFormatado());
    }

    public Alfa getInNovaDeclaracao() {
        return this.inNovaDeclaracao;
    }

    public boolean isDeclaracaoGerada() {
        return true;
    }

    public String getPathArquivo() {
        String diretorioDadosApp = IRPFUtil.DIR_DADOS;
        String path = diretorioDadosApp + "/" + this.cpf.naoFormatado();
        File flDados = new File(path);
        if (!flDados.exists()) {
            flDados.mkdirs();
        }
        StringBuffer nomeArquivoDec = new StringBuffer();
        nomeArquivoDec.append(path);
        nomeArquivoDec.append("/" + this.obterIdentificador());
        nomeArquivoDec.append(".xml");
        return nomeArquivoDec.toString();
    }

    public URL getPathArquivoAsURL() throws MalformedURLException {
        return new File(this.getPathArquivo()).toURI().toURL();
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Alfa getExercicio() {
        return this.exercicio;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Alfa getDeclaracaoRetificadora() {
        return this.declaracaoRetificadora;
    }

    public Alfa getNumReciboDecRetif() {
        return this.numReciboDecRetif;
    }

    public Alfa getNumReciboTransmitido() {
        return this.numReciboTransmitido;
    }

    public Logico getTransmitida() {
        return this.transmitida;
    }

    public boolean equals(Object obj) {
        return obj instanceof IdentificadorDeclaracao && ((IdentificadorDeclaracao)obj).getCpf().naoFormatado().equals(this.getCpf().naoFormatado()) && ((IdentificadorDeclaracao)obj).getNumReciboTransmitido().naoFormatado().equals(this.getNumReciboTransmitido().naoFormatado());
    }

    public int hashCode() {
        return Objects.hash(this.cpf.naoFormatado(), this.numReciboTransmitido.naoFormatado());
    }

    public Alfa getTipoDeclaracao() {
        return this.tipoDeclaracao;
    }

    public boolean isCompleta() {
        return !this.getTipoDeclaracao().naoFormatado().equals(DEC_SIMPLIFICADA);
    }

    public boolean isRetificadora() {
        return this.getDeclaracaoRetificadora().naoFormatado().equals(Logico.SIM);
    }

    public boolean isOriginal() {
        return this.getDeclaracaoRetificadora().naoFormatado().equals(Logico.NAO);
    }

    public Alfa getEnderecoDiferente() {
        return this.enderecoDiferente;
    }

    public Alfa getNumeroReciboDecAnterior() {
        return this.numeroReciboDecAnterior;
    }

    public int getNumGerado() {
        return this.numGerado;
    }

    @Override
    public int compareTo(IdentificadorDeclaracao idDeclaracao) {
        String nome1 = this.getNome().naoFormatado().toUpperCase();
        String nome2 = idDeclaracao.getNome().naoFormatado().toUpperCase();
        return nome1.compareTo(nome2);
    }

    public Alfa getTipoDeclaracaoAES() {
        return this.tipoDeclaracaoAES;
    }

    public boolean isAjuste() {
        return this.getTipoDeclaracaoAES().naoFormatado().equals(TipoDeclaracaoAES.AJUSTE.getTipo());
    }

    public boolean isEspolio() {
        return this.getTipoDeclaracaoAES().naoFormatado().equals(TipoDeclaracaoAES.ESPOLIO.getTipo());
    }

    public boolean isSaida() {
        return this.getTipoDeclaracaoAES().naoFormatado().equals(TipoDeclaracaoAES.SAIDA.getTipo());
    }

    public DataHora getDataUltimoAcesso() {
        return this.dataUltimoAcesso;
    }

    public DataHora getDataCriacao() {
        return this.dataCriacao;
    }

    public Alfa getResultadoDeclaracao() {
        return this.resultadoDeclaracao;
    }

    public Alfa getPrepreenchida() {
        return this.prepreenchida;
    }

    public Alfa getVersaoBeta() {
        return this.versaoBeta;
    }

    public Alfa getTpIniciada() {
        return this.tpIniciada;
    }

    public Alfa getInUtilizouPGD() {
        return this.inUtilizouPGD;
    }

    public Alfa getInUtilizouAPP() {
        return this.inUtilizouAPP;
    }

    public Alfa getInUtilizouOnLine() {
        return this.inUtilizouOnLine;
    }

    public Alfa getInUtilizouRascunho() {
        return this.inUtilizouRascunho;
    }

    public Alfa getInUtilizouAssistidaFontePagadora() {
        return this.inUtilizouAssistidaFontePagadora;
    }

    public Alfa getInUtilizouAssistidaPlanoSaude() {
        return this.inUtilizouAssistidaPlanoSaude;
    }

    public Alfa getInUtilizouSalvarRecuperarOnLine() {
        return this.inUtilizouSalvarRecuperarOnLine;
    }

    public Alfa getInCLWeb() {
        return this.inCLWeb;
    }

    public Alfa getInPendencia() {
        return this.inPendencia;
    }

    public Alfa getInCertificavel() {
        return this.inCertificavel;
    }

    public Alfa getInConfiabilidade() {
        return this.inConfiabilidade;
    }

    public CPF getCpfTransmissao() {
        return this.cpfTransmissao;
    }

    public Alfa getInPerfilCpfTransmissao() {
        return this.inPerfilCpfTransmissao;
    }

    public boolean isTransmitida() {
        return !NUM_RECIBO_VAZIO.equals(this.getNumReciboTransmitido().naoFormatado());
    }

    public IdentificadorDeclaracao obterCopiaIdentificador() {
        IdentificadorDeclaracao destino = new IdentificadorDeclaracao();
        destino.getCpf().setConteudo(this.getCpf().naoFormatado());
        destino.getDeclaracaoRetificadora().setConteudo(this.getDeclaracaoRetificadora().naoFormatado());
        destino.getEnderecoDiferente().setConteudo(this.getEnderecoDiferente().naoFormatado());
        destino.getExercicio().setConteudo(this.getExercicio().naoFormatado());
        destino.getNome().setConteudo(this.getNome().naoFormatado());
        destino.getNumReciboTransmitido().setConteudo(this.getNumReciboTransmitido().naoFormatado());
        destino.getNumeroReciboDecAnterior().setConteudo(this.getNumeroReciboDecAnterior().naoFormatado());
        destino.getNumReciboDecRetif().setConteudo(this.getNumReciboDecRetif().naoFormatado());
        destino.getTipoDeclaracao().setConteudo(this.getTipoDeclaracao().naoFormatado());
        destino.getTipoDeclaracaoAES().setConteudo(this.getTipoDeclaracaoAES().naoFormatado());
        destino.getTransmitida().setConteudo(this.getTransmitida().naoFormatado());
        destino.getDataUltimoAcesso().setConteudo(this.getDataUltimoAcesso());
        destino.getDataCriacao().setConteudo(this.getDataCriacao());
        destino.getResultadoDeclaracao().setConteudo(this.getResultadoDeclaracao().naoFormatado());
        destino.getPrepreenchida().setConteudo(this.getPrepreenchida().naoFormatado());
        destino.getVersaoBeta().setConteudo(this.getVersaoBeta().naoFormatado());
        destino.getTpIniciada().setConteudo(this.getTpIniciada().naoFormatado());
        destino.getInUtilizouPGD().setConteudo(this.getInUtilizouPGD().naoFormatado());
        destino.getInUtilizouAPP().setConteudo(this.getInUtilizouAPP().naoFormatado());
        destino.getInUtilizouOnLine().setConteudo(this.getInUtilizouOnLine().naoFormatado());
        destino.getInUtilizouRascunho().setConteudo(this.getInUtilizouRascunho().naoFormatado());
        destino.getInUtilizouAssistidaFontePagadora().setConteudo(this.getInUtilizouAssistidaFontePagadora().naoFormatado());
        destino.getInUtilizouAssistidaPlanoSaude().setConteudo(this.getInUtilizouAssistidaPlanoSaude().naoFormatado());
        destino.getInUtilizouSalvarRecuperarOnLine().setConteudo(this.getInUtilizouSalvarRecuperarOnLine().naoFormatado());
        return destino;
    }
}

