/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorCPFDiferenteTitular;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValidadorNomeIRPF;
import serpro.ppgd.irpf.alimentandos.DecisaoJudicial;
import serpro.ppgd.irpf.alimentandos.EscrituracaoPublica;
import serpro.ppgd.irpf.alimentandos.ValidadorAlimentandoIgualDependente;
import serpro.ppgd.irpf.alimentandos.ValidadorAlimentandoRepetido;
import serpro.ppgd.irpf.alimentandos.ValidadorCondicaoResidencia;
import serpro.ppgd.irpf.alimentandos.ValidadorNomeVazio;
import serpro.ppgd.irpf.contribuinte.ValidadorDataNascimento;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosLista;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosTipoProcessoAbas;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Alimentando
extends ObjetoNegocio
implements JEditObjetoNegocioItemIf,
ObjetoFicha {
    public static final String PROP_CAMPO_NOME = "Nome do alimentando";
    public static final String PROP_CAMPO_CPF = "CPF";
    public static final String PROP_CAMPO_CPF_RESPONSAVEL = "Alimentando do:";
    public static final String RESIDENTE_BRASIL = "0";
    public static final String RESIDENTE_EXTERIOR = "1";
    public static final String RESIDENTE_VAZIO = "2";
    public static final String TIPO_PROCESSO_CARTORIO = "C";
    public static final String TIPO_PROCESSO_JUDICIAL = "J";
    public static final String TIPO_PROCESSO_AMBOS = "A";
    public static final String TXT_TIPO_PROCESSO_CARTORIO = "Escritura p\u00fablica";
    public static final String TXT_TIPO_PROCESSO_JUDICIAL = "Decis\u00e3o judicial";
    public static final String TXT_TIPO_PROCESSO_AMBOS = "Escritura p\u00fablica e Decis\u00e3o judicial";
    private String chave = "";
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome do alimentando", 60);
    private Alfa residente = new Alfa((ObjetoNegocio)this, "Residente", 1);
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF");
    private Data dtNascimento = new Data((ObjetoNegocio)this, "Data de nascimento");
    private CPF cpfResponsavel = new CPF((ObjetoNegocio)this, "Alimentando do:");
    private Logico tipoProcesso = new Logico((ObjetoNegocio)this, "Tipo de processo");
    private EscrituracaoPublica escrituraPublica = new EscrituracaoPublica(this, PainelAlimentandosTipoProcessoAbas.TXT_ABA_ESCRITURA_PUBLICA);
    private DecisaoJudicial decisaoJudicial = new DecisaoJudicial(this, PainelAlimentandosTipoProcessoAbas.TXT_ABA_DECISAO_JUDICIAL);
    private WeakReference<DeclaracaoIRPF> refDeclaracao;

    public Alimentando(DeclaracaoIRPF dec) {
        this.refDeclaracao = new WeakReference<DeclaracaoIRPF>(dec);
        CacheNI.getInstancia().registrarNINome((NI)this.cpf, this.nome);
        this.getNome().addValidador((ValidadorIf)new ValidadorNomeVazio(3, this.getDtNascimento(), MensagemUtil.getMensagem("alimentando_nome_branco")));
        this.getNome().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNome().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("alimentando_nome_branco")));
        this.getNome().addValidador((ValidadorIf)new ValidadorNomeIRPF());
        this.getCpf().addValidador((ValidadorIf)new ValidadorCPF(3){

            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("alimentando_cpf_invalido"));
                return super.validarImplementado();
            }
        });
        this.getCpf().addValidador((ValidadorIf)new ValidadorCPFDiferenteTitular(3, MensagemUtil.getMensagem("alimentando_cpf_igual_tit"), dec.getIdentificadorDeclaracao().getCpf()));
        this.getCpf().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("alimentando_cpf_branco")));
        this.getCpf().addValidador((ValidadorIf)new ValidadorAlimentandoRepetido(dec.getAlimentandos()));
        this.getCpf().addValidador((ValidadorIf)new ValidadorAlimentandoIgualDependente(dec.getDependentes()));
        this.getResidente().addValidador((ValidadorIf)new ValidadorCondicaoResidencia(3, MensagemUtil.getMensagem("alimentando_residencia_branco")));
        this.getDtNascimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("alimentando_dt_nasc_branco")));
        this.getDtNascimento().addValidador((ValidadorIf)new ValidadorDataNascimento(3){

            @Override
            public RetornoValidacao validarImplementado() {
                Alimentando.this.getCpf().forcaDisparoObservadores();
                return super.validarImplementado();
            }
        });
        this.getCpfResponsavel().addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("pagamento_beneficiario_branco", new String[]{this.getCpfResponsavel().getNomeCampo()})));
        this.getCpfResponsavel().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Alimentando.this.getCpf().naoFormatado().equals(Alimentando.this.getCpfResponsavel().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("alimentando_responsavel_si_mesmo"));
                }
                return null;
            }
        });
        this.getTipoProcesso().addValidador((ValidadorIf)new ValidadorNaoNulo(3));
        this.montarOpcoesTipoProcesso();
    }

    public void atualizarTipoProcesso() {
        boolean habilitaEscrituraPublica = false;
        boolean habilitaDecisaoJudicial = false;
        if (TIPO_PROCESSO_CARTORIO.equals(this.getTipoProcesso().naoFormatado()) || TIPO_PROCESSO_AMBOS.equals(this.getTipoProcesso().naoFormatado())) {
            habilitaEscrituraPublica = true;
        }
        if (TIPO_PROCESSO_JUDICIAL.equals(this.getTipoProcesso().naoFormatado()) || TIPO_PROCESSO_AMBOS.equals(this.getTipoProcesso().naoFormatado())) {
            habilitaDecisaoJudicial = true;
        }
        this.getEscrituraPublica().getCnpjCartorio().setHabilitado(habilitaEscrituraPublica);
        this.getEscrituraPublica().getNome().setHabilitado(habilitaEscrituraPublica);
        this.getEscrituraPublica().getLivro().setHabilitado(habilitaEscrituraPublica);
        this.getEscrituraPublica().getFolhas().setHabilitado(habilitaEscrituraPublica);
        this.getEscrituraPublica().getUf().setHabilitado(habilitaEscrituraPublica);
        this.getEscrituraPublica().getMunicipio().setHabilitado(habilitaEscrituraPublica);
        this.getEscrituraPublica().getDataLavratura().setHabilitado(habilitaEscrituraPublica);
        this.getDecisaoJudicial().getNumProcessoJudicial().setHabilitado(habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getIdVaraCivil().setHabilitado(habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getComarca().setHabilitado(habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getUf().setHabilitado(habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getDtDecisaoJud().setHabilitado(habilitaDecisaoJudicial);
        this.getEscrituraPublica().getCnpjCartorio().setReadOnly(!habilitaEscrituraPublica);
        this.getEscrituraPublica().getNome().setReadOnly(!habilitaEscrituraPublica);
        this.getEscrituraPublica().getLivro().setReadOnly(!habilitaEscrituraPublica);
        this.getEscrituraPublica().getFolhas().setReadOnly(!habilitaEscrituraPublica);
        this.getEscrituraPublica().getUf().setReadOnly(!habilitaEscrituraPublica);
        this.getEscrituraPublica().getMunicipio().setReadOnly(!habilitaEscrituraPublica);
        this.getEscrituraPublica().getDataLavratura().setReadOnly(!habilitaEscrituraPublica);
        this.getDecisaoJudicial().getNumProcessoJudicial().setReadOnly(!habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getIdVaraCivil().setReadOnly(!habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getComarca().setReadOnly(!habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getUf().setReadOnly(!habilitaDecisaoJudicial);
        this.getDecisaoJudicial().getDtDecisaoJud().setReadOnly(!habilitaDecisaoJudicial);
    }

    private void montarOpcoesTipoProcesso() {
        this.getTipoProcesso().addOpcao(TIPO_PROCESSO_CARTORIO, TXT_TIPO_PROCESSO_CARTORIO);
        this.getTipoProcesso().addOpcao(TIPO_PROCESSO_JUDICIAL, TXT_TIPO_PROCESSO_JUDICIAL);
        this.getTipoProcesso().addOpcao(TIPO_PROCESSO_AMBOS, TXT_TIPO_PROCESSO_AMBOS);
    }

    public Alfa getNome() {
        return this.nome;
    }

    public String toString() {
        return this.nome.naoFormatado();
    }

    public String getConteudo(int i) {
        return this.getNome().formatado();
    }

    public int getTotalAtributos() {
        return 1;
    }

    public int getColunaFiltro() {
        return 0;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public String getClasseFicha() {
        return PainelAlimentandosLista.class.getName();
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Data getDtNascimento() {
        return this.dtNascimento;
    }

    public Alfa getResidente() {
        return this.residente;
    }

    public Logico getTipoProcesso() {
        return this.tipoProcesso;
    }

    public EscrituracaoPublica getEscrituraPublica() {
        return this.escrituraPublica;
    }

    public DecisaoJudicial getDecisaoJudicial() {
        return this.decisaoJudicial;
    }

    public CPF getCpfResponsavel() {
        return this.cpfResponsavel;
    }

    public Alimentando obterCopia() {
        Alimentando copia = new Alimentando(IRPFFacade.getInstancia().getDeclaracao());
        copia.setChave(this.getChave());
        copia.getCpf().setConteudo(this.getCpf());
        copia.getDtNascimento().setConteudo(this.getDtNascimento());
        copia.getNome().setConteudo(this.getNome());
        copia.getResidente().setConteudo(this.getResidente());
        copia.getCpfResponsavel().setConteudo(this.getCpfResponsavel());
        copia.getTipoProcesso().setConteudo(this.getTipoProcesso());
        copia.getEscrituraPublica().getCnpjCartorio().setConteudo(this.getEscrituraPublica().getCnpjCartorio());
        copia.getEscrituraPublica().getNome().setConteudo(this.getEscrituraPublica().getNome());
        copia.getEscrituraPublica().getLivro().setConteudo(this.getEscrituraPublica().getLivro());
        copia.getEscrituraPublica().getFolhas().setConteudo(this.getEscrituraPublica().getFolhas());
        copia.getEscrituraPublica().getUf().setConteudo(this.getEscrituraPublica().getUf());
        copia.getEscrituraPublica().getMunicipio().setConteudo(this.getEscrituraPublica().getMunicipio());
        copia.getEscrituraPublica().getDataLavratura().setConteudo(this.getEscrituraPublica().getDataLavratura());
        copia.getDecisaoJudicial().getNumProcessoJudicial().setConteudo(this.getDecisaoJudicial().getNumProcessoJudicial());
        copia.getDecisaoJudicial().getIdVaraCivil().setConteudo(this.getDecisaoJudicial().getIdVaraCivil());
        copia.getDecisaoJudicial().getComarca().setConteudo(this.getDecisaoJudicial().getComarca());
        copia.getDecisaoJudicial().getUf().setConteudo(this.getDecisaoJudicial().getUf());
        copia.getDecisaoJudicial().getDtDecisaoJud().setConteudo(this.getDecisaoJudicial().getDtDecisaoJud());
        return copia;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Residente")) continue;
            return false;
        }
        return true;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.getResidente());
        retorno.add(this.getNome());
        retorno.add(this.getCpf());
        retorno.add(this.getDtNascimento());
        retorno.add(this.getCpfResponsavel());
        retorno.add(this.getTipoProcesso());
        retorno.addAll(this.getEscrituraPublica().recuperarListaCamposPendencia());
        retorno.addAll(this.getDecisaoJudicial().recuperarListaCamposPendencia());
        return retorno;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        if (!(this.getNome().isVazio() || this.verificaAlimentandoRendAcm() || this.verificaAlimentandoPagamento())) {
            Pendencia p = new Pendencia(2, (Informacao)this.getCpf(), this.getCpf().getNomeCampo(), MensagemUtil.getMensagem("alimentando_nao_dedutivel"), numeroItem);
            p.setClassePainel(this.getClasseFicha());
            retorno.add(p);
        }
        return retorno;
    }

    protected boolean verificaAlimentandoPagamento() {
        ArrayList<String> codigos = new ArrayList<String>();
        codigos.add("");
        codigos.add("01");
        codigos.add("02");
        codigos.add("09");
        codigos.add("10");
        codigos.add("11");
        codigos.add("12");
        codigos.add("13");
        codigos.add("14");
        codigos.add("15");
        codigos.add("16");
        codigos.add("17");
        codigos.add("18");
        codigos.add("19");
        codigos.add("20");
        codigos.add("21");
        codigos.add("22");
        codigos.add("26");
        codigos.add("30");
        codigos.add("31");
        codigos.add("33");
        codigos.add("34");
        DeclaracaoIRPF dec = (DeclaracaoIRPF)((Object)this.refDeclaracao.get());
        List pagamentos = dec.getPagamentos().itens();
        for (ObjetoNegocio objetoNegocio : pagamentos) {
            Pagamento pagamento = (Pagamento)objetoNegocio;
            if (!TIPO_PROCESSO_AMBOS.equals(pagamento.getTipo().naoFormatado()) || !codigos.contains(pagamento.getCodigo().naoFormatado()) || this.getNome().naoFormatado().isEmpty() || !this.getNome().naoFormatado().equals(pagamento.getDependenteOuAlimentando().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    protected boolean verificaAlimentandoRendAcm() {
        DeclaracaoIRPF dec = (DeclaracaoIRPF)((Object)this.refDeclaracao.get());
        List rraDependentes = dec.getRendAcm().getColecaoRendAcmDependente().itens();
        for (ObjetoNegocio obj : rraDependentes) {
            RendAcmDependente racm = (RendAcmDependente)obj;
            List pensoes = racm.getPensaoAlimenticiaQuadroAuxiliar().itens();
            for (ObjetoNegocio objPensoes : pensoes) {
                ItemQuadroPensaoAlimenticia itemPensao = (ItemQuadroPensaoAlimenticia)objPensoes;
                if (this.getNome().naoFormatado().isEmpty() || !itemPensao.getAlimentando().naoFormatado().equals(this.getNome().naoFormatado())) continue;
                return true;
            }
        }
        List rraTitular = dec.getRendAcm().getColecaoRendAcmTitular().itens();
        for (ObjetoNegocio obj : rraTitular) {
            RendAcmTitular racm = (RendAcmTitular)obj;
            List pensoes = racm.getPensaoAlimenticiaQuadroAuxiliar().itens();
            for (ObjetoNegocio objPensoes : pensoes) {
                ItemQuadroPensaoAlimenticia itemPensao = (ItemQuadroPensaoAlimenticia)objPensoes;
                if (this.getNome().naoFormatado().isEmpty() || !itemPensao.getAlimentando().naoFormatado().equals(this.getNome().naoFormatado())) continue;
                return true;
            }
        }
        return false;
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Alimentandos";
    }

    public boolean isTipoProcessoCartorio() {
        return TIPO_PROCESSO_CARTORIO.equals(this.getTipoProcesso().naoFormatado());
    }

    public boolean isTipoProcessoJudicial() {
        return TIPO_PROCESSO_JUDICIAL.equals(this.getTipoProcesso().naoFormatado());
    }

    public boolean isTipoProcessoAmbos() {
        return TIPO_PROCESSO_AMBOS.equals(this.getTipoProcesso().naoFormatado());
    }

    public boolean isTipoProcessoCartorioAmbos() {
        return this.isTipoProcessoCartorio() || this.isTipoProcessoAmbos();
    }

    public boolean isTipoProcessoJudicialAmbos() {
        return this.isTipoProcessoJudicial() || this.isTipoProcessoAmbos();
    }
}

