/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosLista;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Alimentandos
extends Colecao<Alimentando>
implements ObjetoFicha {
    public static final String FICHA = "Alimentandos";
    public static final String CONFIRMADO_SIM = "S";
    public static final String CONFIRMADO_NAO = "N";
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;
    private Alfa confirmacao = new Alfa((ObjetoNegocio)this, "Os alimentandos atendem aos requisitos?", 1);

    public Alimentandos(DeclaracaoIRPF dec) {
        this.setFicha(FICHA);
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
    }

    public void objetoInserido(Alimentando alimentando) {
        this.setFicha(this.getFicha());
    }

    public Alimentando instanciaNovoObjeto() {
        return new Alimentando((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
    }

    public String getNomeAlimentandoByChave(String chave) {
        for (Alimentando a : this.itens()) {
            if (!a.getChave().equals(chave)) continue;
            return a.getNome().formatado();
        }
        return null;
    }

    public String getChaveAlimentandoByNome(String nome) {
        for (Alimentando a : this.itens()) {
            if (!a.getNome().naoFormatado().equals(nome)) continue;
            return a.getChave();
        }
        return null;
    }

    public Alimentando getAlimentandoByNome(String nome) {
        if (nome != null) {
            nome = nome.trim().toUpperCase();
            for (Alimentando a : this.itens()) {
                if (!a.getNome().naoFormatado().toUpperCase().equals(nome)) continue;
                return a;
            }
        }
        return null;
    }

    public Alimentando getAlimentandoByCpf(String cpf) {
        for (Alimentando a : this.itens()) {
            if (!a.getCpf().naoFormatado().equals(cpf)) continue;
            return a;
        }
        return null;
    }

    public boolean isExisteNome(String nome) {
        for (Alimentando a : this.itens()) {
            if (!a.getNome().naoFormatado().equals(nome)) continue;
            return true;
        }
        return false;
    }

    public boolean isExisteCPF(String cpf) {
        for (Alimentando a : this.itens()) {
            if (!a.getCpf().naoFormatado().equals(cpf)) continue;
            return true;
        }
        return false;
    }

    public boolean isNomeDuplicado(String nome) {
        Iterator it = this.itens().iterator();
        int count = 0;
        while (it.hasNext()) {
            Alimentando a = (Alimentando)((Object)it.next());
            if (a.getNome().naoFormatado().isEmpty() || !a.getNome().naoFormatado().equals(nome)) continue;
            if (count > 0) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public boolean existeAlimentandoComNome() {
        for (Alimentando a : this.itens()) {
            if (a.getNome().isVazio()) continue;
            return true;
        }
        return false;
    }

    public boolean confirmaExclusaoRelacionadasAlimentando(String nomeAlimentando) {
        return this.confirmaExclusaoRelacionadasAlimentando(nomeAlimentando, null);
    }

    public boolean confirmaExclusaoRelacionadasAlimentando(String nomeAlimentando, String cpfAlimentando) {
        boolean achouPagamentos = false;
        boolean achouRendAcmTitular = false;
        boolean achouRendAcmDependente = false;
        int qtdFichasUsam = 0;
        IRPFFacade facade = IRPFFacade.getInstancia();
        if (facade.getPagamentos().existePagamentosComAlimentando(nomeAlimentando)) {
            achouPagamentos = true;
            ++qtdFichasUsam;
        }
        if (facade.getColecaoRendAcmTitular().existeRendAcmComAlimentando(nomeAlimentando)) {
            achouRendAcmTitular = true;
            ++qtdFichasUsam;
        }
        if (facade.getColecaoRendAcmDependente().existeRendAcmComAlimentando(nomeAlimentando)) {
            achouRendAcmDependente = true;
            ++qtdFichasUsam;
        }
        String msgExcluirCascata = cpfAlimentando != null && !"".equals(cpfAlimentando) ? "Este alimentando (CPF: " + UtilitariosString.formataCPF((String)cpfAlimentando) + ") \u00e9 utilizado na(s) ficha(s): \n" : "Este alimentando (" + nomeAlimentando + ") \u00e9 utilizado na(s) ficha(s): \n";
        if (achouPagamentos) {
            msgExcluirCascata = msgExcluirCascata + "- Pagamentos \n";
        }
        if (achouRendAcmTitular) {
            msgExcluirCascata = msgExcluirCascata + "- Rendimentos Recebidos Acumuladamente pelo Titular \n";
        }
        if (achouRendAcmDependente) {
            msgExcluirCascata = msgExcluirCascata + "- Rendimentos Recebidos Acumuladamente pelos Dependentes \n";
        }
        boolean achouAlgumEmCascata = achouPagamentos || achouRendAcmTitular || achouRendAcmDependente;
        msgExcluirCascata = msgExcluirCascata + "\nOs dados vinculados ao alimentando ser\u00e3o exclu\u00eddos.\nConfirma a altera\u00e7\u00e3o do alimentando e exclus\u00e3o desses dados?";
        if (!achouAlgumEmCascata) {
            return true;
        }
        if (JOptionPane.showConfirmDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msgExcluirCascata, "Confirma\u00e7\u00e3o", 0) == 0) {
            if (achouPagamentos) {
                facade.getPagamentos().excluirPagamentosComAlimentando(nomeAlimentando);
            }
            if (achouRendAcmTitular) {
                facade.getColecaoRendAcmTitular().excluirRendAcmComAlimentando(nomeAlimentando);
            }
            if (achouRendAcmDependente) {
                facade.getColecaoRendAcmDependente().excluirRendAcmComAlimentando(nomeAlimentando);
            }
            return true;
        }
        return false;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List campos = super.recuperarListaCamposPendencia();
        campos.add(this.confirmacao);
        return campos;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        if (!this.itens().isEmpty() && !this.getConfirmacao().naoFormatado().equals(CONFIRMADO_SIM)) {
            Pendencia p = new Pendencia(3, (Informacao)this.getConfirmacao(), this.getConfirmacao().getNomeCampo(), MensagemUtil.getMensagem("alimentandos_nao_confirmado"), numeroItem);
            p.setClassePainel(this.getClasseFicha());
            retorno.add(p);
        }
        return retorno;
    }

    public String getClasseFicha() {
        return PainelAlimentandosLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return FICHA;
    }

    public Alfa getConfirmacao() {
        return this.confirmacao;
    }

    public boolean possuiDependenteComCPF(String cpfDependente) {
        boolean achou = false;
        for (Alimentando alimentando : this.itens()) {
            if (!alimentando.getCpfResponsavel().naoFormatado().equals(cpfDependente)) continue;
            achou = true;
            break;
        }
        return achou;
    }

    public void excluirAlimentandosComDependente(String cpfDependente) {
        ArrayList<Alimentando> alimentandos = new ArrayList<Alimentando>();
        for (Alimentando alimentando : this.itens()) {
            if (!alimentando.getCpfResponsavel().naoFormatado().equals(cpfDependente)) continue;
            alimentandos.add(alimentando);
        }
        Iterator itAlimentandos = alimentandos.iterator();
        while (itAlimentandos.hasNext()) {
            alimentandos.remove(itAlimentandos.next());
        }
    }
}

