/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.BensAR;
import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.brasil.ARBrasil;
import serpro.ppgd.irpf.atividaderural.exterior.ARExterior;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;

public class AtividadeRural
extends ObjetoNegocio {
    private ARBrasil brasil = new ARBrasil();
    private ARExterior exterior;
    private BensAR bens = new BensAR();
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices = 1L;

    public AtividadeRural(IdentificadorDeclaracao identificadorDeclaracao) {
        this.exterior = new ARExterior(identificadorDeclaracao);
    }

    public ARBrasil getBrasil() {
        return this.brasil;
    }

    public ARExterior getExterior() {
        return this.exterior;
    }

    public BensAR getBens() {
        return this.bens;
    }

    public List<BemAR> getBensBrasil() {
        ArrayList<BemAR> bensBrasil = new ArrayList<BemAR>();
        BemAR bem = null;
        for (ObjetoNegocio on : this.bens.itens()) {
            bem = (BemAR)on;
            if (!bem.getPais().naoFormatado().equals("105")) continue;
            bensBrasil.add(bem);
        }
        return bensBrasil;
    }

    public List<BemAR> getBensExterior() {
        ArrayList<BemAR> bensExterior = new ArrayList<BemAR>();
        BemAR bem = null;
        for (ObjetoNegocio on : this.bens.itens()) {
            bem = (BemAR)on;
            if (bem.getPais().naoFormatado().equals("105")) continue;
            bensExterior.add(bem);
        }
        return bensExterior;
    }

    public void inicializaGeradorIndices() {
        geradorIndices = this.ultimoIndiceGerado.naoFormatado().trim().equals("") ? 1L : Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    public String proximoIndice() {
        Object indiceSTR;
        long indiceGerado = 1L;
        do {
            ++geradorIndices;
            indiceSTR = "00000" + indiceGerado;
        } while (this.isIndiceUtilizado((String)(indiceSTR = ((String)indiceSTR).substring(((String)indiceSTR).length() - 5, ((String)indiceSTR).length()))));
        this.ultimoIndiceGerado.setConteudo((String)indiceSTR);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    private boolean isIndiceUtilizado(String indice) {
        boolean emUso = false;
        for (ImovelAR imovel : this.brasil.getIdentificacaoImovel().itens()) {
            if (!imovel.getIndice().naoFormatado().equals(indice)) continue;
            emUso = true;
            break;
        }
        if (!emUso) {
            for (ImovelAR imovel : this.exterior.getIdentificacaoImovel().itens()) {
                if (!imovel.getIndice().naoFormatado().equals(indice)) continue;
                emUso = true;
                break;
            }
        }
        return emUso;
    }
}

