/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.brasil;

import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.ValidadorCIB;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.UtilitariosString;

public class ImovelARBrasil
extends ImovelAR
implements ObjetoFicha {
    protected Alfa cib = new Alfa(this, "CIB (Nirf)"){

        public String formatado() {
            return UtilitariosString.formataNIRF((String)this.naoFormatado());
        }

        public String getConteudoFormatado() {
            return UtilitariosString.formataNIRF((String)this.asString());
        }

        public void setConteudo(String conteudo) {
            super.setConteudo(UtilitariosString.retiraMascara((String)conteudo.toUpperCase()));
        }

        public void setConteudo(Alfa pValor) {
            this.setConteudo(pValor.naoFormatado().toUpperCase());
        }
    };

    public ImovelARBrasil() {
        this.getCIB().addValidador((ValidadorIf)new ValidadorCIB(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ImovelARBrasil.this.getCodigo().isVazio()) {
                    return null;
                }
                String codigo = ImovelARBrasil.this.getCodigo().getConteudoAtual(0);
                if (!(codigo.trim().equals("10") || codigo.trim().equals("11") || codigo.trim().equals("12") || codigo.trim().equals("13") || codigo.trim().equals("14") || codigo.trim().equals("99"))) {
                    return null;
                }
                this.setMensagemValidacao("O campo indicativo CIB (Nirf) est\u00e1 inv\u00e1lido");
                return super.validarImplementado();
            }
        });
        this.getCIB().setMaximoCaracteres(8);
        this.getCIB().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
    }

    public Alfa getCIB() {
        return this.cib;
    }

    @Override
    public String getNomeAba() {
        return "Brasil";
    }

    @Override
    public String getTituloFichaDashboard() {
        return "Atividade Rural - Dados do Im\u00f3vel Explorado";
    }

    @Override
    public ImovelARBrasil obterCopia() {
        ImovelARBrasil copia = new ImovelARBrasil();
        copia.getCIB().setConteudo(this.getCIB());
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.getNome().setConteudo(this.getNome());
        copia.getLocalizacao().setConteudo(this.getLocalizacao());
        copia.getArea().setConteudo(this.getArea());
        copia.getParticipacao().setConteudo(this.getParticipacao());
        copia.getCondicaoExploracao().setConteudo(this.getCondicaoExploracao());
        copia.getIndice().setConteudo(this.getIndice());
        copia.setParticipantesImovelAR(this.getParticipantesImovelAR().obterCopia());
        return copia;
    }
}

