/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class ItemPercentualParticipacaoInventario
extends ObjetoNegocio {
    private String NOME_CAMPO_NI = "NI do participante no invent\u00e1rio";
    private String NOME_CAMPO_NOME = "Nome do participante no invent\u00e1rio";
    private String NOME_CAMPO_PERCENTUAL = "Percentual de participa\u00e7\u00e3o no invent\u00e1rio";
    private NI ni = new NI((ObjetoNegocio)this, this.NOME_CAMPO_NI);
    private Alfa nome = new Alfa((ObjetoNegocio)this, this.NOME_CAMPO_NOME, 60);
    private ValorPositivo percentual = new ValorPositivo(this, this.NOME_CAMPO_PERCENTUAL, 3, 2);

    public ItemPercentualParticipacaoInventario() {
        CacheNI.getInstancia().registrarNINome(this.ni, this.nome);
        this.ni.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("cpf_cnpj_branco")));
        this.ni.addValidador((ValidadorIf)new ValidadorNI(3, MensagemUtil.getMensagem("cpf_cnpj_invalido")));
        this.percentual.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("bem_percentual_branco")));
        this.percentual.addValidador((ValidadorIf)new ValidadorImpeditivoDefault(MensagemUtil.getMensagem("bem_percentual_invalido")){

            public RetornoValidacao validarImplementado() {
                this.setSeveridade((byte)5);
                if (this.getProximoConteudo() != null && !this.getProximoConteudo().toString().trim().isEmpty() && Double.valueOf(this.getProximoConteudo().toString().replace(',', '.')).compareTo(100.0) > 0) {
                    return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                }
                return null;
            }

            public void acaoOk() {
            }

            public void acaoCancelar() {
            }

            public String getTituloPopup() {
                return "Informa\u00e7\u00e3o";
            }
        });
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.ni);
        lista.add(this.percentual);
        return lista;
    }

    public NI getNi() {
        return this.ni;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public ValorPositivo getPercentual() {
        return this.percentual;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || !informacao.getNomeCampo().equals(this.NOME_CAMPO_NI) && !informacao.getNomeCampo().equals(this.NOME_CAMPO_PERCENTUAL)) continue;
            return false;
        }
        return true;
    }
}

