/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorNumeroProcessoLei14793
extends ValidadorDefault {
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public ValidadorNumeroProcessoLei14793(byte severidade, DeclaracaoIRPF dec) {
        super(severidade);
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
    }

    public RetornoValidacao validarImplementado() {
        String numeroProcesso;
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getBens().getExisteAtualizacaoValorBem().naoFormatado().equals(Logico.SIM) && (numeroProcesso = ((DeclaracaoIRPF)((Object)this.weakDec.get())).getBens().getNumeroProcessoAtualizacaoValorBem().naoFormatado().trim()).length() > 0) {
            int digito2Calculado;
            if (numeroProcesso.length() != 17) {
                return new RetornoValidacao(MensagemUtil.getMensagem("bem_numero_processo_tamanho_invalido", new String[]{((DeclaracaoIRPF)((Object)this.weakDec.get())).getBens().getNumeroProcessoAtualizacaoValorBem().getNomeCampo()}));
            }
            String base = numeroProcesso.substring(0, 15);
            String digitosFornecidos = numeroProcesso.substring(15);
            int digito1Calculado = ValidadorNumeroProcessoLei14793.calcularDigitoVerificador(base);
            String digitosCalculados = "" + digito1Calculado + (digito2Calculado = ValidadorNumeroProcessoLei14793.calcularDigitoVerificador(base + digito1Calculado));
            if (!digitosCalculados.equals(digitosFornecidos)) {
                return new RetornoValidacao(MensagemUtil.getMensagem("bem_numero_processo_dv_invalido", new String[]{((DeclaracaoIRPF)((Object)this.weakDec.get())).getBens().getNumeroProcessoAtualizacaoValorBem().getNomeCampo()}));
            }
            String ano = numeroProcesso.substring(11, 15);
            if (!ConstantesGlobaisIRPF.ANO_LEI_14793.equals(ano)) {
                return new RetornoValidacao(MensagemUtil.getMensagem("bem_numero_processo_ano_invalido"));
            }
        }
        return null;
    }

    private static int calcularDigitoVerificador(String numero) {
        int soma = 0;
        int peso = numero.length() + 1;
        for (int i = 0; i < numero.length(); ++i) {
            int n = Character.getNumericValue(numero.charAt(i));
            soma += n * peso;
            --peso;
        }
        int resto = soma % 11;
        int dv = 11 - resto;
        if (dv >= 10) {
            dv -= 10;
        }
        return dv;
    }

    private static int calcularDigitoVerificadorVelho(String numero) {
        int soma = 0;
        int peso = 2;
        for (int i = numero.length() - 1; i >= 0; --i) {
            int n = Character.getNumericValue(numero.charAt(i));
            soma += n * peso;
            ++peso;
        }
        int resto = soma % 11;
        if (resto == 0 || resto == 1) {
            return 0;
        }
        return 11 - resto;
    }

    public static void main(String[] args) {
        String[] numeros;
        for (String numero : numeros = new String[]{"13032040493202471", "10265393860202412", "13032007916202441", "10265000044202549", "10265000043202502", "10265000042202550", "10040000052022548", "10040000053022592", "13031701425202408"}) {
            String base = numero.substring(0, 15);
            String digitosFornecidos = numero.substring(15);
            int digito1Calculado = ValidadorNumeroProcessoLei14793.calcularDigitoVerificador(base);
            int digito2Calculado = ValidadorNumeroProcessoLei14793.calcularDigitoVerificador(base + digito1Calculado);
            String digitosCalculados = "" + digito1Calculado + digito2Calculado;
            System.out.println("Calculado: " + digitosCalculados + " Fornecido: " + digitosFornecidos);
        }
    }
}

