/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.contribuinte;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.contribuinte.ObservadorDeclaracaoRetificadora;
import serpro.ppgd.irpf.contribuinte.ValidadorCampoEndereco;
import serpro.ppgd.irpf.contribuinte.ValidadorDataNascimento;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.contribuinte.PainelEscolheContribuinte;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCEP;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorData;

public class Contribuinte
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String CODIGO_NATUREZA_OCUPACAO_AUTONOMO = "11";
    public static final String CODIGO_NATUREZA_OCUPACAO_CAPITALISTA = "13";
    public static final String CODIGO_NATUREZA_OCUPACAO_MICROEMPREENDEDOR_INDIVIDUAL = "14";
    public static final String CODIGO_NATUREZA_OCUPACAO_APOSENTADO = "61";
    public static final String CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA = "62";
    public static final String CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL = "71";
    public static final String CODIGO_NATUREZA_OCUPACAO_BOLSISTA = "72";
    public static final String CODIGO_NATUREZA_ESPOLIO = "81";
    public static final String CODIGO_OCUPACAO_PRINCIPAL_TITULAR_CARTORIO = "117";
    public static final String DEFICIENTE_SIM = "S";
    public static final String DEFICIENTE_NAO = "N";
    public static final String POSSUI_CONJUGE_VAZIO = "2";
    public static final String RETORNO_PAIS_SIM = "1";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private Data dataNascimento = new Data((ObjetoNegocio)this, "Data de Nascimento");
    private Alfa tituloEleitor = new Alfa((ObjetoNegocio)this, "T\u00edtulo de Eleitor", 10);
    private Alfa exterior = new Alfa((ObjetoNegocio)this, "Exterior?", 2);
    private CPF cpfProcurador = new CPF((ObjetoNegocio)this, "CPF do procurador");
    private Alfa conjuge = new Alfa((ObjetoNegocio)this, "C\u00f4njuge?", 2);
    private CPF cpfConjuge = new CPF((ObjetoNegocio)this, "CPF do c\u00f4njuge ou companheiro(a)");
    private Codigo tipoLogradouro = new Codigo((ObjetoNegocio)this, "Tipo de Logradouro", CadastroTabelasIRPF.recuperarTiposLogradouro());
    private Alfa logradouro = new Alfa((ObjetoNegocio)this, "Logradouro", 40);
    private Alfa logradouroExt = new Alfa((ObjetoNegocio)this, "Logradouro", 40);
    private Alfa numero = new Alfa((ObjetoNegocio)this, "N\u00famero", 6);
    private Alfa numeroExt = new Alfa((ObjetoNegocio)this, "N\u00famero", 6);
    private Alfa complemento = new Alfa((ObjetoNegocio)this, "Complemento", 21);
    private Alfa complementoExt = new Alfa((ObjetoNegocio)this, "Complemento", 21);
    private Alfa bairro = new Alfa((ObjetoNegocio)this, "Bairro", 19);
    private Alfa bairroExt = new Alfa((ObjetoNegocio)this, "Bairro", 19);
    private Codigo pais = new Codigo((ObjetoNegocio)this, "Pa\u00eds", CadastroTabelasIRPF.recuperarPaisesExterior());
    private Alfa nomePais = new Alfa((ObjetoNegocio)this, "Nome Pa\u00eds", 200);
    private Codigo codigoExterior = new Codigo((ObjetoNegocio)this, "Cod. EX", CadastroTabelasIRPF.recuperarRepresentacoes());
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasIRPF.recuperarUFs(1));
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new ArrayList());
    private Alfa cidade = new Alfa((ObjetoNegocio)this, "Cidade", 40);
    private CEP cep = new CEP((ObjetoNegocio)this, "CEP");
    private CEP cepExt = new CEP((ObjetoNegocio)this, "C\u00f3digo Postal");
    private Alfa ddd = new Alfa((ObjetoNegocio)this, "DDD", 2);
    private Alfa ddi = new Alfa((ObjetoNegocio)this, "DDI", 4);
    private Alfa telefone = new Alfa((ObjetoNegocio)this, "Telefone", 9);
    private Alfa telefoneExt = new Alfa((ObjetoNegocio)this, "Telefone", 11);
    private Codigo naturezaOcupacao = new Codigo((ObjetoNegocio)this, "Natureza da Ocupa\u00e7\u00e3o", CadastroTabelasIRPF.recuperarNaturezasOcupacao());
    private Codigo ocupacaoPrincipal = new Codigo((ObjetoNegocio)this, "Ocupa\u00e7\u00e3o Principal", CadastroTabelasIRPF.recuperarOcupacoesPrincipal());
    private Alfa deficiente = new Alfa((ObjetoNegocio)this, "Um dos declarantes \u00e9 pessoa com doen\u00e7a grave ou portadora de defici\u00eancia f\u00edsica ou mental?", 1);
    private Alfa registroProfissional = new Alfa((ObjetoNegocio)this, "Registro Profissional", 20);
    private Alfa dddCelular = new Alfa((ObjetoNegocio)this, "DDD Celular", 2);
    private Alfa celular = new Alfa((ObjetoNegocio)this, "Celular", 9);
    private Alfa email = new Alfa((ObjetoNegocio)this, "E-mail", 90);
    private String UltimaPaisSelecionadoExterior = "";
    private Alfa processoDigital = new Alfa((ObjetoNegocio)this, "Processo", 17);
    private Data dataRetorno = new Data((ObjetoNegocio)this, "Data de retorno ao pa\u00eds");
    private Alfa retornoPais = new Alfa((ObjetoNegocio)this, "Era residente no exterior e passou a ser residente no Brasil em  " + ConstantesGlobais.ANO_BASE + "?", 2);
    private ValorPositivo prejuizoAnoAnteriorLei14754 = new ValorPositivo(this, "Preju\u00edzo acumulado relativo \u00e0 Lei 14.754/2023");
    private Valor baseCalculoFinalLei14754 = new Valor((ObjetoNegocio)this, "Base de C\u00e1lculo relativo \u00e0 Lei 14.754/2023");
    private ValorPositivo impostoDevidoLei14754 = new ValorPositivo(this, "Imposto Devido relativo \u00e0 Lei 14.754/2023");

    public Contribuinte(final IdentificadorDeclaracao id) {
        this.identificadorDeclaracao = id;
        this.getDeficiente().setConteudo(DEFICIENTE_NAO);
        this.getPais().setConteudo("105");
        this.getPais().setColunaFiltro(1);
        this.getPais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo.toString().trim().isEmpty()) {
                    Contribuinte.this.getPais().setConteudo("105");
                }
            }
        });
        this.getExterior().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Contribuinte.this.getExterior().naoFormatado().equals(Logico.NAO)) {
                    Contribuinte.this.UltimaPaisSelecionadoExterior = Contribuinte.this.pais.naoFormatado();
                    Contribuinte.this.pais.setConteudo("105");
                    Contribuinte.this.ddd.setMaximoCaracteres(2);
                } else {
                    Contribuinte.this.pais.setValidadoresAtivos(false);
                    Contribuinte.this.pais.clear();
                    Contribuinte.this.pais.setValidadoresAtivos(true);
                    Contribuinte.this.ddd.setMaximoCaracteres(4);
                    Contribuinte.this.pais.setConteudo(Contribuinte.this.UltimaPaisSelecionadoExterior);
                    if (ControladorGui.getDemonstrativoAberto() != null) {
                        ControladorGui.getDemonstrativoAberto().getSaida().getPaisResidencia().clear();
                    }
                }
            }
        });
        this.getExterior().setConteudo(Logico.NAO);
        this.getPais().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().naoFormatado().equals(Logico.SIM) && (Contribuinte.this.getPais().isVazio() || Contribuinte.this.getPais().asInteger() == 105)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("pais_branco"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("pais_branco")){

            public RetornoValidacao validarImplementado() {
                if ("105".equals(Contribuinte.this.getPais().formatado())) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getDdd().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getDdd().formatado().trim().length() == 1 && Logico.NAO.equals(Contribuinte.this.exterior.naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ddd_um_digito"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getDddCelular().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getDddCelular().formatado().trim().length() == 1 && Logico.NAO.equals(Contribuinte.this.exterior.naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ddd_um_digito"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getDddCelular().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ddd_celular")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.getCelular().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCelular().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getCelular().formatado().replace(" ", "").length() < 8) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("celular_menor_oito_digitos"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getEmail().setDesprezarMascara(false);
        this.getEmail().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.getEmail().formatado().trim().matches("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("email_invalido"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getUf().setColunaFiltro(1);
        this.getUf().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("uf_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().naoFormatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getUf().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("uf_invalida")));
        this.getUf().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Contribuinte.this.uf.isVazio() || Contribuinte.this.uf.naoFormatado().equals("EX")) {
                    Contribuinte.this.municipio.setColecaoElementoTabela(new ArrayList());
                } else {
                    String strUf = Contribuinte.this.uf.getConteudoAtual(0);
                    Contribuinte.this.municipio.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarMunicipios(strUf, 1));
                }
            }
        });
        this.getDataNascimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("dt_nasc_branco"));
                return super.validarImplementado();
            }
        });
        this.getDataNascimento().addValidador((ValidadorIf)new ValidadorDataNascimento(3));
        this.getTipoLogradouro().setColunaFiltro(1);
        this.getTipoLogradouro().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("tipo_logradouro_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getExterior().formatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getTipoLogradouro().addValidador((ValidadorIf)new ValidadorCodigo(3, "\"" + this.getTipoLogradouro().getNomeCampo() + "\" est\u00e1 em branco."));
        this.getLogradouro().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getLogradouro().addValidador((ValidadorIf)new ValidadorCampoEndereco(3));
        this.getLogradouroExt().addValidador((ValidadorIf)new ValidadorCampoEndereco(3));
        this.getNumero().addValidador((ValidadorIf)new ValidadorCampoEndereco(3));
        this.getNumeroExt().addValidador((ValidadorIf)new ValidadorCampoEndereco(3));
        this.getComplemento().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getComplemento().addValidador((ValidadorIf)new ValidadorCampoEndereco(3));
        this.getBairro().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getBairro().addValidador((ValidadorIf)new ValidadorCampoEndereco(3));
        this.getMunicipio().addValidador((ValidadorIf)new ValidadorCampoEndereco(3));
        this.getMunicipio().setColunaFiltro(1);
        this.getMunicipio().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.SIM)) {
                    return null;
                }
                this.setMensagemValidacao(MensagemUtil.getMensagem("municipio_branco"));
                RetornoValidacao ret = super.validarImplementado();
                return ret;
            }
        });
        this.getMunicipio().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("municipio_branco")));
        this.getCidade().addValidador((ValidadorIf)new ValidadorCampoEndereco(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.NAO)) {
                    return null;
                }
                RetornoValidacao ret = super.validarImplementado();
                return ret;
            }
        });
        this.getCidade().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.NAO)) {
                    return null;
                }
                String msg = MensagemUtil.getMensagem("cidade_exterior_branco");
                RetornoValidacao ret = super.validarImplementado();
                if (ret != null) {
                    ret.setMensagemValidacao(msg);
                }
                return ret;
            }
        });
        this.getCodigoExterior().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.NAO)) {
                    return null;
                }
                String msg = MensagemUtil.getMensagem("codigo_exterior_branco");
                RetornoValidacao ret = super.validarImplementado();
                if (ret != null) {
                    ret.setMensagemValidacao(msg);
                }
                return ret;
            }
        });
        this.getCodigoExterior().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("codigo_exterior_branco")));
        this.getCep().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("cep_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCep().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.SIM)) {
                    return null;
                }
                if (Contribuinte.this.getCep().naoFormatado().equals("00000000")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("cep_invalido"), 3);
                }
                return null;
            }
        });
        this.getCep().addValidador((ValidadorIf)new ValidadorCEP(3){

            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.pais.formatado().equals("105")) {
                    return null;
                }
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno != null) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("cep_invalido"));
                }
                return retorno;
            }
        });
        this.getNaturezaOcupacao().setColunaFiltro(1);
        this.getNaturezaOcupacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.naturezaOcupacao.isVazio() || Contribuinte.this.naturezaOcupacao.getIndiceElementoTabela() == -1) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("natureza_ocup_branco"), 3);
                }
                return super.validarImplementado();
            }
        });
        this.getNaturezaOcupacao().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("natureza_ocup_branco")));
        this.getNaturezaOcupacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Contribuinte.this.ocupacaoPrincipal.setHabilitado(true);
                String codigoNaturezaOcupacaoAtual = Contribuinte.this.naturezaOcupacao.naoFormatado();
                if (codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_CAPITALISTA) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_MICROEMPREENDEDOR_INDIVIDUAL) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_BOLSISTA)) {
                    Contribuinte.this.ocupacaoPrincipal.sinalizaValidoEdit();
                } else if (codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_ESPOLIO)) {
                    Contribuinte.this.ocupacaoPrincipal.clear();
                    Contribuinte.this.ocupacaoPrincipal.setHabilitado(false);
                }
            }
        });
        this.getNaturezaOcupacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Contribuinte.this.getNaturezaOcupacao().formatado().trim().length() == 1) {
                    Object s = Contribuinte.this.getNaturezaOcupacao().formatado().trim();
                    s = "0" + (String)s;
                    Contribuinte.this.getNaturezaOcupacao().setConteudo((String)s);
                }
            }
        });
        this.getNaturezaOcupacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (!Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA.equals(Contribuinte.this.getNaturezaOcupacao().naoFormatado())) {
                    Contribuinte.this.getProcessoDigital().clear();
                }
            }
        });
        this.getNaturezaOcupacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.naturezaOcupacao.isVazio() || Contribuinte.this.naturezaOcupacao.getIndiceElementoTabela() == -1) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("natureza_ocup_branco"), 3);
                }
                return super.validarImplementado();
            }
        });
        this.getProcessoDigital().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String codigoNaturezaOcupacaoAtual = Contribuinte.this.naturezaOcupacao.naoFormatado();
                if (codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA) && Contribuinte.this.processoDigital.naoFormatado().length() > 0 && Contribuinte.this.processoDigital.naoFormatado().length() != 17) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("processo_digital_invalido"), 3);
                }
                return null;
            }
        });
        this.getOcupacaoPrincipal().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Object ocupacao = Contribuinte.this.getOcupacaoPrincipal().formatado().trim();
                while (!((String)ocupacao).equals("") && ((String)ocupacao).length() < 3) {
                    ocupacao = "0" + (String)ocupacao;
                }
                Contribuinte.this.getOcupacaoPrincipal().setConteudo((String)ocupacao);
                if (!Contribuinte.this.isOcupacaoComRegistroProfissionalObrigatorio(id.getTipoDeclaracaoAES().naoFormatado())) {
                    Contribuinte.this.getRegistroProfissional().clear();
                }
            }
        });
        this.getOcupacaoPrincipal().setColunaFiltro(1);
        this.getOcupacaoPrincipal().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String codigoNaturezaOcupacaoAtual = Contribuinte.this.naturezaOcupacao.naoFormatado();
                if (codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_CAPITALISTA) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_MICROEMPREENDEDOR_INDIVIDUAL) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_OCUPACAO_BOLSISTA) || codigoNaturezaOcupacaoAtual.equals(Contribuinte.CODIGO_NATUREZA_ESPOLIO)) {
                    return null;
                }
                if (Contribuinte.this.ocupacaoPrincipal.isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ocup_principal_branco"), 3);
                }
                if (Contribuinte.this.ocupacaoPrincipal.getIndiceElementoTabela() == -1) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ocup_principal_invalido"), 3);
                }
                return null;
            }
        });
        this.getOcupacaoPrincipal().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("ocup_principal_branco")));
        this.getDeclaracaoRetificadora().addObservador((Observador)new ObservadorDeclaracaoRetificadora(this));
        this.getLogradouro().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.NAO) && Contribuinte.this.logradouro.isVazio() && Contribuinte.this.complemento.isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("endereco_branco"), 3);
                }
                return null;
            }
        });
        this.getLogradouroExt().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.exterior.formatado().equals(Logico.NAO) && Contribuinte.this.logradouroExt.isVazio() && Contribuinte.this.complementoExt.isVazio()) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("endereco_branco"), 3);
                }
                return null;
            }
        });
        this.getUf().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.SIM)) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCpfProcurador().addValidador((ValidadorIf)new ValidadorCPF(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.exterior.formatado().equals(Logico.SIM)) {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("cpf_procurador_invalido"));
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCpfProcurador().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.identificadorDeclaracao.isAjuste() && Contribuinte.this.exterior.formatado().equals(Logico.SIM)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getCpfProcurador().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.identificadorDeclaracao.isAjuste() && Contribuinte.this.exterior.formatado().equals(Logico.SIM) && Contribuinte.this.getCpfProcurador().naoFormatado().equals(Contribuinte.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("saida_cpf_procurador_igual_contribuinte"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getConjuge().setConteudo(POSSUI_CONJUGE_VAZIO);
        this.getConjuge().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("pergunta_possui_conjuge_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getConjuge().naoFormatado().trim().isEmpty() || Contribuinte.this.getConjuge().naoFormatado().equals(Contribuinte.POSSUI_CONJUGE_VAZIO)) {
                    return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                }
                return null;
            }
        });
        this.getConjuge().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Contribuinte.this.getConjuge().naoFormatado().equals(Logico.NAO)) {
                    Contribuinte.this.getCpfConjuge().clear();
                }
            }
        });
        this.getCpfConjuge().addValidador((ValidadorIf)new ValidadorCPF(3){

            public RetornoValidacao validarImplementado() {
                this.setMensagemValidacao(MensagemUtil.getMensagem("conjuge_cpf_invalido"));
                return super.validarImplementado();
            }
        });
        this.getCpfConjuge().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Contribuinte.this.getCpfConjuge().naoFormatado().equals(Contribuinte.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("conjuge_cpf_igual_declarante"), 3);
                }
                return null;
            }
        });
        if (id.isAjuste()) {
            this.getRetornoPais().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("pergunta_data_retorno_branco", new String[]{ConstantesGlobais.ANO_BASE})){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (Contribuinte.this.getRetornoPais().naoFormatado().trim().isEmpty()) {
                        return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                    }
                    return null;
                }
            });
        }
        this.getRetornoPais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (Contribuinte.this.getRetornoPais().naoFormatado().equals(Logico.NAO)) {
                    Contribuinte.this.getDataRetorno().clear();
                }
            }
        });
        this.getDataRetorno().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (Logico.SIM.equals(Contribuinte.this.getRetornoPais().naoFormatado())) {
                    super.setMensagemValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getInformacao().getNomeCampoCurto()}));
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getDataRetorno().addValidador((ValidadorIf)new ValidadorData(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno == null) {
                    if (ConstantesGlobais.ANO_BASE.equals(this.getInformacao().naoFormatado().substring(this.getInformacao().naoFormatado().length() - 4))) {
                        return retorno;
                    }
                    return new RetornoValidacao(MensagemUtil.getMensagem("dataRetornoAnoInvalido", new String[]{ConstantesGlobais.ANO_BASE}), 3);
                }
                return retorno;
            }
        });
        if (this.identificadorDeclaracao.isEspolio()) {
            this.getNaturezaOcupacao().setConteudo(CODIGO_NATUREZA_ESPOLIO);
            this.getNaturezaOcupacao().setHabilitado(false);
        }
        this.getPais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Contribuinte.this.getNomePais().setConteudo(Contribuinte.this.getPais().getConteudoAtual(1));
            }
        });
        this.getTelefone().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.getTelefone().formatado().trim().matches("^(\\d)*$")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{"Telefone"}), this.getSeveridade());
                }
                return null;
            }
        });
        this.getTelefoneExt().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!Contribuinte.this.getTelefone().formatado().trim().matches("^(\\d)*$")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{"Telefone Ext."}), this.getSeveridade());
                }
                return null;
            }
        });
        this.setFicha("Identifica\u00e7\u00e3o do Contribuinte");
    }

    public Boolean maiorDe16Anos() {
        String ANO = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 16);
        Data data = new Data();
        data.setConteudo(ANO);
        return !this.getDataNascimento().isVazio() && this.getDataNascimento().maisAntiga(data);
    }

    public Codigo getCodigoExterior() {
        return this.codigoExterior;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public CEP getCep() {
        return this.cep;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public Alfa getDdd() {
        return this.ddd;
    }

    public Alfa getDeclaracaoRetificadora() {
        return this.identificadorDeclaracao.getDeclaracaoRetificadora();
    }

    public Alfa getEnderecoDiferente() {
        return this.identificadorDeclaracao.getEnderecoDiferente();
    }

    public Alfa getExterior() {
        return this.exterior;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Codigo getNaturezaOcupacao() {
        return this.naturezaOcupacao;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public Alfa getNumeroReciboDecAnterior() {
        return this.identificadorDeclaracao.getNumeroReciboDecAnterior();
    }

    public Codigo getOcupacaoPrincipal() {
        return this.ocupacaoPrincipal;
    }

    public Alfa getTelefone() {
        return this.telefone;
    }

    public Alfa getTelefoneExt() {
        return this.telefoneExt;
    }

    public Codigo getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public Alfa getTituloEleitor() {
        return this.tituloEleitor;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public Codigo getUf() {
        return this.uf;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        ArrayList<Informacao> retorno = new ArrayList<Informacao>();
        retorno.add((Informacao)this.identificadorDeclaracao.getDeclaracaoRetificadora());
        retorno.add((Informacao)this.identificadorDeclaracao.getNumReciboDecRetif());
        retorno.add((Informacao)this.identificadorDeclaracao.getNumeroReciboDecAnterior());
        retorno.add((Informacao)this.identificadorDeclaracao.getCpf());
        retorno.add((Informacao)this.identificadorDeclaracao.getNome());
        retorno.add((Informacao)this.identificadorDeclaracao.getEnderecoDiferente());
        retorno.add((Informacao)this.identificadorDeclaracao.getTipoDeclaracaoAES());
        retorno.addAll(this.recuperarCamposInformacao());
        return retorno;
    }

    public Alfa getCidade() {
        return this.cidade;
    }

    public Alfa getNumReciboDecRetif() {
        return this.identificadorDeclaracao.getNumReciboDecRetif();
    }

    public Alfa getLogradouroExt() {
        return this.logradouroExt;
    }

    public Alfa getNumeroExt() {
        return this.numeroExt;
    }

    public Alfa getComplementoExt() {
        return this.complementoExt;
    }

    public Alfa getBairroExt() {
        return this.bairroExt;
    }

    public CEP getCepExt() {
        return this.cepExt;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public Alfa getDdi() {
        return this.ddi;
    }

    public String getClasseFicha() {
        return PainelEscolheContribuinte.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public Alfa getDeficiente() {
        return this.deficiente;
    }

    public CPF getCpfProcurador() {
        return this.cpfProcurador;
    }

    public Alfa getNomePais() {
        return this.nomePais;
    }

    public Alfa getConjuge() {
        return this.conjuge;
    }

    public Alfa getProcessoDigital() {
        return this.processoDigital;
    }

    public CPF getCpfConjuge() {
        return this.cpfConjuge;
    }

    public Alfa getRegistroProfissional() {
        return this.registroProfissional;
    }

    public ValorPositivo getPrejuizoAnoAnteriorLei14754() {
        return this.prejuizoAnoAnteriorLei14754;
    }

    public Valor getBaseCalculoFinalLei14754() {
        return this.baseCalculoFinalLei14754;
    }

    public ValorPositivo getImpostoDevidoLei14754() {
        return this.impostoDevidoLei14754;
    }

    public boolean isOcupacaoComRegistroProfissionalObrigatorio(String tipoDeclaracaoAES) {
        if ("E".equals(tipoDeclaracaoAES)) {
            return false;
        }
        String ocupacao = this.getOcupacaoPrincipal().naoFormatado().trim();
        return ocupacao.equals("225") || ocupacao.equals("226") || ocupacao.equals("229") || ocupacao.equals("230") || ocupacao.equals("231") || ocupacao.equals("232") || ocupacao.equals("255") || ocupacao.equals("241") || ocupacao.equals("355");
    }

    public Alfa getDddCelular() {
        return this.dddCelular;
    }

    public Alfa getCelular() {
        return this.celular;
    }

    public Alfa getRetornoPais() {
        return this.retornoPais;
    }

    public Data getDataRetorno() {
        return this.dataRetorno;
    }

    public Alfa getEmail() {
        return this.email;
    }

    public String getTituloFichaDashboard() {
        return "Identifica\u00e7\u00e3o do Contribuinte";
    }
}

