/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.assistida.informeplanosaude;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.ColecaoItemPagamentoPlanoSaude;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.ColecaoItemReembolsoPlanoSaude;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.HeaderInformePagamentos;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.ItemPagamentoPlanoSaude;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class InformePagamentosPlanoSaude
extends ObjetoNegocio {
    private HeaderInformePagamentos header;
    private ColecaoItemPagamentoPlanoSaude colecaoValorPago;
    private ColecaoItemReembolsoPlanoSaude colecaoValorReembolsado;
    public static final int TIPO_INFORME_TITULAR = 1;
    public static final int TIPO_INFORME_DEPENDENTE = 2;
    private int tipoInforme;

    public InformePagamentosPlanoSaude(DeclaracaoIRPF decAberta) {
        this.setHeader(new HeaderInformePagamentos());
        this.setColecaoValorPago(new ColecaoItemPagamentoPlanoSaude());
        this.setColecaoValorReembolsado(new ColecaoItemReembolsoPlanoSaude());
        this.setTipoInforme(0);
        this.adicionaValidadores();
    }

    public void adicionaValidadores() {
        this.getColecaoValorPago().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                final ItemPagamentoPlanoSaude item = (ItemPagamentoPlanoSaude)((Object)valorNovo);
                item.getTipoBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar()) {
                            RetornoValidacao ret = super.validarImplementado();
                            if (ret != null) {
                                // empty if block
                            }
                            return ret;
                        }
                        return null;
                    }
                });
                item.getNomeBeneficiarioSelecionado().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar() && !item.getTipoBeneficiario().naoFormatado().equals("1")) {
                            RetornoValidacao ret = super.validarImplementado();
                            if (ret != null) {
                                // empty if block
                            }
                            return ret;
                        }
                        return null;
                    }
                });
            }
        });
        this.getColecaoValorReembolsado().addObservador("ObjetoInserido", new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                final ItemPagamentoPlanoSaude item = (ItemPagamentoPlanoSaude)((Object)valorNovo);
                item.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
                item.getTipoBeneficiario().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar()) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
                item.getNomeBeneficiarioSelecionado().addValidador((ValidadorIf)new ValidadorNaoNulo(3){

                    public RetornoValidacao validarImplementado() {
                        if (item.isImportar() && !item.getTipoBeneficiario().naoFormatado().equals("1")) {
                            return super.validarImplementado();
                        }
                        return null;
                    }
                });
            }
        });
    }

    public static boolean validate(String xsdFullFilename, String xmlFullFilename) {
        Source xmlFile = null;
        try {
            xmlFile = new StreamSource(new File(xmlFullFilename));
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File(xsdFullFilename));
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
        }
        catch (SAXException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            return false;
        }
        catch (IOException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public HeaderInformePagamentos getHeader() {
        return this.header;
    }

    public ColecaoItemPagamentoPlanoSaude getColecaoValorPago() {
        return this.colecaoValorPago;
    }

    public void setColecaoValorPago(ColecaoItemPagamentoPlanoSaude colecaoValorPago) {
        this.colecaoValorPago = colecaoValorPago;
    }

    public ColecaoItemReembolsoPlanoSaude getColecaoValorReembolsado() {
        return this.colecaoValorReembolsado;
    }

    public void setColecaoValorReembolsado(ColecaoItemReembolsoPlanoSaude colecaoValorReembolsado) {
        this.colecaoValorReembolsado = colecaoValorReembolsado;
    }

    private void setHeader(HeaderInformePagamentos header) {
        this.header = header;
    }

    public int getTipoInforme() {
        return this.tipoInforme;
    }

    public void setTipoInforme(int tipoInforme) {
        this.tipoInforme = tipoInforme;
    }
}

