/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.assistida.informerendimentos;

import java.util.List;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ItemRendIsentoOuTributacaoExclusiva
extends ObjetoNegocio
implements Comparable<ItemRendIsentoOuTributacaoExclusiva> {
    private Alfa codigo = new Alfa((ObjetoNegocio)this, "C\u00f3digo de Tipo de Rendimento");
    private Alfa descricao = new Alfa((ObjetoNegocio)this, "Descri\u00e7\u00e3o de Tipo de Rendimento");
    private Valor valor = new Valor((ObjetoNegocio)this, "Valor");
    private Valor decimoTerceiro = new Valor((ObjetoNegocio)this, "13\u00ba sal\u00e1rio");
    private ValorPositivo impostoRendaRetidoFonte = new ValorPositivo(this, "IRRF");
    private ValorPositivo impostoRendaRetidoFonteDecimoTerceiro = new ValorPositivo(this, "IRRF sobre o 13\u00ba Sal\u00e1rio");
    private ValorPositivo previdenciaOficial = new ValorPositivo(this, "Previd\u00eancia Oficial");
    public static final int TIPO_RENDIMENTO_ISENTO = 1;
    public static final int TIPO_RENDIMENTO_TRIBUTACAO_EXCLUSIVA = 2;
    public static final int TIPO_REND_ISENTO_PENSAO = 1;
    public static final int TIPO_REND_ISENTO_MOLESTIA_GRAVE = 2;
    public static final int TIPO_REND_ISENTO_LUCROS_DIVIDENDOS = 3;
    public static final int TIPO_REND_ISENTO_MICROEMPRESA = 4;
    public static final int TIPO_REND_ISENTO_RECISAO = 5;
    public static final int TIPO_REND_ISENTO_BOLSA_ESTUDO_MEDICO = 7;
    public static final int TIPO_REND_ISENTO_BOLSA_ESTUDO_DOACAO = 8;
    public static final int TIPO_REND_ISENTO_IR_ANTERIORES = 9;
    public static final int TIPO_REND_ISENTO_AJUDA_CUSTO = 10;
    public static final int TIPO_REND_ISENTO_AJUDA_CUSTO_TRADUZIDO = 110;
    public static final int TIPO_REND_ISENTO_ABONO_PECUNIARIO = 11;
    public static final int TIPO_REND_ISENTO_ABONO_PECUNIARIO_TRADUZIDO = 111;
    public static final int TIPO_REND_OUTROS = 100;
    public static final int TIPO_REND_EXCL_JUROS_CAPITAL = 1;
    public static final int TIPO_REND_EXCL_LUCROS = 2;

    public ItemRendIsentoOuTributacaoExclusiva() {
        this.codigo.setConteudo(String.valueOf(100));
    }

    public Alfa getCodigo() {
        return this.codigo;
    }

    public Alfa getDescricao() {
        return this.descricao;
    }

    public Valor getValor() {
        return this.valor;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    @Override
    public int compareTo(ItemRendIsentoOuTributacaoExclusiva o) {
        int n2;
        int n1;
        try {
            n1 = Integer.valueOf(this.getCodigo().naoFormatado());
            n2 = Integer.valueOf(o.getCodigo().naoFormatado());
        }
        catch (Exception e) {
            n1 = 100;
            n2 = 100;
        }
        if (n1 > n2) {
            return 1;
        }
        if (n1 < n2) {
            return -1;
        }
        return 0;
    }

    public String getDescricaoPorCodigo(int tipoRendimento) {
        int cod;
        try {
            cod = Integer.valueOf(this.getCodigo().naoFormatado());
        }
        catch (Exception e) {
            cod = 0;
        }
        if (tipoRendimento == 1) {
            return this.getDescricaoRendimentoIsentoPorCodigo(cod);
        }
        if (tipoRendimento == 2) {
            return this.getDescricaoRendimentoTributacaoExclusivaPorCodigo(cod);
        }
        return this.getDescricao().formatado();
    }

    public ValorPositivo getImpostoRendaRetidoFonte() {
        return this.impostoRendaRetidoFonte;
    }

    public ValorPositivo getImpostoRendaRetidoFonteDecimoTerceiro() {
        return this.impostoRendaRetidoFonteDecimoTerceiro;
    }

    public ValorPositivo getPrevidenciaOficial() {
        return this.previdenciaOficial;
    }

    public int obterCodigoRendIsentoPorCodigoInformeRendimentos(int codigoInformeRendimento) {
        int codigoTraduzido = 0;
        switch (codigoInformeRendimento) {
            case 1: {
                codigoTraduzido = 10;
                break;
            }
            case 2: {
                codigoTraduzido = 11;
                break;
            }
            case 3: {
                codigoTraduzido = 9;
                break;
            }
            case 4: {
                codigoTraduzido = 13;
                break;
            }
            case 5: {
                codigoTraduzido = 4;
                break;
            }
            case 7: {
                codigoTraduzido = 2;
                break;
            }
            case 8: {
                codigoTraduzido = 1;
                break;
            }
            case 9: {
                codigoTraduzido = 16;
                break;
            }
            case 10: {
                codigoTraduzido = 110;
                break;
            }
            case 11: {
                codigoTraduzido = 111;
                break;
            }
            case 100: {
                codigoTraduzido = 26;
            }
        }
        return codigoTraduzido;
    }

    public String getDescricaoRendimentoIsentoPorCodigo(int codigoInformeRendimentos) {
        int codTraduzido = this.obterCodigoRendIsentoPorCodigoInformeRendimentos(codigoInformeRendimentos);
        String tipoRendimento = "";
        if (codTraduzido == 110) {
            tipoRendimento = "Di\u00e1rias e ajuda de custo";
        } else if (codTraduzido == 111) {
            tipoRendimento = "Abono pecuni\u00e1rio";
        } else if (codigoInformeRendimentos == 100) {
            tipoRendimento = this.getDescricao().naoFormatado();
        } else {
            List<ElementoTabela> tiposRendimentoIsentos = CadastroTabelasIRPF.recuperarTiposRendimentosIsentos();
            for (ElementoTabela tipo : tiposRendimentoIsentos) {
                if (Integer.valueOf(tipo.getConteudo(0)) != codTraduzido) continue;
                tipoRendimento = tipo.getConteudo(2);
                break;
            }
        }
        return tipoRendimento;
    }

    public String getDescricaoRendimentoTributacaoExclusivaPorCodigo(int codigoInformeRendimentos) {
        int codTraduzido = this.obterCodigoRendimentoTributacaoExclusivaPorCodigoInformeRendimentos(codigoInformeRendimentos);
        String tipoRendimento = "";
        if (codigoInformeRendimentos == 100) {
            tipoRendimento = this.getDescricao().naoFormatado();
        } else {
            List<ElementoTabela> tiposRendimentoTributacaoExclusiva = CadastroTabelasIRPF.recuperarTiposRendimentosTributacaoExclusiva();
            for (ElementoTabela tipo : tiposRendimentoTributacaoExclusiva) {
                if (Integer.valueOf(tipo.getConteudo(0)) != codTraduzido) continue;
                tipoRendimento = tipo.getConteudo(2);
                break;
            }
        }
        return tipoRendimento;
    }

    public int obterCodigoRendimentoTributacaoExclusivaPorCodigoInformeRendimentos(int codigoInformeRendimento) {
        int codigoTraduzido = 0;
        switch (codigoInformeRendimento) {
            case 1: {
                codigoTraduzido = 10;
                break;
            }
            case 2: {
                codigoTraduzido = 11;
                break;
            }
            case 100: {
                codigoTraduzido = 12;
            }
        }
        return codigoTraduzido;
    }
}

