/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.copiaseguranca;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.declaracao.copiaseguranca.FiltroCopiaSeguranca;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFBemVindos;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProgressMonitor;
import serpro.ppgd.irpf.gui.util.ProgressUtil;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.receitanet.Util;

public class ProcessoRestaurarCopiaSeguranca {
    private String arquivoPreSelecionado = null;
    private boolean atualizarDeclaracoesTransmitidas = true;
    private static final String INFORMACAO = "Informa\u00e7\u00e3o";

    public ProcessoRestaurarCopiaSeguranca() {
    }

    public ProcessoRestaurarCopiaSeguranca(String arquivoPreSelecionado) {
        this.arquivoPreSelecionado = arquivoPreSelecionado;
    }

    public void atualizarDeclaracoesTransmitidas(boolean flag) {
        this.atualizarDeclaracoesTransmitidas = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restauraCopiaSeguranca() {
        int i;
        int totalArquivos;
        ProgressMonitor monitor;
        boolean sucesso;
        block25: {
            sucesso = false;
            monitor = null;
            totalArquivos = 0;
            i = 0;
            try {
                FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
                fc.setDialogTitle("Restaura\u00e7\u00e3o de c\u00f3pia de seguran\u00e7a de declara\u00e7\u00e3o");
                fc.setApproveButtonText("OK");
                fc.setApproveButtonToolTipText("Restaura c\u00f3pia de seguran\u00e7a");
                fc.setAcceptAllFileFilterUsed(false);
                fc.setFileFilter((FileFilter)new FiltroCopiaSeguranca());
                fc.setMultiSelectionEnabled(true);
                if (this.arquivoPreSelecionado == null && fc.showOpenDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal()) != FileChooserResponse.APPROVE_OPTION) break block25;
                File[] selectedFiles = this.arquivoPreSelecionado != null ? new File[]{new File(this.arquivoPreSelecionado)} : fc.getSelectedFiles();
                totalArquivos = selectedFiles.length;
                monitor = ProgressUtil.createProgressMonitor((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (int)totalArquivos, (boolean)false, (int)1000, (String)"Restaurando");
                IRPFFacade.setCacheIdDeclaracao(true);
                for (i = 0; i < totalArquivos; ++i) {
                    if (i == 0) {
                        monitor.start("Restaurando " + (i + 1) + " de " + totalArquivos);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception ex) {
                            LogPPGD.erro((String)ex.getMessage());
                        }
                    } else {
                        monitor.setCurrent("Restaurando " + (i + 1) + " de " + totalArquivos, i + 1);
                    }
                    File fileRec = UtilitariosArquivo.getRECCorrespondente((File)selectedFiles[i]);
                    boolean heTransmitida = false;
                    if (fileRec != null && this.controleSRFBate(selectedFiles[i], fileRec)) {
                        this.copiaDecRec(selectedFiles[i], fileRec);
                        sucesso = true;
                        heTransmitida = true;
                    }
                    ImportadorTxt importador = new ImportadorTxt();
                    IdentificadorDeclaracao idDeclaracao = importador.restaurarIdDeclaracao(selectedFiles[i], heTransmitida);
                    boolean confirmacao = true;
                    if (importador.existeDeclaracaoExercicioAtual(selectedFiles[i], false, heTransmitida)) {
                        if (JOptionPane.showConfirmDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem("copia_seg_restauracao_confirmacao", new String[]{idDeclaracao.getCpf().formatado()}), "Confirma\u00e7\u00e3o", 0, 3) != 0) {
                            confirmacao = false;
                        } else {
                            IdentificadorDeclaracao idDeclaracaoAntigo = IRPFFacade.obterIdDeclaracaoTransmitida(idDeclaracao.getCpf().naoFormatado(), idDeclaracao.isOriginal(), heTransmitida);
                            IRPFFacade.excluirDeclaracao(idDeclaracaoAntigo.getCpf().naoFormatado(), idDeclaracaoAntigo.getNumReciboTransmitido().naoFormatado());
                            idDeclaracao.getInNovaDeclaracao().setConteudo(Logico.NAO);
                            IRPFFacade.criarDeclaracao(idDeclaracao);
                        }
                    } else {
                        ProcessoRestaurarCopiaSeguranca.dialogRestauracaoIniciada();
                    }
                    if (!confirmacao) continue;
                    try {
                        DeclaracaoIRPF dec = importador.restaurarDeclaracao(selectedFiles[i], heTransmitida, false);
                        dec.getIdentificadorDeclaracao().getInNovaDeclaracao().setConteudo(Logico.NAO);
                        CacheNI.getInstancia().importarNIs((ObjetoNegocio)dec, false);
                    }
                    catch (GeracaoTxtException e) {
                        LogPPGD.erro((String)e.getMessage());
                        if (idDeclaracao != null) {
                            IRPFFacade.excluirDeclaracao(idDeclaracao);
                        }
                        GuiUtil.mostrarErro((String)"erro_restaurar");
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogPPGD.erro((String)e.getMessage());
                        if (idDeclaracao != null) {
                            IRPFFacade.excluirDeclaracao(idDeclaracao);
                        }
                        GuiUtil.mostrarErro((String)"erro_inesperado_restaurar");
                        break;
                    }
                    sucesso = true;
                }
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
                GuiUtil.mostrarErro((String)"erro_restaurar");
            }
            finally {
                IRPFFacade.setCacheIdDeclaracao(false);
            }
        }
        if (sucesso) {
            if (totalArquivos == i) {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem("copia_seg_restauracao_sucesso"), INFORMACAO, 1);
            } else {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem("restaurarCopiaSegFalha", new String[]{Long.toString(i)}), INFORMACAO, 1);
            }
            if (this.atualizarDeclaracoesTransmitidas && ControladorGui.getPainelAtualmenteExibido() instanceof IRPFBemVindos) {
                ((IRPFBemVindos)ControladorGui.getPainelAtualmenteExibido()).atualizaListaDeclaracoesPreenchimento();
                ((IRPFBemVindos)ControladorGui.getPainelAtualmenteExibido()).atualizaListaDeclaracoesTransmitidas();
            }
        }
        if (monitor != null) {
            monitor.setCurrent("Importando " + totalArquivos + " de " + totalArquivos, totalArquivos);
        }
        return sucesso;
    }

    private static void dialogRestauracaoIniciada() {
        final JLabel label = new JLabel();
        int timerDelay = 100;
        new Timer(timerDelay, new ActionListener(){
            int timeLeft = 1;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.timeLeft > 0) {
                    label.setText(MensagemUtil.getMensagem("copia_seg_restauracao_iniciada"));
                    --this.timeLeft;
                } else {
                    ((Timer)e.getSource()).stop();
                    Window win = SwingUtilities.getWindowAncestor(label);
                    win.setVisible(false);
                }
            }
        }){
            {
                this.setInitialDelay(0);
            }
        }.start();
        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), label, INFORMACAO, 1);
    }

    private void copiaDecRec(File dec, File fileRec) {
        try {
            IRPFTxtUtil.copiaBinariaArquivo((String)dec.toString(), (String)UtilitariosArquivo.getPathGravadas());
            IRPFTxtUtil.copiaBinariaArquivo((String)fileRec.toString(), (String)UtilitariosArquivo.getPathGravadas());
            IRPFTxtUtil.copiaBinariaArquivo((String)dec.toString(), (String)UtilitariosArquivo.getPathTransmitidas());
            IRPFTxtUtil.copiaBinariaArquivo((String)fileRec.toString(), (String)UtilitariosArquivo.getPathTransmitidas());
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    private boolean controleSRFBate(File dec, File rec) throws GeracaoTxtException, IOException {
        RegistroTxt registroRecibo = null;
        RegistroTxt headerDec = null;
        RepositorioDeclaracaoCentralTxt repositorioRecibo = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", rec);
        RepositorioDeclaracaoCentralTxt repDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", dec);
        registroRecibo = repositorioRecibo.recuperarRegistroComplementoRecibo();
        headerDec = repDeclaracao.recuperarRegistroHeader();
        String controleSRFcodificado = registroRecibo.fieldByName("CONTROLE_SRF").asString();
        String h = headerDec.fieldByName("NR_HASH").asString();
        String controleDecodificado = Util.decodificaControleSRF((byte[])controleSRFcodificado.getBytes());
        return h.equals(controleDecodificado);
    }
}

