/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dependentes;

import java.util.Calendar;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValidadorNomeIRPF;
import serpro.ppgd.irpf.contribuinte.ValidadorDataNascimento;
import serpro.ppgd.irpf.gui.dependentes.PainelDependentesLista;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class Dependente
extends ObjetoNegocio
implements JEditObjetoNegocioItemIf,
ObjetoFicha {
    public static final String RESPOSTA_SAIDA_VAZIA = "2";
    public static final String PROP_CAMPO_NOME = "Nome";
    public static final String PROP_CAMPO_CPF = "CPF";
    public static String CODIGO_DEPENDENTE_DEFICIENTE = "52";
    public static final String MORA_COM_TITULAR_SIM = "1";
    public static final String MORA_COM_TITULAR_NAO = "0";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarDependencias());
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private CPF cpfDependente = new CPF((ObjetoNegocio)this, "CPF");
    private Data dataNascimento = new Data((ObjetoNegocio)this, "Data de Nascimento");
    private Alfa indSaidaPaisMesmaData = new Alfa((ObjetoNegocio)this, "Saiu do pa\u00eds na mesma data do contribuinte?", 1);
    private Alfa indMoraComTitular = new Alfa((ObjetoNegocio)this, "Dependente mora com o titular da declara\u00e7\u00e3o?", 1);
    private Alfa ddd = new Alfa((ObjetoNegocio)this, "DDD", 2);
    private Alfa telefone = new Alfa((ObjetoNegocio)this, "Telefone celular", 9);
    private Alfa email = new Alfa((ObjetoNegocio)this, "E-mail", 90);
    private Alfa dummy = new Alfa((ObjetoNegocio)this, "Campo para receber pend\u00eancias sem campo definido.");
    private boolean isSaida = false;
    private transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private String chave = "";

    public Dependente(final DeclaracaoIRPF dec) {
        this.identificadorDeclaracao = dec.getIdentificadorDeclaracao();
        this.isSaida = this.identificadorDeclaracao.getTipoDeclaracaoAES().formatado().equals(TipoDeclaracaoAES.SAIDA.getTipo());
        this.setFicha("Dependentes");
        CacheNI.getInstancia().registrarNINome((NI)this.cpfDependente, this.nome);
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("dependente_codigo_branco")));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("dependente_codigo_invalido")));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("dependente_excedeu_limite_rendimentos", new String[]{TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa1.getValor().formatado()})){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = null;
                if (Dependente.this.getCodigo().naoFormatado().equals("31") && dec.getDependentes().obterTotalRendimentosPorDependente(Dependente.this.getCpfDependente()).comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa1.getValor().formatado())) {
                    retorno = new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                }
                return retorno;
            }
        });
        this.getNome().addValidador((ValidadorIf)new ValidadorNomeIRPF());
        this.getNome().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("dependente_nome_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!(Dependente.this.getCodigo().isVazio() && Dependente.this.getDataNascimento().isVazio() && Dependente.this.isDeclaracaoSaidaComIndSaidaNaoRespondido() || !Dependente.this.getNome().isVazio())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getNome().addObservador((Observador)new ObservadorEspacosDuplicados());
        String data22AnosString = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 22);
        final Data data22Anos = new Data();
        data22Anos.setConteudo(data22AnosString);
        String data20AnosString = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 20);
        Data data20Anos = new Data();
        data20Anos.setConteudo(data20AnosString);
        String data17AnosString = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 17);
        Data data17Anos = new Data();
        data17Anos.setConteudo(data17AnosString);
        String data12AnosString = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 11);
        Data data12Anos = new Data();
        data12Anos.setConteudo(data12AnosString);
        String data10AnosString = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 8);
        Data data10Anos = new Data();
        data10Anos.setConteudo(data10AnosString);
        String data25AnosString = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 25);
        final Data data25Anos = new Data();
        data25Anos.setConteudo(data25AnosString);
        String data21AnosString = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 21);
        Data data21Anos = new Data();
        data21Anos.setConteudo(data21AnosString);
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorCPF(3){

            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem("dependente_cpf_invalido"));
                return super.validarImplementado();
            }
        });
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("dependente_cpf_branco")));
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Dependente.this.getCpfDependente().naoFormatado().equals(Dependente.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("cpf_igual_tit"), 3);
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador((ValidadorIf)new ValidadorDataNascimento(3));
        this.getDataNascimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("dependente_data_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                Dependente.this.getCpfDependente().forcaDisparoObservadores();
                if (!(Dependente.this.getCodigo().isVazio() && Dependente.this.getNome().isVazio() && Dependente.this.getCpfDependente().isVazio() && Dependente.this.isDeclaracaoSaidaComIndSaidaNaoRespondido() || !Dependente.this.getDataNascimento().isVazio())) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                Dependente.this.getCpfDependente().forcaDisparoObservadores();
                if ((Dependente.this.getCodigo().naoFormatado().equals("22") || Dependente.this.getCodigo().naoFormatado().equals("25")) && !Dependente.this.getDataNascimento().isVazio() && Dependente.this.getDataNascimento().maisAntiga(data25Anos)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("dependente_data_incompativel"), 3);
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                Dependente.this.getCpfDependente().forcaDisparoObservadores();
                if ((Dependente.this.getCodigo().naoFormatado().equals("21") || Dependente.this.getCodigo().naoFormatado().equals("24") || Dependente.this.getCodigo().naoFormatado().equals("41")) && !Dependente.this.getDataNascimento().isVazio() && Dependente.this.getDataNascimento().maisAntiga(data22Anos)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("dependente_data_incompativel"), 3);
                }
                return null;
            }
        });
        this.getDataNascimento().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                Dependente.this.getCpfDependente().forcaDisparoObservadores();
                if (Dependente.this.getCodigo().naoFormatado().equals("31") && !this.getInformacao().isVazio() && this.getInformacao().isValido()) {
                    Data dtNascContribuinte = dec.getContribuinte().getDataNascimento();
                    Calendar calendarContribuinte = Calendar.getInstance();
                    Calendar calendarDependente = Calendar.getInstance();
                    try {
                        calendarContribuinte.set(Integer.parseInt(dtNascContribuinte.getAno()), Integer.parseInt(dtNascContribuinte.getMes()), Integer.parseInt(dtNascContribuinte.getDia()));
                        calendarDependente.set(Integer.parseInt(Dependente.this.getDataNascimento().getAno()), Integer.parseInt(Dependente.this.getDataNascimento().getMes()), Integer.parseInt(Dependente.this.getDataNascimento().getDia()));
                        long millisecondsContribuinte = calendarContribuinte.getTimeInMillis();
                        long millisecondsDependente = calendarDependente.getTimeInMillis();
                        long diff = millisecondsContribuinte - millisecondsDependente;
                        long diffDays = diff / 86400000L;
                        if (diffDays < 3652L) {
                            return new RetornoValidacao(MensagemUtil.getMensagem("dependente_data_incompativel"), 2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        if (this.isSaida) {
            this.getIndSaidaPaisMesmaData().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("dependente_saida")){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!(Dependente.this.getCodigo().isVazio() && Dependente.this.getDataNascimento().isVazio() && Dependente.this.getCpfDependente().isVazio() && Dependente.this.getNome().isVazio() || !Dependente.this.getIndSaidaPaisMesmaData().naoFormatado().equals(Dependente.RESPOSTA_SAIDA_VAZIA))) {
                        return new RetornoValidacao(this.getMensagemValidacao(), 3);
                    }
                    return null;
                }
            });
        }
        this.getEmail().setDesprezarMascara(false);
        this.getEmail().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (!Dependente.this.getEmail().formatado().trim().matches("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("email_invalido"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getDdd().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Dependente.this.getDdd().formatado().trim().length() == 1) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ddd_um_digito"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getDdd().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ddd_celular")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!Dependente.this.getTelefone().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getTelefone().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Dependente.this.getTelefone().formatado().replace(" ", "").length() < 9) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("celular_menor_nove_digitos"), this.getSeveridade());
                }
                return null;
            }
        });
        this.getTelefone().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("celular_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!Dependente.this.getDdd().isVazio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
    }

    private boolean isDeclaracaoSaidaComIndSaidaNaoRespondido() {
        return this.isSaida ? this.getIndSaidaPaisMesmaData().naoFormatado().equals(RESPOSTA_SAIDA_VAZIA) : false;
    }

    public Boolean maiorDe16Anos() {
        String ANO = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 16);
        Data data = new Data();
        data.setConteudo(ANO);
        return !this.getDataNascimento().isVazio() && this.getDataNascimento().maisAntiga(data);
    }

    public boolean dependenteDeficienteExcedeLimite(DeclaracaoIRPF dec) {
        if (!CODIGO_DEPENDENTE_DEFICIENTE.equals(this.getCodigo().naoFormatado())) {
            return false;
        }
        Valor rendimentos = dec.getDependentes().obterTotalRendimentosPorDependente(this.cpfDependente);
        return rendimentos.comparacao(">", TabelaAliquotasIRPF.ConstantesAliquotas.valorAjusteLimiteAnualFaixa1.getValor());
    }

    public String toString() {
        return this.nome.naoFormatado();
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public CPF getCpfDependente() {
        return this.cpfDependente;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Alfa getIndSaidaPaisMesmaData() {
        return this.indSaidaPaisMesmaData;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getCodigo());
        lista.add(this.getCpfDependente());
        lista.add(this.getDataNascimento());
        lista.add(this.getNome());
        lista.add(this.getEmail());
        lista.add(this.getDdd());
        lista.add(this.getTelefone());
        lista.add(this.getDummy());
        if (this.isSaida) {
            lista.add(this.getIndSaidaPaisMesmaData());
        }
        return lista;
    }

    public String getConteudo(int i) {
        return this.getNome().formatado();
    }

    public int getTotalAtributos() {
        return 1;
    }

    public int getColunaFiltro() {
        return 0;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public Dependente obterCopia() {
        Dependente copia = new Dependente(IRPFFacade.getInstancia().getDeclaracao());
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.setChave(this.getChave());
        copia.getCpfDependente().setConteudo(this.getCpfDependente());
        copia.getDataNascimento().setConteudo(this.getDataNascimento());
        copia.getNome().setConteudo(this.getNome());
        copia.getIndSaidaPaisMesmaData().setConteudo(this.getIndSaidaPaisMesmaData());
        copia.getDummy().setConteudo(this.getDummy());
        copia.isSaida = this.isSaida;
        return copia;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public void setIdentificadorDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Saiu do pa\u00eds na mesma data do contribuinte?")) continue;
            return false;
        }
        return true;
    }

    public void addObservador(Observador obsTotalizaDep) {
        this.getCodigo().addObservador(obsTotalizaDep);
        this.getNome().addObservador(obsTotalizaDep);
    }

    public void removeObservador(Observador obsTotalizaDep) {
        this.getCodigo().removeObservador(obsTotalizaDep);
        this.getNome().removeObservador(obsTotalizaDep);
    }

    public String getClasseFicha() {
        return PainelDependentesLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Dependentes";
    }

    public Alfa getIndMoraComTitular() {
        return this.indMoraComTitular;
    }

    public Alfa getDdd() {
        return this.ddd;
    }

    public Alfa getTelefone() {
        return this.telefone;
    }

    public Alfa getEmail() {
        return this.email;
    }

    public Alfa getDummy() {
        return this.dummy;
    }
}

