/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dividas;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.dividas.PainelDividasLista;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ObjetoComChaveIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class Divida
extends ObjetoNegocio
implements ObjetoComChaveIRPF,
ObjetoFicha {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    public static final String NOME_CAMPO_VALOR_PGTO_ANUAL = "Valor de pagamento anual";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoDividas());
    private Alfa discriminacao = new Alfa((ObjetoNegocio)this, "Discrimina\u00e7\u00e3o", 120);
    private ValorPositivo valorExercicioAnterior = new ValorPositivo(this, "Situa\u00e7\u00e3o no exerc\u00edcio passado");
    private ValorPositivo valorExercicioAtual = new ValorPositivo(this, "Situa\u00e7\u00e3o no exerc\u00edcio atual");
    private ValorPositivo valorPgtoAnual = new ValorPositivo(this, "Valor de pagamento anual");
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");

    public Divida() {
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("divida_codigo_branco")));
        this.getDiscriminacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public Valor getValorPgtoAnual() {
        return this.valorPgtoAnual;
    }

    public Divida obterCopia() {
        Divida copia = new Divida();
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.getDiscriminacao().setConteudo(this.getDiscriminacao());
        copia.getValorExercicioAnterior().setConteudo(this.getValorExercicioAnterior());
        copia.getValorExercicioAtual().setConteudo(this.getValorExercicioAtual());
        copia.getValorPgtoAnual().setConteudo(this.getValorPgtoAnual());
        copia.getIndice().setConteudo(this.getIndice());
        return copia;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.codigo);
        retorno.add(this.discriminacao);
        retorno.add(this.valorExercicioAtual);
        retorno.add(this.valorExercicioAnterior);
        retorno.add(this.valorPgtoAnual);
        return retorno;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Indice")) continue;
            return false;
        }
        return true;
    }

    public List<Pendencia> verificarPendencias(int numeroItem) {
        List retorno = super.verificarPendencias(numeroItem);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia p = new Pendencia(2, (Informacao)this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), MensagemUtil.getMensagem("divida_valor_nao_informado"), numeroItem);
            p.setClassePainel(this.getClasseFicha());
            retorno.add(p);
        }
        return retorno;
    }

    public String getChave() {
        return this.getCodigo().naoFormatado();
    }

    public int compareTo(Object o) {
        Divida divida = (Divida)o;
        int cod = divida.getCodigo().asInteger();
        return cod - this.getCodigo().asInteger();
    }

    @Override
    public Alfa getIndice() {
        return this.indice;
    }

    public String getClasseFicha() {
        return PainelDividasLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "D\u00edvidas e \u00d4nus Reais";
    }
}

