/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.doacaodeclaracao;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemLimiteDeducaoIncentivo;
import serpro.ppgd.irpf.calculos.CalculosDeducoesIncentivos;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoIdoso;
import serpro.ppgd.irpf.gui.doacaodiretamentedeclaracao.PainelDadosDDD;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class ColecaoEstatutoIdoso
extends Colecao<EstatutoIdoso>
implements ObjetoFicha {
    private Valor valorDisponivelDoacao = new Valor((ObjetoNegocio)this, "Valor Dispon\u00edvel para Doa\u00e7\u00e3o");
    private Valor valorDisponivelDoacaoExibido = new Valor((ObjetoNegocio)this, "Valor Dispon\u00edvel para Doa\u00e7\u00e3o");
    private Valor totalDeducaoIncentivoLiquido = new Valor((ObjetoNegocio)this, "");
    private Valor totalDeducaoIncentivoBruto = new Valor((ObjetoNegocio)this, "");
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public ColecaoEstatutoIdoso(DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o");
        this.valorDisponivelDoacao.setReadOnly(true);
        this.valorDisponivelDoacao.setAtributoPersistente(false);
        this.valorDisponivelDoacaoExibido.setReadOnly(true);
        this.valorDisponivelDoacaoExibido.setAtributoPersistente(false);
        this.totalDeducaoIncentivoBruto.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (((DeclaracaoIRPF)((Object)ColecaoEstatutoIdoso.this.weakDec.get())).getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoBruto().isVazio()) {
                    ItemLimiteDeducaoIncentivo lItemLimiteDeducaoIncentivo = CalculosDeducoesIncentivos.calculaDeducaoIncentivo((DeclaracaoIRPF)((DeclaracaoIRPF)((Object)ColecaoEstatutoIdoso.this.weakDec.get())), (Valor)((DeclaracaoIRPF)((Object)ColecaoEstatutoIdoso.this.weakDec.get())).getModeloCompleta().getImposto());
                    Valor limite = new Valor();
                    limite.setConteudo(lItemLimiteDeducaoIncentivo.getLimite6porcento());
                    Valor utilizado = new Valor();
                    utilizado.append('+', lItemLimiteDeducaoIncentivo.getDeducaoEfetivaSemCod39());
                    utilizado.append('+', ((DeclaracaoIRPF)((Object)ColecaoEstatutoIdoso.this.weakDec.get())).getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoBruto());
                    utilizado.append('+', ((DeclaracaoIRPF)((Object)ColecaoEstatutoIdoso.this.weakDec.get())).getColecaoEstatutoIdoso().getTotalDeducaoIncentivoBruto());
                    this.setMensagemValidacao(MensagemUtil.getMensagem("doacoes_total_doacao_excedido", new String[]{utilizado.formatado(), limite.formatado()}));
                    if (utilizado.comparacao(">", limite)) {
                        return new RetornoValidacao("Teste", this.getSeveridade());
                    }
                }
                return null;
            }
        });
    }

    public boolean todasDoacoesZeradas() {
        boolean retorno = true;
        for (ObjetoNegocio objetoNegocio : this.itens()) {
            if (((EstatutoIdoso)objetoNegocio).getValor().isVazio()) continue;
            retorno = false;
            break;
        }
        return retorno;
    }

    public boolean existeMaisDeUmaDoacaoParaMesmoFundo() {
        boolean retorno = false;
        ArrayList<String> cnpjs = new ArrayList<String>(this.itens().size());
        for (ObjetoNegocio objetoNegocio : this.itens()) {
            String cnpj = ((EstatutoIdoso)objetoNegocio).getCnpjFundo().naoFormatado();
            if (cnpj == null || cnpj.isEmpty()) continue;
            if (!cnpjs.contains(cnpj)) {
                cnpjs.add(cnpj);
                continue;
            }
            retorno = true;
            break;
        }
        return retorno;
    }

    public boolean existeDoacaoComDadosIncompletos() {
        boolean retorno = false;
        for (ObjetoNegocio objetoNegocio : this.itens()) {
            if (objetoNegocio.verificarPendencias(0).isEmpty()) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    public EstatutoIdoso instanciaNovoObjeto() {
        return new EstatutoIdoso(this);
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.totalDeducaoIncentivoBruto);
        return lista;
    }

    public Valor getValorDisponivelDoacao() {
        return this.valorDisponivelDoacao;
    }

    public Valor getValorDisponivelDoacaoExibido() {
        return this.valorDisponivelDoacaoExibido;
    }

    public Valor getTotalDeducaoIncentivoLiquido() {
        return this.totalDeducaoIncentivoLiquido;
    }

    public Valor getTotalDeducaoIncentivoBruto() {
        return this.totalDeducaoIncentivoBruto;
    }

    public String getClasseFicha() {
        return PainelDadosDDD.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o aos Fundos Nacional, Estaduais e Municipais do Idoso";
    }
}

