/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.doacoes;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Doacoes
extends Colecao<Doacao> {
    private Valor totalDeducaoIncentivo = new Valor((ObjetoNegocio)this, "");
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices;
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public Doacoes(DeclaracaoIRPF dec) {
        this.totalDeducaoIncentivo.setCasasDecimais(4);
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Doa\u00e7\u00f5es Efetuadas");
        this.inicializaGeradorIndices();
    }

    private void inicializaGeradorIndices() {
        geradorIndices = this.ultimoIndiceGerado.naoFormatado().trim().equals("") ? 0L : Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    public void objetoInserido(Doacao doacao) {
        doacao.setFicha(this.getFicha());
    }

    public Doacao instanciaNovoObjeto() {
        Doacao item = new Doacao((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        item.getIndice().setConteudo(this.proximoIndice());
        return item;
    }

    public Valor getTotalDeducaoIncentivo() {
        return this.totalDeducaoIncentivo;
    }

    public boolean existeValorDoacaoAlto() {
        for (Doacao doacao : this.itens()) {
            if (!doacao.getValorPago().comparacao(">", "50.000,00")) continue;
            return true;
        }
        return false;
    }
}

