/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.eleicoes;

import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.eleicoes.DoacaoEleitoral;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosDoacoesEleitorais
extends Observador {
    private DeclaracaoIRPF declaracaoIRPF = null;

    public CalculosDoacoesEleitorais(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                DoacaoEleitoral doacao = (DoacaoEleitoral)((Object)valorNovo);
                doacao.getValor().addObservador((Observador)this);
                this.calculoTotalDoacoes();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                DoacaoEleitoral doacao = (DoacaoEleitoral)((Object)valorNovo);
                doacao.getValor().removeObservador((Observador)this);
                this.calculoTotalDoacoes();
            } else if (nomePropriedade.equals("Valor da doa\u00e7\u00e3o")) {
                this.calculoTotalDoacoes();
            }
        }
    }

    public void calculoTotalDoacoes() {
        Valor total = new Valor();
        Iterator it = this.declaracaoIRPF.getDoacoesEleitorais().itens().iterator();
        while (it.hasNext()) {
            Valor valorDoacao = ((DoacaoEleitoral)((Object)it.next())).getValor();
            total.append('+', valorDoacao);
        }
        this.declaracaoIRPF.getDoacoesEleitorais().getTotalDoacoes().setConteudo(total);
    }
}

