/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.espolio;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.espolio.EspolioDecisaoJudicial;
import serpro.ppgd.irpf.espolio.EspolioEscrituracaoPublica;
import serpro.ppgd.irpf.gui.espolio.PainelEscolheEspolio;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class EspolioPartilha
extends ObjetoNegocio
implements ObjetoFicha {
    private CPF cpfInventariante;
    private Alfa nomeInventariante;
    private Alfa tipoJudicial = new Alfa((ObjetoNegocio)this, "Judicial");
    private Alfa morteAmbosConjuges = new Alfa((ObjetoNegocio)this, "Morte de ambos os c\u00f4njuges ou companheiros(as)");
    private Alfa conjugeMeeiro = new Alfa((ObjetoNegocio)this, "C\u00f4njuge meeiro");
    private Alfa inventarioConjunto = new Alfa((ObjetoNegocio)this, "Invent\u00e1rio Conjunto");
    private Alfa nomeConjugeCompanheiro = new Alfa((ObjetoNegocio)this, "Nome do c\u00f4njuge ou companheiro(a)", 60);
    private EspolioDecisaoJudicial decisaoJudicial;
    private EspolioEscrituracaoPublica escrituracaoPublica;
    private WeakReference<DeclaracaoIRPF> weakDec;
    private String nomeAba;

    public EspolioPartilha(DeclaracaoIRPF dec, String nomeAba) {
        this.cpfInventariante = new CPF((ObjetoNegocio)this, "CPF " + nomeAba);
        this.nomeInventariante = new Alfa((ObjetoNegocio)this, "Nome " + nomeAba, 60);
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.nomeAba = nomeAba;
        this.decisaoJudicial = new EspolioDecisaoJudicial(nomeAba);
        this.escrituracaoPublica = new EspolioEscrituracaoPublica(nomeAba);
        CacheNI.getInstancia().registrarNINome((NI)this.getCpfInventariante(), this.getNomeInventariante());
        this.setFicha("Esp\u00f3lio");
        this.getTipoJudicial().setConteudo(Logico.SIM);
        this.getConjugeMeeiro().setConteudo(Logico.NAO);
        this.getMorteAmbosConjuges().setConteudo(Logico.NAO);
        this.getInventarioConjunto().setConteudo(Logico.NAO);
        this.getMorteAmbosConjuges().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorNovo.toString().equals(Logico.SIM)) {
                    EspolioPartilha.this.getConjugeMeeiro().setConteudo(Logico.NAO);
                } else {
                    EspolioPartilha.this.getInventarioConjunto().setConteudo(Logico.NAO);
                }
            }
        });
        this.getInventarioConjunto().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (!valorNovo.toString().equals(Logico.SIM)) {
                    EspolioPartilha.this.getNomeConjugeCompanheiro().clear();
                }
            }
        });
        this.getNomeConjugeCompanheiro().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeInventariante().addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    public int getQtdMesesParaCalculos() {
        String anoDecisaoJud = this.getDecisaoJudicial().getAnoDecisaoJudicial();
        String mesDecisaoJud = this.getDecisaoJudicial().getMesDecisaoJudicial();
        int numMeses = -1;
        if (this.getTipoJudicial().naoFormatado().equals(Logico.SIM)) {
            if (!anoDecisaoJud.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                numMeses = 1;
            } else if (mesDecisaoJud.trim().length() > 0) {
                numMeses = Integer.parseInt(mesDecisaoJud);
            }
        } else {
            String anoEscrituracaoPublica = this.getEscrituracaoPublica().getAnoEscrituracaoPublica();
            String mesEscrituracaoPublica = this.getEscrituracaoPublica().getMesEscrituracaoPublica();
            if (!anoEscrituracaoPublica.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                numMeses = 1;
            } else if (mesEscrituracaoPublica.trim().length() > 0) {
                numMeses = Integer.parseInt(mesEscrituracaoPublica);
            }
        }
        if (numMeses > 12) {
            numMeses = 12;
        }
        return numMeses;
    }

    public boolean isVazio() {
        boolean vazioAjuste;
        boolean bl = vazioAjuste = this.getCpfInventariante().isVazio() && this.getNomeInventariante().isVazio();
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isAjuste()) {
            return vazioAjuste;
        }
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isEspolio()) {
            if (this.getTipoJudicial().naoFormatado().equals(Logico.SIM)) {
                return vazioAjuste && this.getDecisaoJudicial().isVazio();
            }
            return vazioAjuste && this.getEscrituracaoPublica().isVazio();
        }
        return true;
    }

    public String getClasseFicha() {
        return PainelEscolheEspolio.class.getName();
    }

    public String getNomeAba() {
        return this.nomeAba;
    }

    public String getTituloFichaDashboard() {
        return "Esp\u00f3lio";
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public CPF getCpfInventariante() {
        return this.cpfInventariante;
    }

    public Alfa getNomeInventariante() {
        return this.nomeInventariante;
    }

    public Alfa getMorteAmbosConjuges() {
        return this.morteAmbosConjuges;
    }

    public Alfa getNomeConjugeCompanheiro() {
        return this.nomeConjugeCompanheiro;
    }

    public Alfa getTipoJudicial() {
        return this.tipoJudicial;
    }

    public EspolioEscrituracaoPublica getEscrituracaoPublica() {
        return this.escrituracaoPublica;
    }

    public Alfa getInventarioConjunto() {
        return this.inventarioConjunto;
    }

    public Alfa getConjugeMeeiro() {
        return this.conjugeMeeiro;
    }

    public EspolioDecisaoJudicial getDecisaoJudicial() {
        return this.decisaoJudicial;
    }

    public boolean isJudicial() {
        return this.tipoJudicial.naoFormatado().equals(Logico.SIM);
    }
}

