/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import java.util.ArrayList;
import serpro.ppgd.irpf.ValorBigDecimal;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.Apuracao;
import serpro.ppgd.irpf.gcap.calculo.Ajuste;
import serpro.ppgd.irpf.gcap.calculo.CalculoImposto;
import serpro.ppgd.irpf.gcap.consolidacao.Consolidacao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class Alienacao
extends ObjetoNegocio {
    public static final int CONSTANTE_ANO_MINIMO_ALIENACAO_PARCIAL = 2017;
    public static final int TIPO_ALIENACAO_BEM_IMOVEL = 1;
    public static final int TIPO_ALIENACAO_BEM_MOVEL = 2;
    public static final int TIPO_ALIENACAO_PARTICIPACAO_SOCIETARIA = 3;
    public static final String LABEL_CAMPO_DATA_ALIENACAO = "Data de Aliena\u00e7\u00e3o";
    public static final String LABEL_CAMPO_DATA_TRANSITO_JULGADO = "Data do tr\u00e2nsito em julgado";
    public static final String LABEL_CAMPO_DATA_DECISAO_JUDICIAL = "Data da decis\u00e3o judicial";
    public static final String LABEL_CAMPO_DATA_LAVRATURA = "Data da Lavratura";
    public static final String LABEL_CAMPO_NATUREZA = "Natureza";
    public static final String LABEL_CAMPO_VALOR_RECEBIDO_ANOS_ANTERIORES = "Valor Recebido em Anos Anteriores";
    public static final String LABEL_CAMPO_CORRETAGEM_ANOS_ANTERIORES = "Corretagem em Anos Anteriores";
    public static final String LABEL_CAMPO_VALOR_LIQUIDO_RECEBIDO_ANOS_ANTERIORES = "Valor L\u00edquido Recebido em Anos Anteriores";
    public static final String CONSTANTE_ALIQUOTA_FIXA_15_PORCENTO = "0,150000000";
    public static final String CONSTANTE_ALIQUOTA_FIXA_20_PORCENTO = "0,200000000";
    public static final String CONSTANTE_ALIQUOTA_FIXA_25_PORCENTO = "0,250000000";
    public static final int ANO_TRANSICAO_PARAISOS_FISCAIS = 2019;
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF do declarante");
    private Data dataInicioPermanencia = new Data((ObjetoNegocio)this, "Data Inicio Perman\u00eancia");
    private Data dataFimPermanencia = new Data((ObjetoNegocio)this, "Data Fim Perman\u00eancia");
    private Alfa codigoOperacao = new Alfa((ObjetoNegocio)this, "C\u00f3digo de Opera\u00e7\u00e3o");
    private Alfa nomePaisDeclarante = new Alfa((ObjetoNegocio)this, "Pais Declarante");
    private Codigo natureza = new Codigo((ObjetoNegocio)this, "Natureza", new ArrayList());
    private Data dataAlienacao = new Data((ObjetoNegocio)this, "Data de Aliena\u00e7\u00e3o");
    private Data dataTransitoJulgado = new Data((ObjetoNegocio)this, "Data do tr\u00e2nsito em julgado");
    private Data dataRecebimentoUltimaParcela = new Data((ObjetoNegocio)this, "Data de Recebimento da \u00daltima Parcela");
    private Logico temUltimaParcela = new Logico((ObjetoNegocio)this, "A presta\u00e7\u00e3o/parcela final foi recebida em " + AplicacaoPropertiesUtil.getExercicio() + "?");
    private Logico motivoTransmissaoCausaMortisDecisaoJudicial = new Logico((ObjetoNegocio)this, "Decis\u00e3o Judicial?");
    private Logico alienacaoAPrazo = new Logico((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o");
    private ValorPositivo valorAlienacao = new ValorPositivo(this, "Valor de Aliena\u00e7\u00e3o (R$)");
    private ValorPositivo custoCorretagem = new ValorPositivo(this, "Custo Corretagem (R$)");
    private Logico alienacaoParcial = new Logico((ObjetoNegocio)this, "J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem?");
    private Logico bemGrandeValor = new Logico((ObjetoNegocio)this, " O valor do conjundo dos bens ou direitos da mesma natureza, alienados em m\u00eas/ano, \u00e9 superior a 35.000,00?");
    private Logico bemGrandeValorOperacao = new Logico((ObjetoNegocio)this, " Resposta para bemGrandeValor se dados da opera\u00e7\u00e3o permitia");
    private ValorPositivo ganhoCapitalAlienacaoAnterior = new ValorPositivo(this, "Ganho de Capital de Aliena\u00e7\u00e3o anterior");
    private ValorPositivo valorLiquidoRecebidoAnosAnteriores = new ValorPositivo(this, "Valor L\u00edquido Recebido em Anos Anteriores");
    private ValorPositivo valorRecebidoAnosAnteriores = new ValorPositivo(this, "Valor Recebido em Anos Anteriores");
    private ValorPositivo corretagemAnosAnteriores = new ValorPositivo(this, "Corretagem em Anos Anteriores");
    private CalculoImposto calculoImposto = new CalculoImposto();
    private Ajuste ajuste = new Ajuste();
    private Consolidacao consolidacao = new Consolidacao();
    private transient Alfa alienacaoAPrazoAux = new Alfa((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o?", 1);
    private transient Alfa alienacaoParcialAux = new Alfa((ObjetoNegocio)this, "J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem?", 1);
    private transient Data dataRecebimentoUltimaParcelaAux = new Data((ObjetoNegocio)this, "Data de Recebimento da \u00daltima Parcela");
    private transient Alfa bemGrandeValorAux = new Alfa((ObjetoNegocio)this, " O valor do conjundo dos bens ou direitos da mesma natureza, alienados em m\u00eas/ano, \u00e9 superior a 35.000,00?", 1);
    private Logico alienacaoAnoAnterior = new Logico((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi realizada no ano anterior?");
    private Alfa numeroItem = new Alfa((ObjetoNegocio)this, "N\u00famero do Item");
    private transient Alfa recebimentoUltimaParcelaAux = new Alfa((ObjetoNegocio)this, "A presta\u00e7ao/parcela final foi recebida em " + (AplicacaoPropertiesUtil.getExercicioAsInt() - 1) + "?");
    private Logico recebimentoUltimaParcelaAnoAnterior = new Logico((ObjetoNegocio)this, "A presta\u00e7\u00e3o/parcela final foi recebida em " + (AplicacaoPropertiesUtil.getExercicioAsInt() - 1) + "?");
    private Logico residenteBrasil = new Logico((ObjetoNegocio)this, "\u00c9 residente no Brasil?");
    private Data dataVencimentoTCM = new Data((ObjetoNegocio)this, "Data de vencimento do DARF para TCM");
    private Codigo paisResidencia = new Codigo((ObjetoNegocio)this, "Pais de Residncia", CadastroTabelasIRPF.recuperarPaises());
    private Logico territorioParaisoFiscal = new Logico((ObjetoNegocio)this, "Territrio Paraso Fiscal");

    public Alienacao() {
        this.getTemUltimaParcela().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getTemUltimaParcela().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getTemUltimaParcela().setConteudo(Logico.NAO);
        this.getAlienacaoAPrazo().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getAlienacaoAPrazo().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getAlienacaoParcial().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getAlienacaoParcial().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getBemGrandeValor().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getBemGrandeValor().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getBemGrandeValorOperacao().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getBemGrandeValorOperacao().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().setConteudo(Logico.SIM);
        this.getRecebimentoUltimaParcelaAnoAnterior().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getRecebimentoUltimaParcelaAnoAnterior().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getResidenteBrasil().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getResidenteBrasil().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getTerritorioParaisoFiscal().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getDataRecebimentoUltimaParcela().setReadOnly(true);
        this.getTemUltimaParcela().setReadOnly(true);
        this.getValorLiquidoRecebidoAnosAnteriores().setReadOnly(true);
        this.setReadOnlyAlienacao();
    }

    public void setReadOnlyAlienacao() {
        this.natureza.setReadOnly(true);
        this.natureza.setHabilitado(false);
        this.dataAlienacao.setReadOnly(true);
        this.dataTransitoJulgado.setReadOnly(true);
        this.dataRecebimentoUltimaParcela.setReadOnly(true);
        this.temUltimaParcela.setReadOnly(true);
        this.motivoTransmissaoCausaMortisDecisaoJudicial.setReadOnly(true);
        this.alienacaoAPrazo.setReadOnly(true);
        this.valorAlienacao.setReadOnly(true);
        this.custoCorretagem.setReadOnly(true);
        this.alienacaoParcial.setReadOnly(true);
        this.bemGrandeValor.setReadOnly(true);
        this.bemGrandeValorOperacao.setReadOnly(true);
        this.ganhoCapitalAlienacaoAnterior.setReadOnly(true);
        this.valorLiquidoRecebidoAnosAnteriores.setReadOnly(true);
        this.valorRecebidoAnosAnteriores.setReadOnly(true);
        this.corretagemAnosAnteriores.setReadOnly(true);
        this.alienacaoAnoAnterior.setReadOnly(true);
        this.numeroItem.setReadOnly(true);
        this.recebimentoUltimaParcelaAnoAnterior.setReadOnly(true);
        this.residenteBrasil.setReadOnly(true);
    }

    public abstract Apuracao getApuracao();

    public Alfa getCodigoOperacao() {
        return this.codigoOperacao;
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Data getDataInicioPermanencia() {
        return this.dataInicioPermanencia;
    }

    public Data getDataFimPermanencia() {
        return this.dataFimPermanencia;
    }

    public Alfa getNomePaisDeclarante() {
        return this.nomePaisDeclarante;
    }

    public Codigo getNatureza() {
        return this.natureza;
    }

    public Data getDataAlienacao() {
        return this.dataAlienacao;
    }

    public Data getDataTransitoJulgado() {
        return this.dataTransitoJulgado;
    }

    public Data getDataRecebimentoUltimaParcela() {
        return this.dataRecebimentoUltimaParcela;
    }

    public Logico getTemUltimaParcela() {
        return this.temUltimaParcela;
    }

    public Logico getMotivoTransmissaoCausaMortisDecisaoJudicial() {
        return this.motivoTransmissaoCausaMortisDecisaoJudicial;
    }

    public Logico getAlienacaoAPrazo() {
        return this.alienacaoAPrazo;
    }

    public ValorPositivo getValorAlienacao() {
        return this.valorAlienacao;
    }

    public ValorPositivo getCustoCorretagem() {
        return this.custoCorretagem;
    }

    public Logico getAlienacaoParcial() {
        return this.alienacaoParcial;
    }

    public ValorPositivo getGanhoCapitalAlienacaoAnterior() {
        return this.ganhoCapitalAlienacaoAnterior;
    }

    public ValorPositivo getValorLiquidoRecebidoAnosAnteriores() {
        return this.valorLiquidoRecebidoAnosAnteriores;
    }

    public ValorPositivo getValorRecebidoAnosAnteriores() {
        return this.valorRecebidoAnosAnteriores;
    }

    public ValorPositivo getCorretagemAnosAnteriores() {
        return this.corretagemAnosAnteriores;
    }

    public CalculoImposto getCalculoImposto() {
        return this.calculoImposto;
    }

    public Ajuste getAjuste() {
        return this.ajuste;
    }

    public Consolidacao getConsolidacao() {
        return this.consolidacao;
    }

    public boolean isAlienacaoAPrazo() {
        return Logico.SIM.equals(this.getAlienacaoAPrazo().naoFormatado());
    }

    public boolean isAlienacaoAVista() {
        return Logico.NAO.equals(this.getAlienacaoAPrazo().naoFormatado());
    }

    public boolean temAlienacaoParcial() {
        return Logico.SIM.equals(this.getAlienacaoParcial().naoFormatado());
    }

    public Logico getBemGrandeValor() {
        return this.bemGrandeValor;
    }

    public Logico getBemGrandeValorOperacao() {
        return this.bemGrandeValorOperacao;
    }

    public boolean isBemPequenoValor() {
        return Logico.NAO.equals(this.getBemGrandeValor().naoFormatado());
    }

    public boolean isBemPequenoValorOperacao() {
        return Logico.NAO.equals(this.getBemGrandeValorOperacao().naoFormatado());
    }

    public boolean isAlienacaoBrasil() {
        return true;
    }

    public Codigo obterCodigoOrigemRendimentos() {
        return null;
    }

    public Alfa getAlienacaoAPrazoAux() {
        return this.alienacaoAPrazoAux;
    }

    public Alfa getAlienacaoParcialAux() {
        return this.alienacaoParcialAux;
    }

    public Data getDataRecebimentoUltimaParcelaAux() {
        return this.dataRecebimentoUltimaParcelaAux;
    }

    public Alfa getBemGrandeValorAux() {
        return this.bemGrandeValorAux;
    }

    public void calcularApuracao() {
    }

    public abstract String obterAliquotaFixa();

    public Logico getAlienacaoAnoAnterior() {
        return this.alienacaoAnoAnterior;
    }

    public boolean podeTerAlienacaoParcial() {
        boolean retorno = false;
        int anoAlienacao = 0;
        try {
            anoAlienacao = Integer.valueOf(this.getDataAlienacao().getAno());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (anoAlienacao >= 2017) {
            retorno = true;
        }
        return retorno;
    }

    public boolean isAlienacaoEmAnoAnterior() {
        int ano = AplicacaoPropertiesUtil.getExercicioAsInt();
        try {
            ano = Integer.valueOf(this.dataAlienacao.getAno());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ano < AplicacaoPropertiesUtil.getExercicioAsInt();
    }

    public boolean isTransmissaoCausaMortis() {
        int codNatureza = -1;
        try {
            codNatureza = Integer.valueOf(this.getNatureza().naoFormatado());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codNatureza == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS;
    }

    public boolean isDataTransitoJulgadoObrigatoria() {
        return this.isTransmissaoCausaMortis() && this.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals(Logico.SIM);
    }

    public boolean deveExibirMensagemValorecebidoAnoAnterior() {
        try {
            ValorBigDecimal valorZero = new ValorBigDecimal("0,00");
            if (this.dataAlienacao.naoFormatado().length() == 8 && Integer.parseInt(this.dataAlienacao.getAno()) < AplicacaoPropertiesUtil.getExercicioAsInt() && this.valorLiquidoRecebidoAnosAnteriores.comparacao(">", valorZero) && this.valorRecebidoAnosAnteriores.comparacao("=", valorZero)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isIsento() {
        return this.isBemPequenoValor();
    }

    public Alfa getNumeroItem() {
        return this.numeroItem;
    }

    public Logico getResidenteBrasil() {
        return this.residenteBrasil;
    }

    public Alfa getRecebimentoUltimaParcelaAux() {
        return this.recebimentoUltimaParcelaAux;
    }

    public Logico getRecebimentoUltimaParcelaAnoAnterior() {
        return this.recebimentoUltimaParcelaAnoAnterior;
    }

    public Data getDataVencimentoTCM() {
        return this.dataVencimentoTCM;
    }

    public Codigo getPaisResidencia() {
        return this.paisResidencia;
    }

    public Logico getTerritorioParaisoFiscal() {
        return this.territorioParaisoFiscal;
    }

    public boolean isPaisResidenciaBrasil() {
        return "105".equals(this.getPaisResidencia().naoFormatado());
    }

    public boolean isPaisResidenciaExterior() {
        return !this.getPaisResidencia().isVazio() && !"105".equals(this.getPaisResidencia().naoFormatado());
    }

    public boolean isAdquirenteRequerido() {
        boolean requerido = true;
        if (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL).equals(this.getNatureza().naoFormatado())) {
            requerido = false;
        }
        return requerido;
    }

    public boolean isPaisAlienacaoIgualDemonstrativo(IdDemonstrativoGCAP id) {
        return this.getPaisResidencia().naoFormatado().equals(id.getPaisDeclarante().naoFormatado());
    }

    public boolean isParaisoFiscal() {
        return this.getPaisResidencia().getConteudoAtual(2).equals(Logico.SIM);
    }

    public boolean isTerritorioParaisoFiscal() {
        return this.getTerritorioParaisoFiscal().naoFormatado().equals(Logico.SIM);
    }
}

