/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemImovel;
import serpro.ppgd.irpf.gcap.aquisicao.Aquisicao;
import serpro.ppgd.irpf.gcap.aquisicao.ParcelaAquisicao;
import serpro.ppgd.irpf.gcap.bensimoveis.BemImovel;
import serpro.ppgd.irpf.gcap.perguntas.PerguntasImovel;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;

public class AlienacaoBemImovel
extends AlienacaoBem
implements ObjetoGCAP {
    public static final String NOME_FICHA_BEM_IMOVEl = "Bens Im\u00f3veis";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_AQUISICAO = "Aquisi\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_PERGUNTAS = "Perguntas";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static final int REDUCAO_AUSENTE = 0;
    public static final int REDUCAO_IMOVEL_PEQUENO_VALOR = 1;
    public static final int REDUCAO_UNICO_IMOVEL = 2;
    public static final int REDUCAO_APLICACAO_OUTRO_IMOVEL = 3;
    private BemImovel bemImovel = new BemImovel(this);
    private ApuracaoBemImovel apuracao = new ApuracaoBemImovel();
    private ApuracaoBemImovel apuracaoFinal = new ApuracaoBemImovel();
    private ValorPositivo valorAplicado = new ValorPositivo(this, "Valor aplicado na aquisi\u00e7\u00e3o de im\u00f3vel residencial no prazo de 180 dias.");
    private PerguntasImovel perguntas = new PerguntasImovel();
    private Alfa alienacaoAPrazoImovelAux = new Alfa((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o?", 1);
    public static final int ANO_TRANSICAO_LEI_180_DIAS = 2018;
    public static final String VALOR_ISENCAO_UNICO_IMOVEL = "440.000,00";

    public AlienacaoBemImovel() {
        this.getNatureza().setColecaoElementoTabela(CadastroTabelasIRPF.recuperarNaturezaGCAPBemImovel());
        this.setReadOnlyAlienacaoBemImovel();
    }

    public void setReadOnlyAlienacaoBemImovel() {
        this.valorAplicado.setReadOnly(true);
    }

    public BemImovel getBemImovel() {
        return this.bemImovel;
    }

    public ValorPositivo getValorAplicado() {
        return this.valorAplicado;
    }

    public PerguntasImovel getPerguntas() {
        return this.perguntas;
    }

    public Alfa getAlienacaoAPrazoImovelAux() {
        return this.alienacaoAPrazoImovelAux;
    }

    @Override
    public boolean isAlienacaoBrasil() {
        return this.getBemImovel().isAdquiridoNoBrasil();
    }

    @Override
    public Aquisicao getAquisicao() {
        return this.getBemImovel().getAquisicao();
    }

    @Override
    public ApuracaoBemImovel getApuracao() {
        return this.apuracao;
    }

    @Override
    public ApuracaoBemImovel getApuracaoFinal() {
        return this.apuracaoFinal;
    }

    @Override
    public Codigo obterCodigoOrigemRendimentos() {
        return this.getBemImovel().getAquisicao().getOrigemRendimentos();
    }

    public ValorPositivo getValorIsencaoUnicoImovel() {
        ValorPositivo valorIsencaoUnicoImovel = new ValorPositivo();
        valorIsencaoUnicoImovel.setConteudo("440000,00");
        return valorIsencaoUnicoImovel;
    }

    private boolean isValorAlienacaoMenor35k() {
        ValorPositivo valorAlienacao = new ValorPositivo();
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            valorAlienacao.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacao.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        return valorAlienacao.comparacao("<=", this.getValorIsencao());
    }

    public boolean isIsentoPorPequenoValor() {
        boolean isento = false;
        boolean conjuntoBensInferiorLimiteIsencao = this.getBemGrandeValor().formatado().equals("0");
        if (conjuntoBensInferiorLimiteIsencao) {
            isento = this.getDataRecebimentoUltimaParcela().isVazio() ? !this.isValorOperacaoMaior35K() : !this.isValorParcelasMaior35K();
        }
        return isento;
    }

    private boolean isValorAlienacaoMenor440k() {
        ValorPositivo valorAlienacao = new ValorPositivo();
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            valorAlienacao.setConteudo(this.getValorAlienacao());
        } else {
            valorAlienacao.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        return valorAlienacao.comparacao("<=", this.getValorIsencaoUnicoImovel());
    }

    @Override
    public boolean isIsento() {
        boolean isento = false;
        if (this.isAlienacaoBrasil()) {
            if (this.getApuracao().getGanhoCapital5().isVazio()) {
                isento = true;
            }
        } else {
            int enquadramento = 0;
            if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
                enquadramento = this.obterEnquadramentoFinal();
            }
            if (enquadramento == 1 || enquadramento == 2 || this.getPerguntas().isValorReaplicadoTotalmente()) {
                isento = true;
            } else {
                Codigo codigoOrigemRendimento = this.obterCodigoOrigemRendimentos();
                ValorPositivo ganho5 = new ValorPositivo();
                if ("1".equals(codigoOrigemRendimento.naoFormatado())) {
                    ganho5.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
                } else if ("2".equals(codigoOrigemRendimento.naoFormatado())) {
                    ganho5.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
                } else if ("3".equals(codigoOrigemRendimento.naoFormatado())) {
                    ganho5.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
                    ganho5.append('+', this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
                }
                if (ganho5.isVazio()) {
                    isento = true;
                }
            }
        }
        return isento;
    }

    public boolean isIsentoPorUnicoImovel() {
        boolean naoHeIsentoImovelPequenoValor;
        boolean isento = false;
        boolean naoHouveOutraVenda5Anos = this.getPerguntas().naoTemOutraAlienacao();
        boolean naoEhProprietarioOutroImovel = this.getPerguntas().getPropriedadeOutroImovel().formatado().equals("0");
        boolean bl = naoHeIsentoImovelPequenoValor = !this.isIsentoPorPequenoValor();
        if (naoHouveOutraVenda5Anos && naoEhProprietarioOutroImovel && naoHeIsentoImovelPequenoValor) {
            isento = this.getDataRecebimentoUltimaParcela().isVazio() ? !this.isValorOperacaoMaior440K() : !this.isValorParcelasMaior440K();
        }
        return isento;
    }

    public boolean isPermutaComTorna() {
        return String.valueOf(CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(this.getNatureza().naoFormatado());
    }

    public boolean isPrevisaoPrejuizo() {
        boolean retorno = false;
        if (!this.isAlienacaoBrasil()) {
            String origemRendimentos = this.obterCodigoOrigemRendimentos().naoFormatado();
            ValorPositivo ganhoCapital = new ValorPositivo();
            if ("1".equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal());
            } else if ("2".equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemMEReal());
            } else if ("3".equals(origemRendimentos)) {
                ganhoCapital.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', this.getApuracao().getGanhoCapital5OrigemMEReal()));
            }
            if (ganhoCapital.isVazio()) {
                retorno = true;
            }
        }
        return retorno;
    }

    public boolean isPrejuizo() {
        boolean retorno = false;
        if (!this.isAlienacaoBrasil() && this.isAlienacaoAPrazo() && !this.getDataRecebimentoUltimaParcela().isVazio() && this.getAjuste().getImpostoDevido2().isVazio()) {
            retorno = true;
            System.out.println("Preju\u00edzo: " + this.getBemImovel().getEspecificacao().formatado());
        }
        return retorno;
    }

    public boolean existeDesdobramentoNaDataAquisicao() {
        boolean retorno = false;
        if (!this.getAquisicao().getDataAquisicao().isVazio()) {
            for (ParcelaAquisicao parcAquis : this.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                if (!this.getAquisicao().getDataAquisicao().naoFormatado().equals(parcAquis.getData().naoFormatado())) continue;
                retorno = true;
                break;
            }
        }
        return retorno;
    }

    public boolean existeCustoAquisicaoPosterior1969() {
        try {
            if (!this.getAquisicao().getDataAquisicao().isVazio()) {
                boolean posterior1969;
                boolean bl = posterior1969 = 1969 < Integer.parseInt(this.getAquisicao().getDataAquisicao().getAno());
                if (posterior1969) {
                    return true;
                }
                for (ParcelaAquisicao parcAquis : this.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                    posterior1969 = 1969 < Integer.valueOf(parcAquis.getData().getAno());
                    if (!posterior1969) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
        return false;
    }

    public boolean existeGanhoDeCapitalSobreCustoAquisicao() {
        boolean retorno = true;
        if (this.isAlienacaoBrasil()) {
            if (this.getApuracao().getGanhoCapital1().isVazio()) {
                retorno = false;
            }
        } else if (this.getApuracao().getGanhoCapital1OrigemNacionalReal().isVazio() && this.getApuracao().getGanhoCapital1OrigemMEDolar().isVazio()) {
            retorno = false;
        }
        return retorno;
    }

    public int obterEnquadramentoInicial() {
        int retorno = 0;
        if ((Logico.NAO.equals(this.getBemGrandeValor().formatado()) || Logico.NAO.equals(this.getBemGrandeValorOperacao().formatado())) && this.isValorAlienacaoMenor35k()) {
            retorno = 1;
        } else if (this.getPerguntas().naoTemOutraAlienacao() && this.isValorAlienacaoMenor440k()) {
            retorno = 2;
        } else if (this.getPerguntas().isValorReaplicado()) {
            retorno = 3;
        }
        return retorno;
    }

    public int obterEnquadramentoFinal() {
        int retorno = 0;
        ValorPositivo valorAlienacaoParcelas = new ValorPositivo();
        for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
            ValorPositivo somaParcela = new ValorPositivo();
            somaParcela.setConteudo(p.getValorRecebidoDolar());
            somaParcela.append('*', p.getCotacaoDolar());
            valorAlienacaoParcelas.append('+', somaParcela);
        }
        if (Logico.NAO.equals(this.getBemGrandeValor().formatado()) && valorAlienacaoParcelas.comparacao("<=", "35.000,00")) {
            retorno = 1;
        } else if (this.getPerguntas().naoTemOutraAlienacao() && valorAlienacaoParcelas.comparacao("<=", this.getValorIsencaoUnicoImovel())) {
            retorno = 2;
        } else if (this.getPerguntas().isValorReaplicado()) {
            retorno = 3;
        }
        return retorno;
    }

    public int obterEnquadramentoAtual() {
        int enquadramento = this.obterEnquadramentoInicial();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
            enquadramento = this.obterEnquadramentoFinal();
        }
        return enquadramento;
    }

    public boolean mudouEnquadramento() {
        boolean retorno = false;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && enquadramentoInicial != this.obterEnquadramentoFinal()) {
            retorno = true;
        }
        return retorno;
    }

    public String obterMensagemMudancaEnquadramento() {
        String mensagem = null;
        int enquadramentoInicial = this.obterEnquadramentoInicial();
        int enquadramentoFinal = this.obterEnquadramentoFinal();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && enquadramentoInicial != enquadramentoFinal) {
            if (enquadramentoInicial == 0) {
                if (enquadramentoFinal == 2) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.</html>";
                } else if (enquadramentoFinal == 1) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                }
            } else if (enquadramentoInicial == 1) {
                if (enquadramentoFinal == 0) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
                } else if (enquadramentoFinal == 3) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>Ser\u00e1 aplicada a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005.</html>";
                }
            } else if (enquadramentoInicial == 2) {
                if (enquadramentoFinal == 0) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
                } else if (enquadramentoFinal == 3) {
                    mensagem = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.<br>Ser\u00e1 aplicada a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005.</html>";
                }
            } else if (enquadramentoInicial == 3) {
                if (enquadramentoFinal == 1) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                } else if (enquadramentoFinal == 2) {
                    mensagem = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.</html>";
                }
            }
        }
        return mensagem;
    }

    public String obterTextoIsencao() {
        String msgIsencao = "";
        if (this.isAlienacaoAVista()) {
            if (this.getCalculoImposto().getImpostoDevido().isVazio()) {
                msgIsencao = MensagemUtil.getMensagem("impostoDevidoZero");
            }
        } else if (this.getDataRecebimentoUltimaParcela().isVazio()) {
            int enquadramento = this.obterEnquadramentoInicial();
            if (this.isPrevisaoPrejuizo() || enquadramento == 2 || enquadramento == 1 || this.getPerguntas().isValorReaplicadoTotalmente()) {
                msgIsencao = MensagemUtil.getMensagem("impostoDevidoZero");
            }
        } else {
            String msgMudancaEnquadramento = this.obterMensagemMudancaEnquadramento();
            if (msgMudancaEnquadramento != null) {
                msgIsencao = msgMudancaEnquadramento;
            } else if (this.getAjuste().getImpostoDevido().isVazio()) {
                msgIsencao = MensagemUtil.getMensagem("impostoDevidoZero");
            }
        }
        return msgIsencao;
    }

    public boolean criticarLei180Dias() {
        int ano = -1;
        try {
            ano = Integer.valueOf(this.getDataAlienacao().getAno());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ano >= 2018;
    }

    public boolean podeResponderPerguntaPequenoValorNoExteriorPorParcelas() {
        boolean retorno = false;
        boolean residenteNoBrasil = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
        ValorPositivo valorAlienacaoReal = new ValorPositivo();
        if (this.getBemImovel().isAdquiridoNoExterior()) {
            valorAlienacaoReal.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            if (valorAlienacaoReal.comparacao(">", "35.000,00") && !this.getDataRecebimentoUltimaParcela().isVazio()) {
                valorAlienacaoReal.clear();
                for (ParcelaAlienacaoBem p : this.getColecaoParcelaAlienacao().itens()) {
                    ValorPositivo somaParcela = new ValorPositivo();
                    somaParcela.setConteudo(p.getValorRecebidoDolar());
                    somaParcela.append('*', p.getCotacaoDolar());
                    valorAlienacaoReal.append('+', somaParcela);
                }
                if (residenteNoBrasil && valorAlienacaoReal.comparacao("<=", "35.000,00") && this.getDataAlienacao().naoFormatado().length() == 8 && AplicacaoPropertiesUtil.getExercicio().equals(this.getDataAlienacao().getAno())) {
                    retorno = true;
                }
            }
        }
        return retorno;
    }
}

