/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.aquisicao;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class Aquisicao
extends ObjetoNegocio {
    public static final int CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL = 1;
    public static final int CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA = 2;
    public static final int CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA = 3;
    public static final String STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL = "1";
    public static final String STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA = "2";
    public static final String STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA = "3";
    public static final String DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL = "Rendimentos auferidos em moeda nacional";
    public static final String DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA = "Rendimentos auferidos em moeda estrangeira";
    public static final String DESCRICAO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA = "Rendimentos auferidos em moeda nacional e moeda estrangeira";
    private Data dataAquisicao = new Data((ObjetoNegocio)this, "Data de Aquisi\u00e7\u00e3o");
    private ValorPositivo custoAquisicao = new ValorPositivo(this, "Custo de Aquisi\u00e7\u00e3o");
    private Codigo origemRendimentos = new Codigo((ObjetoNegocio)this, "Origem dos Rendimentos", CadastroTabelasIRPF.recuperarTiposOrigemRendimentos());
    private ValorPositivo cotacaoDolarDataAquisicao = new ValorPositivo(this, "Cota\u00e7\u00e3o do dolar na data de aquisi\u00e7\u00e3o", 9, 4);
    private ValorPositivo custoAquisicaoOrigemNacionalReal = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o - (R$)");
    private ValorPositivo custoAquisicaoOrigemNacionalDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o - (US$)");
    private ValorPositivo custoAquisicaoOrigemMEDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o - (US$)");
    private ValorPositivo custoAquisicaoTotalDolar = new ValorPositivo(this, "Custo de aquisi\u00e7\u00e3o total - (US$)");
    private ValorPositivo percentualCustoAquisicaoOrigemNacional = new ValorPositivo(this, "Percentual do custo de Aquisi\u00e7\u00e3o - Origem moeda nacional");
    private ValorPositivo percentualCustoAquisicaoOrigemME = new ValorPositivo(this, "Percentual do custo de Aquisi\u00e7\u00e3o - Origem moeda estrangeira");
    private Codigo moedaEstrangeira = new Codigo((ObjetoNegocio)this, "Moeda Estrangeira", CadastroTabelasIRPF.recuperarMoedas());
    private Logico residenteBrasilAplicacaoExterior = new Logico((ObjetoNegocio)this, "Contribuinte \u00e9 Pessoa f\u00edsica residente no Pa\u00eds e o bem \u00e9 aplica\u00e7\u00e3o financeira, entidade controlada ou trust no exterior?");

    public Aquisicao() {
        this.custoAquisicaoOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoTotalDolar.setReadOnly(true);
        this.percentualCustoAquisicaoOrigemME.setReadOnly(true);
        this.percentualCustoAquisicaoOrigemNacional.setReadOnly(true);
        this.residenteBrasilAplicacaoExterior.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.residenteBrasilAplicacaoExterior.addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.setReadOnlyAquisicao();
    }

    public void setReadOnlyAquisicao() {
        this.dataAquisicao.setReadOnly(true);
        this.custoAquisicao.setReadOnly(true);
        this.origemRendimentos.setReadOnly(true);
        this.origemRendimentos.setHabilitado(false);
        this.moedaEstrangeira.setReadOnly(true);
        this.moedaEstrangeira.setHabilitado(false);
        this.cotacaoDolarDataAquisicao.setReadOnly(true);
        this.custoAquisicaoOrigemNacionalReal.setReadOnly(true);
        this.custoAquisicaoOrigemNacionalDolar.setReadOnly(true);
        this.custoAquisicaoOrigemMEDolar.setReadOnly(true);
        this.custoAquisicaoTotalDolar.setReadOnly(true);
        this.percentualCustoAquisicaoOrigemNacional.setReadOnly(true);
        this.percentualCustoAquisicaoOrigemME.setReadOnly(true);
    }

    public ValorPositivo getCustoAquisicao() {
        return this.custoAquisicao;
    }

    public Data getDataAquisicao() {
        return this.dataAquisicao;
    }

    public Codigo getOrigemRendimentos() {
        return this.origemRendimentos;
    }

    public ValorPositivo getCotacaoDolarDataAquisicao() {
        return this.cotacaoDolarDataAquisicao;
    }

    public ValorPositivo getCustoAquisicaoOrigemNacionalReal() {
        return this.custoAquisicaoOrigemNacionalReal;
    }

    public ValorPositivo getCustoAquisicaoOrigemNacionalDolar() {
        return this.custoAquisicaoOrigemNacionalDolar;
    }

    public ValorPositivo getCustoAquisicaoOrigemMEDolar() {
        return this.custoAquisicaoOrigemMEDolar;
    }

    public ValorPositivo getCustoAquisicaoTotalDolar() {
        return this.custoAquisicaoTotalDolar;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemNacional() {
        return this.percentualCustoAquisicaoOrigemNacional;
    }

    public ValorPositivo getPercentualCustoAquisicaoOrigemME() {
        return this.percentualCustoAquisicaoOrigemME;
    }

    public Codigo getMoedaEstrangeira() {
        return this.moedaEstrangeira;
    }

    public Logico getResidenteBrasilAplicacaoExterior() {
        return this.residenteBrasilAplicacaoExterior;
    }
}

