/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.especie;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;

public class MoedasAlienadasMensal
extends ObjetoNegocio {
    public static int CONST_MES_JANEIRO = 0;
    public static int CONST_MES_FEVEREIRO = 1;
    public static int CONST_MES_MARCO = 2;
    public static int CONST_MES_ABRIL = 3;
    public static int CONST_MES_MAIO = 4;
    public static int CONST_MES_JUNHO = 5;
    public static int CONST_MES_JULHO = 6;
    public static int CONST_MES_AGOSTO = 7;
    public static int CONST_MES_SETEMBRO = 8;
    public static int CONST_MES_OUTUBRO = 9;
    public static int CONST_MES_NOVEMBRO = 10;
    public static int CONST_MES_DEZEMBRO = 11;
    public static String CONST_NOME_MES_JANEIRO = "Janeiro";
    public static String CONST_NOME_MES_FEVEREIRO = "Fevereiro";
    public static String CONST_NOME_MES_MARCO = "Marco";
    public static String CONST_NOME_MES_ABRIL = "Abril";
    public static String CONST_NOME_MES_MAIO = "Maio";
    public static String CONST_NOME_MES_JUNHO = "Junho";
    public static String CONST_NOME_MES_JULHO = "Julho";
    public static String CONST_NOME_MES_AGOSTO = "Agosto";
    public static String CONST_NOME_MES_SETEMBRO = "Setembro";
    public static String CONST_NOME_MES_OUTUBRO = "Outubro";
    public static String CONST_NOME_MES_NOVEMBRO = "Novembro";
    public static String CONST_NOME_MES_DEZEMBRO = "Dezembro";
    public static int CONST_CAMPO_ALIENACOES_DOLAR = 1;
    public static int CONST_CAMPO_ALIENACOES_CONSOLIDADAS_DOLAR = 2;
    public static int CONST_CAMPO_GANHOS_CAPITAL = 3;
    public static int CONST_CAMPO_GANHOS_CAPITAL_TRIBUTAVEL = 4;
    public static int CONST_CAMPO_IMPOSTO_DEVIDO = 6;
    public static int CONST_CAMPO_IMPOSTO_PAGO = 7;
    private Alfa mes = new Alfa("M\u00eas");
    private ValorPositivo alienacoesDolar = new ValorPositivo(this, "Aliena\u00e7\u00f5es em d\u00f3lar (US$)", 11, 2);
    private ValorPositivo alienacoesConsolidadasDolar = new ValorPositivo(this, "Aliena\u00e7\u00f5es consolidadas em d\u00f3lar (US$)", 11, 2);
    private ValorPositivo ganhosCapital = new ValorPositivo(this, "Ganhos de capital (R$)", 11, 2);
    private ValorPositivo ganhosCapitalTributavel = new ValorPositivo(this, "Ganhos de capital tribut\u00e1vel (R$)", 11, 2);
    private ValorPositivo aliquotaMedia = new ValorPositivo(this, "Al\u00edquota m\u00e9dia (%)", 11, 6);
    private ValorPositivo impostoDevido = new ValorPositivo(this, "Imposto devido (R$)", 11, 2);
    private ValorPositivo impostoPago = new ValorPositivo(this, "Imposto pago (R$)", 11, 2);

    public MoedasAlienadasMensal() {
    }

    public MoedasAlienadasMensal(String mes) {
        this.getMes().setConteudo(mes);
    }

    public Alfa getMes() {
        return this.mes;
    }

    public ValorPositivo getAlienacoesDolar() {
        return this.alienacoesDolar;
    }

    public ValorPositivo getAlienacoesConsolidadasDolar() {
        return this.alienacoesConsolidadasDolar;
    }

    public ValorPositivo getGanhosCapital() {
        return this.ganhosCapital;
    }

    public ValorPositivo getGanhosCapitalTributavel() {
        return this.ganhosCapitalTributavel;
    }

    public ValorPositivo getAliquotaMedia() {
        return this.aliquotaMedia;
    }

    public ValorPositivo getImpostoDevido() {
        return this.impostoDevido;
    }

    public ValorPositivo getImpostoPago() {
        return this.impostoPago;
    }

    public ValorPositivo obterValor(int campo) {
        switch (campo) {
            case 1: {
                return this.getAlienacoesDolar();
            }
            case 2: {
                return this.getAlienacoesConsolidadasDolar();
            }
            case 3: {
                return this.getGanhosCapital();
            }
            case 4: {
                return this.getGanhosCapitalTributavel();
            }
            case 6: {
                return this.getImpostoDevido();
            }
            case 7: {
                return this.getImpostoPago();
            }
        }
        return null;
    }

    public String getMesToTXT() {
        if (CONST_NOME_MES_JANEIRO.equals(this.mes.naoFormatado())) {
            return "01";
        }
        if (CONST_NOME_MES_FEVEREIRO.equals(this.mes.naoFormatado())) {
            return "02";
        }
        if (CONST_NOME_MES_MARCO.equals(this.mes.naoFormatado())) {
            return "03";
        }
        if (CONST_NOME_MES_ABRIL.equals(this.mes.naoFormatado())) {
            return "04";
        }
        if (CONST_NOME_MES_MAIO.equals(this.mes.naoFormatado())) {
            return "05";
        }
        if (CONST_NOME_MES_JUNHO.equals(this.mes.naoFormatado())) {
            return "06";
        }
        if (CONST_NOME_MES_JULHO.equals(this.mes.naoFormatado())) {
            return "07";
        }
        if (CONST_NOME_MES_AGOSTO.equals(this.mes.naoFormatado())) {
            return "08";
        }
        if (CONST_NOME_MES_SETEMBRO.equals(this.mes.naoFormatado())) {
            return "09";
        }
        if (CONST_NOME_MES_OUTUBRO.equals(this.mes.naoFormatado())) {
            return "10";
        }
        if (CONST_NOME_MES_NOVEMBRO.equals(this.mes.naoFormatado())) {
            return "11";
        }
        if (CONST_NOME_MES_DEZEMBRO.equals(this.mes.naoFormatado())) {
            return "12";
        }
        return "00";
    }

    public String obterNomeMesPorValorTxt(String mes) {
        if ("01".equals(mes)) {
            return CONST_NOME_MES_JANEIRO;
        }
        if ("02".equals(mes)) {
            return CONST_NOME_MES_FEVEREIRO;
        }
        if ("03".equals(mes)) {
            return CONST_NOME_MES_MARCO;
        }
        if ("04".equals(mes)) {
            return CONST_NOME_MES_ABRIL;
        }
        if ("05".equals(mes)) {
            return CONST_NOME_MES_MAIO;
        }
        if ("06".equals(mes)) {
            return CONST_NOME_MES_JUNHO;
        }
        if ("07".equals(mes)) {
            return CONST_NOME_MES_JULHO;
        }
        if ("08".equals(mes)) {
            return CONST_NOME_MES_AGOSTO;
        }
        if ("09".equals(mes)) {
            return CONST_NOME_MES_SETEMBRO;
        }
        if ("10".equals(mes)) {
            return CONST_NOME_MES_OUTUBRO;
        }
        if ("11".equals(mes)) {
            return CONST_NOME_MES_NOVEMBRO;
        }
        if ("12".equals(mes)) {
            return CONST_NOME_MES_DEZEMBRO;
        }
        return "";
    }
}

