/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.perguntas;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemImovel;

public class PerguntasUtil {
    private static PerguntasUtil pergutasUtil = new PerguntasUtil();

    private PerguntasUtil() {
    }

    public static PerguntasUtil getInstancia() {
        return pergutasUtil;
    }

    public ValorPositivo obterValorLiquidoAlienacao(AlienacaoBemImovel alienacaoBemImovel) {
        ValorPositivo valorLiquidoAlienacao = new ValorPositivo();
        if (alienacaoBemImovel.getBemImovel().isAdquiridoNoBrasil()) {
            valorLiquidoAlienacao.setConteudo(alienacaoBemImovel.getValorAlienacao().operacao('-', alienacaoBemImovel.getCustoCorretagem()));
        } else {
            valorLiquidoAlienacao.append('+', alienacaoBemImovel.getApuracao().getValorLiquidoAlienacaoDolar());
            valorLiquidoAlienacao.append('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao());
        }
        return valorLiquidoAlienacao;
    }

    public ValorPositivo obterValorAlienacao(AlienacaoBemImovel alienacaoBemImovel) {
        ValorPositivo valorAlienacao = new ValorPositivo();
        if (alienacaoBemImovel.getBemImovel().isAdquiridoNoBrasil()) {
            valorAlienacao.setConteudo(alienacaoBemImovel.getValorAlienacao());
        } else {
            valorAlienacao.setConteudo(alienacaoBemImovel.getValorAlienacaoDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
        }
        return valorAlienacao;
    }

    public boolean temPrejuizo(AlienacaoBemImovel alienacaoBemImovel) {
        boolean prejuizo = false;
        prejuizo = alienacaoBemImovel.isAlienacaoBrasil() ? alienacaoBemImovel.getApuracao().getGanhoCapital1().comparacao("<=", "0,00") : alienacaoBemImovel.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', alienacaoBemImovel.getApuracao().getGanhoCapital1OrigemMEReal()).comparacao("<=", "0,00");
        return prejuizo;
    }

    public boolean isValorAlienacaoEntreLimitesIsencao(AlienacaoBemImovel alienacaoBemImovel) {
        ValorPositivo valorPreenchido = new ValorPositivo();
        valorPreenchido = this.obterValorAlienacao(alienacaoBemImovel);
        ValorPositivo lValorReferencia1 = alienacaoBemImovel.getValorIsencao();
        ValorPositivo valorReferencia2 = alienacaoBemImovel.getValorIsencaoUnicoImovel();
        if (String.valueOf(AlienacaoBemImovel.CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(alienacaoBemImovel.getNatureza().naoFormatado())) {
            if (alienacaoBemImovel.isAlienacaoBrasil()) {
                valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicao());
            } else {
                String origemRendimentos = alienacaoBemImovel.obterCodigoOrigemRendimentos().getConteudoAtual(0);
                if ("1".equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                } else if ("2".equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                } else if ("3".equals(origemRendimentos)) {
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemNacionalReal());
                    valorPreenchido.append('+', alienacaoBemImovel.getApuracao().getCustoAquisicaoOrigemMEDolar().operacao('*', alienacaoBemImovel.getCotacaoDolarDataAlienacao()));
                }
            }
        }
        boolean isMaiorReferencial1 = valorPreenchido.compareTo(lValorReferencia1) > 0;
        boolean isMenorOuIgualReferencial2 = valorPreenchido.compareTo(valorReferencia2) <= 0;
        return isMaiorReferencial1 && isMenorOuIgualReferencial2;
    }
}

