/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendIsentos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroPensaoMolestiaGrave
extends Colecao<ItemQuadroPensaoMolestiaGrave> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private Valor totalRendimento = new Valor((ObjetoNegocio)this, "Total Rendimento");
    private Valor totalIRRFDependentes = new Valor((ObjetoNegocio)this, "Total IRRF Dependentes");
    private Valor totalIRRFTitular = new Valor((ObjetoNegocio)this, "Total IRRF do Titular");
    private Valor total13Salario = new Valor((ObjetoNegocio)this, "Total 13 Sal\u00e1rio");
    private Valor totalIRRF13SalarioDependentes = new Valor((ObjetoNegocio)this, "Total IRRF sobre o 13 Sal\u00e1rio");
    private Valor totalIRRF13SalarioTitular = new Valor((ObjetoNegocio)this, "Total IRRF sobre o 13 Sal\u00e1rio do Titular");
    private Valor totalPrevidenciaOficialTitular = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia Oficial do Titular");
    private Valor totalPrevidenciaOficialDependentes = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia Oficial dos Dependentes");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroPensaoMolestiaGrave() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public Valor getTotalRendimento() {
        return this.totalRendimento;
    }

    public Valor getTotalIRRFTitular() {
        return this.totalIRRFTitular;
    }

    public Valor getTotalIRRF13SalarioTitular() {
        return this.totalIRRF13SalarioTitular;
    }

    public Valor getTotalIRRFDependentes() {
        return this.totalIRRFDependentes;
    }

    public Valor getTotal13Salario() {
        return this.total13Salario;
    }

    public Valor getTotalIRRF13SalarioDependentes() {
        return this.totalIRRF13SalarioDependentes;
    }

    public Valor getTotalPrevidenciaOficialTitular() {
        return this.totalPrevidenciaOficialTitular;
    }

    public Valor getTotalPrevidenciaOficialDependentes() {
        return this.totalPrevidenciaOficialDependentes;
    }

    public void objetoInserido(ItemQuadroPensaoMolestiaGrave itemQuadroPensaoMolestiaGrave) {
        itemQuadroPensaoMolestiaGrave.getValor().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValorIRRF().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValor13Salario().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValorIRRF13Salario().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValorPrevidenciaOficial().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object o) {
        ((ItemQuadroPensaoMolestiaGrave)((Object)o)).getValor().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)o)).getValorIRRF().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)o)).getValor13Salario().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)o)).getValorIRRF13Salario().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)o)).getValorPrevidenciaOficial().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Valor total = new Valor();
        Valor totalRendimento = new Valor();
        Valor total13Salario = new Valor();
        Valor totalIRRFDependentes = new Valor();
        Valor totalIRRFTitular = new Valor();
        Valor totalIRRF13SalarioDependentes = new Valor();
        Valor totalIRRF13SalarioTitular = new Valor();
        Valor totalPrevidenciaOficialDependentes = new Valor();
        Valor totalPrevidenciaOficialTitular = new Valor();
        for (ItemQuadroPensaoMolestiaGrave item : this.itens()) {
            totalRendimento.append('+', item.getValor());
            total13Salario.append('+', (Valor)item.getValor13Salario());
            if (item.getTipoBeneficiario().naoFormatado().equals("Titular")) {
                totalIRRFTitular.append('+', (Valor)item.getValorIRRF());
                totalIRRF13SalarioTitular.append('+', (Valor)item.getValorIRRF13Salario());
                totalPrevidenciaOficialTitular.append('+', (Valor)item.getValorPrevidenciaOficial());
                continue;
            }
            totalIRRFDependentes.append('+', (Valor)item.getValorIRRF());
            totalIRRF13SalarioDependentes.append('+', (Valor)item.getValorIRRF13Salario());
            totalPrevidenciaOficialDependentes.append('+', (Valor)item.getValorPrevidenciaOficial());
        }
        total.append('+', totalRendimento);
        total.append('+', total13Salario);
        this.getTotais().setConteudo(total);
        this.getTotalRendimento().setConteudo(totalRendimento);
        this.getTotal13Salario().setConteudo(total13Salario);
        this.getTotalIRRFDependentes().setConteudo(totalIRRFDependentes);
        this.getTotalIRRFTitular().setConteudo(totalIRRFTitular);
        this.getTotalIRRF13SalarioDependentes().setConteudo(totalIRRF13SalarioDependentes);
        this.getTotalIRRF13SalarioTitular().setConteudo(totalIRRF13SalarioTitular);
        this.getTotalPrevidenciaOficialDependentes().setConteudo(totalPrevidenciaOficialDependentes);
        this.getTotalPrevidenciaOficialTitular().setConteudo(totalPrevidenciaOficialTitular);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade.equals("Valor") || nomePropriedade.equals("Rendimento") || nomePropriedade.equals("IRRF") || nomePropriedade.equals("13\u00ba Sal\u00e1rio") || nomePropriedade.equals("IRRF sobre o 13\u00ba Sal\u00e1rio") || nomePropriedade.equals("Previd\u00eancia Oficial")) {
            this.calculaTotal();
        }
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (ItemQuadroPensaoMolestiaGrave item : this.itens()) {
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemQuadroPensaoMolestiaGrave item = (ItemQuadroPensaoMolestiaGrave)((Object)it.next());
            if (!item.getTipoBeneficiario().naoFormatado().equals("Dependente") || !cpf.equals(item.getCpfBeneficiario().naoFormatado())) continue;
            it.remove();
        }
    }

    public ItemQuadroPensaoMolestiaGrave instanciaNovoObjeto() {
        return new ItemQuadroPensaoMolestiaGrave((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> dec) {
        this.dec = dec;
    }
}

