/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendTributacaoExclusiva;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelRendTributacaoExclusiva;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.QuadroAuxiliarUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class RendTributacaoExclusiva
extends ObjetoNegocio
implements ObjetoFicha {
    public static String TIPO_RENDEXCLUSIVO_06 = "06";
    public static String TIPO_RENDEXCLUSIVO_10 = "10";
    public static String TIPO_RENDEXCLUSIVO_11 = "11";
    public static String TIPO_RENDEXCLUSIVO_12 = "12";
    public static String TIPO_RENDEXCLUSIVO_13 = "13";
    public static String TIPO_RENDEXCLUSIVO_OUTROS_TELA = "99";
    public static String TIPO_RENDEXCLUSIVO_LEI14754_TELA = "12";
    public static final String COD_OUTROS_RENDIMENTOS_TRIBUTACAO_EXCLUSIVA = "2";
    private ValorPositivo decimoTerceiro = new ValorPositivo(this, "13o Sal\u00e1rio");
    private ValorPositivo ganhosCapital = new ValorPositivo(this, "Ganhos de Capital - Aliena\u00e7\u00e3o de Bens ou Direitos");
    private ValorPositivo ganhosCapitalEstrangeira = new ValorPositivo(this, "Ganhos de Capital - Aliena\u00e7\u00e3o de Bens ou Direitos em Moeda Estrangeira");
    private ValorPositivo ganhosCapitalEmEspecie = new ValorPositivo(this, "Ganhos de Capital - Aliena\u00e7\u00e3o de Moeda Estrangeira em Esp\u00e9cie");
    private ValorPositivo ganhosRendaVariavel = new ValorPositivo(this, "Ganhos L\u00edquidos em Renda Vari\u00e1vel");
    private ValorPositivo rendAplicacoes = new ValorPositivo(this, "Rendimentos de Aplica\u00e7\u00f5es Financeiras");
    private ColecaoItemQuadroTransporteDetalhado rendAplicacoesQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado(this);
    private ValorPositivo outros = new ValorPositivo(this, "Outros Rendimentos do Titular");
    private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(this);
    private ValorPositivo decimoTerceiroDependentes = new ValorPositivo(this, "13o Sal\u00e1rio dos Dependentes");
    private ValorPositivo rraTitular = new ValorPositivo(this, "Rendimentos Recebidos Acumuladamente");
    private ValorPositivo rraDependentes = new ValorPositivo(this, "Rendimentos Recebidos Acumuladamente pelos Dependentes");
    private ValorPositivo jurosCapitalProprio = new ValorPositivo(this, "juros Capital Proprio");
    private ColecaoItemQuadroTransporteDetalhado jurosCapitalProprioQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado(this);
    private ValorPositivo participacaoLucrosResultados = new ValorPositivo(this, "participacao Lucros Resultados");
    private ColecaoItemQuadroTransporteDetalhado participacaoLucrosResultadosQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado(this);
    private ValorPositivo lei14754 = new ValorPositivo(this, "Aplica\u00e7\u00f5es Financeiras e Lucros e Dividendos no Exterior (Lei 14.754/2023)");
    private ValorPositivo total = new ValorPositivo(this, "Total dos Rendimentos");
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public RendTributacaoExclusiva(final DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.getRendAplicacoesQuadroAuxiliar().setDec(this.weakDec);
        this.getJurosCapitalProprioQuadroAuxiliar().setDec(this.weakDec);
        this.getParticipacaoLucrosResultadosQuadroAuxiliar().setDec(this.weakDec);
        this.getOutrosQuadroAuxiliar().setDec(this.weakDec);
        this.getDecimoTerceiro().setReadOnly(true);
        this.getGanhosCapital().setReadOnly(true);
        this.getGanhosCapitalEstrangeira().setReadOnly(true);
        this.getGanhosCapitalEmEspecie().setReadOnly(true);
        this.getGanhosRendaVariavel().setReadOnly(true);
        this.getRendAplicacoes().setReadOnly(true);
        this.getDecimoTerceiroDependentes().setReadOnly(true);
        this.getRraTitular().setReadOnly(true);
        this.getRraDependentes().setReadOnly(true);
        this.getJurosCapitalProprio().setReadOnly(true);
        this.getParticipacaoLucrosResultados().setReadOnly(true);
        this.getLei14754().setReadOnly(true);
        this.getOutros().setReadOnly(true);
        this.getTotal().setReadOnly(true);
        this.rendAplicacoes.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendTributacaoExclusiva.this.rendAplicacoesQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendtribexcl_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.jurosCapitalProprio.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendTributacaoExclusiva.this.jurosCapitalProprioQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendtribexcl_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.participacaoLucrosResultados.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroTransporteDetalhado item : RendTributacaoExclusiva.this.participacaoLucrosResultadosQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendtribexcl_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.outros.addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                for (ItemQuadroOutrosRendimentos item : RendTributacaoExclusiva.this.outrosQuadroAuxiliar.itens()) {
                    if (!item.getTipoBeneficiario().formatado().equals("Dependente") || !item.getCpfBeneficiario().formatado().equals(dec.getIdentificadorDeclaracao().getCpf().formatado())) continue;
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendtribexcl_beneficiario_nao_dependente"), this.getSeveridade());
                }
                return null;
            }
        });
        this.setFicha("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva");
    }

    public List<Pendencia> verificarPendencias(int index) {
        List listPendencias = super.verificarPendencias(index);
        List<ElementoTabela> tiposRendimentos = CadastroTabelasIRPF.recuperarTiposRendimentosTributacaoExclusiva();
        List<Colecao<? extends ItemQuadroAuxiliarAb>> lista = this.getColecoesRendimentos();
        int indice = 0;
        int offset = 1;
        for (Colecao<? extends ItemQuadroAuxiliarAb> itens : lista) {
            listPendencias.addAll(QuadroAuxiliarUtil.validarQuadroAuxiliarAb(itens, offset, tiposRendimentos.get(indice).getConteudo(1), false));
            offset += itens.itens().size();
            ++indice;
        }
        return listPendencias;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.rendAplicacoes);
        lista.add(this.jurosCapitalProprio);
        lista.add(this.participacaoLucrosResultados);
        lista.add(this.outros);
        lista.add(this.total);
        return lista;
    }

    public void addObservador(Observador obs) {
        this.ganhosCapital.addObservador(obs);
        this.ganhosCapitalEstrangeira.addObservador(obs);
        this.ganhosCapitalEmEspecie.addObservador(obs);
        this.ganhosRendaVariavel.addObservador(obs);
        this.rendAplicacoes.addObservador(obs);
        this.outros.addObservador(obs);
        this.decimoTerceiroDependentes.addObservador(obs);
        this.rraTitular.addObservador(obs);
        this.rraDependentes.addObservador(obs);
        this.jurosCapitalProprio.addObservador(obs);
        this.participacaoLucrosResultados.addObservador(obs);
        this.lei14754.addObservador(obs);
    }

    public boolean totalAlto() {
        return this.total.comparacao(">", "1.000.000,00");
    }

    public Valor recuperarExclusivosTitular() {
        Valor result = new Valor();
        result.append('+', (Valor)this.ganhosCapital);
        result.append('+', (Valor)this.ganhosCapitalEstrangeira);
        result.append('+', (Valor)this.ganhosCapitalEmEspecie);
        result.append('+', (Valor)this.decimoTerceiro);
        result.append('+', (Valor)this.ganhosRendaVariavel);
        result.append('+', (Valor)this.rraTitular);
        result.append('+', (Valor)this.lei14754);
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.rendAplicacoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.outrosQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.jurosCapitalProprioQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.participacaoLucrosResultadosQuadroAuxiliar));
        return result;
    }

    public Valor recuperarExclusivosDependentes() {
        Valor result = new Valor();
        result.append('+', (Valor)this.decimoTerceiroDependentes);
        result.append('+', (Valor)this.rraDependentes);
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.rendAplicacoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.outrosQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.jurosCapitalProprioQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.participacaoLucrosResultadosQuadroAuxiliar));
        return result;
    }

    public Valor recuperarTotalTitularExceto13_RV_e_GC() {
        Valor result = new Valor();
        result.append('+', (Valor)this.rraTitular);
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.rendAplicacoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.outrosQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.jurosCapitalProprioQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarTitular(this.participacaoLucrosResultadosQuadroAuxiliar));
        return result;
    }

    public Valor recuperarExclusivosDependentesExceto13Salario() {
        Valor result = new Valor();
        result.append('+', (Valor)this.rraDependentes);
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.rendAplicacoesQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.outrosQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.jurosCapitalProprioQuadroAuxiliar));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarDependente(this.participacaoLucrosResultadosQuadroAuxiliar));
        return result;
    }

    public Valor recuperarTotalPorBeneficiario(CPF cpfBeneficiario) {
        Valor result = new Valor();
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.rendAplicacoesQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.outrosQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.jurosCapitalProprioQuadroAuxiliar, cpfBeneficiario, false));
        result.append('+', QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorBeneficiario(this.participacaoLucrosResultadosQuadroAuxiliar, cpfBeneficiario, false));
        return result;
    }

    public String getClasseFicha() {
        return PainelRendTributacaoExclusiva.class.getName();
    }

    public boolean isVazio() {
        return this.decimoTerceiro.isVazio() && this.ganhosRendaVariavel.isVazio() && this.rendAplicacoes.isVazio() && this.outros.isVazio() && this.decimoTerceiroDependentes.isVazio() && this.ganhosCapital.isVazio() && this.ganhosCapitalEstrangeira.isVazio() && this.ganhosCapitalEmEspecie.isVazio() && this.rraTitular.isVazio() && this.rraDependentes.isVazio() && this.jurosCapitalProprio.isVazio() && this.participacaoLucrosResultados.isVazio() && this.lei14754.isVazio();
    }

    public String getNomeAba() {
        return null;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if (cpf == null || cpf.trim().isEmpty()) {
            return false;
        }
        return this.getRendAplicacoesQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getJurosCapitalProprioQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getParticipacaoLucrosResultadosQuadroAuxiliar().possuiDependenteComCPF(cpf) || this.getOutrosQuadroAuxiliar().possuiDependenteComCPF(cpf);
    }

    public void excluirDependentesComCPF(String cpf) {
        this.getRendAplicacoesQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getJurosCapitalProprioQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getParticipacaoLucrosResultadosQuadroAuxiliar().excluirDependentesComCPF(cpf);
        this.getOutrosQuadroAuxiliar().excluirDependentesComCPF(cpf);
    }

    public List<Colecao<? extends ItemQuadroAuxiliarAb>> getColecoesRendimentos() {
        ArrayList<Colecao<? extends ItemQuadroAuxiliarAb>> colecoes = new ArrayList<Colecao<? extends ItemQuadroAuxiliarAb>>();
        colecoes.add(this.getRendAplicacoesQuadroAuxiliar());
        colecoes.add(this.getJurosCapitalProprioQuadroAuxiliar());
        colecoes.add(this.getParticipacaoLucrosResultadosQuadroAuxiliar());
        colecoes.add(this.getOutrosQuadroAuxiliar());
        return colecoes;
    }

    public Valor getValorPorTipoRendimento(int tipo) {
        switch (tipo) {
            case 1: {
                return this.getDecimoTerceiro();
            }
            case 2: {
                return this.getGanhosCapital();
            }
            case 3: {
                return this.getGanhosCapitalEstrangeira();
            }
            case 4: {
                return this.getGanhosCapitalEmEspecie();
            }
            case 5: {
                return this.getGanhosRendaVariavel();
            }
            case 6: {
                return this.getRendAplicacoes();
            }
            case 7: {
                return this.getRraTitular();
            }
            case 8: {
                return this.getDecimoTerceiroDependentes();
            }
            case 9: {
                return this.getRraDependentes();
            }
            case 10: {
                return this.getJurosCapitalProprio();
            }
            case 11: {
                return this.getParticipacaoLucrosResultados();
            }
            case 12: {
                return this.getOutros();
            }
            case 13: {
                return this.getLei14754();
            }
        }
        return null;
    }

    private void preencherNomeComCache(String key, Informacao informacao) {
        String valor = CacheNI.getInstancia().getCachedKey(key);
        if (valor != null) {
            informacao.setConteudo(valor);
        }
    }

    public void atualizarRendExclusivo(Bem bem, String codigoRendimento) {
        block6: {
            block7: {
                if (!TIPO_RENDEXCLUSIVO_06.equals(codigoRendimento)) break block7;
                for (ItemQuadroTransporteDetalhado item : this.getRendAplicacoesQuadroAuxiliar().itens()) {
                    if (!item.getCodBem().naoFormatado().equals(bem.getIndice().naoFormatado())) continue;
                    if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                        item.getTipoBeneficiario().setConteudo("Titular");
                    } else {
                        item.getTipoBeneficiario().setConteudo("Dependente");
                    }
                    item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
                    item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
                    this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFonte());
                    break block6;
                }
                break block6;
            }
            if (!TIPO_RENDEXCLUSIVO_10.equals(codigoRendimento)) break block6;
            for (ItemQuadroTransporteDetalhado item : this.getJurosCapitalProprioQuadroAuxiliar().itens()) {
                if (!item.getCodBem().naoFormatado().equals(bem.getIndice().naoFormatado())) continue;
                if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
                    item.getTipoBeneficiario().setConteudo("Titular");
                } else {
                    item.getTipoBeneficiario().setConteudo("Dependente");
                }
                item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
                item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
                this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFonte());
                break;
            }
        }
    }

    public void excluirRendimento(String tipoRendimento, ItemQuadroAuxiliarAb item) {
        if (TIPO_RENDEXCLUSIVO_06.equals(tipoRendimento)) {
            this.getRendAplicacoesQuadroAuxiliar().remove((ItemQuadroTransporteDetalhado)item);
        } else if (TIPO_RENDEXCLUSIVO_10.equals(tipoRendimento)) {
            this.getJurosCapitalProprioQuadroAuxiliar().remove((ItemQuadroTransporteDetalhado)item);
        }
    }

    public ItemQuadroAuxiliarAb criarNovoRendimentoExclusivo(Bem bem, String codigoRendimento) {
        ItemQuadroAuxiliarAb itemRetorno = null;
        if (TIPO_RENDEXCLUSIVO_06.equals(codigoRendimento)) {
            itemRetorno = this.adicionarNovoRendimentoExclusivo(bem, this.getRendAplicacoesQuadroAuxiliar());
        } else if (TIPO_RENDEXCLUSIVO_10.equals(codigoRendimento)) {
            itemRetorno = this.adicionarNovoRendimentoExclusivo(bem, this.getJurosCapitalProprioQuadroAuxiliar());
        }
        return itemRetorno;
    }

    private ItemQuadroAuxiliarAb adicionarNovoRendimentoExclusivo(Bem bem, Colecao colecao) {
        ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.weakDec.get()), (ObjetoNegocio)colecao);
        item.getCodBem().setConteudo(bem.getIndice());
        if (bem.getCPFBeneficiario().naoFormatado().equals(((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().naoFormatado())) {
            item.getTipoBeneficiario().setConteudo("Titular");
        } else {
            item.getTipoBeneficiario().setConteudo("Dependente");
        }
        item.getCpfBeneficiario().setConteudo(bem.getCPFBeneficiario());
        item.getCnpjEmpresa().setConteudo(bem.getNiEmpresa());
        this.preencherNomeComCache(item.getCnpjEmpresa().naoFormatado(), (Informacao)item.getNomeFonte());
        colecao.add((ObjetoNegocio)item);
        return item;
    }

    public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar() {
        return this.outrosQuadroAuxiliar;
    }

    public ColecaoItemQuadroTransporteDetalhado getRendAplicacoesQuadroAuxiliar() {
        return this.rendAplicacoesQuadroAuxiliar;
    }

    public Valor getTotal() {
        return this.total;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public Valor getDecimoTerceiroDependentes() {
        return this.decimoTerceiroDependentes;
    }

    public Valor getGanhosCapital() {
        return this.ganhosCapital;
    }

    public Valor getGanhosCapitalEmEspecie() {
        return this.ganhosCapitalEmEspecie;
    }

    public Valor getGanhosCapitalEstrangeira() {
        return this.ganhosCapitalEstrangeira;
    }

    public Valor getGanhosRendaVariavel() {
        return this.ganhosRendaVariavel;
    }

    public Valor getOutros() {
        return this.outros;
    }

    public Valor getRendAplicacoes() {
        return this.rendAplicacoes;
    }

    public Valor getJurosCapitalProprio() {
        return this.jurosCapitalProprio;
    }

    public ColecaoItemQuadroTransporteDetalhado getJurosCapitalProprioQuadroAuxiliar() {
        return this.jurosCapitalProprioQuadroAuxiliar;
    }

    public Valor getParticipacaoLucrosResultados() {
        return this.participacaoLucrosResultados;
    }

    public ColecaoItemQuadroTransporteDetalhado getParticipacaoLucrosResultadosQuadroAuxiliar() {
        return this.participacaoLucrosResultadosQuadroAuxiliar;
    }

    public ValorPositivo getRraTitular() {
        return this.rraTitular;
    }

    public ValorPositivo getRraDependentes() {
        return this.rraDependentes;
    }

    public ValorPositivo getLei14754() {
        return this.lei14754;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva";
    }
}

