/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ObservadorRendimentosTributaveisCalculado
extends Observador {
    private RendAcmTitular rendAcm;
    private WeakReference<DeclaracaoIRPF> weakDec;
    private WeakReference<? extends Colecao<RendAcmTitular>> weakColecao = null;

    public ObservadorRendimentosTributaveisCalculado(RendAcmTitular rendAcm, DeclaracaoIRPF dec, Colecao<RendAcmTitular> colecao) {
        this.rendAcm = rendAcm;
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.weakColecao = new WeakReference<Colecao<RendAcmTitular>>(colecao);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (this.rendAcm.getOpcaoTributacao().naoFormatado().equals("E")) {
            ValorPositivo rendTributCalculado = new ValorPositivo();
            rendTributCalculado.append('+', this.rendAcm.getRendRecebidosInformado());
            rendTributCalculado.append('+', this.rendAcm.getParcIsenta65Anos());
            this.rendAcm.getRendRecebidos().setConteudo(rendTributCalculado);
        } else if (this.rendAcm.getOpcaoTributacao().naoFormatado().equals("A")) {
            if (nomePropriedade.equals("Parcela isenta 65 anos") || nomePropriedade.equals("Dependente")) {
                Valor disponivel65 = new Valor();
                Valor totalDeclaradoIsento65SemAtual = new Valor();
                Valor rendimento = new Valor();
                Valor isento65 = new Valor();
                Valor sobra = new Valor();
                boolean alterouIsento = false;
                boolean registroAtualContabilizado = false;
                String cpfContribuinte = ((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().formatado();
                if (this.rendAcm instanceof RendAcmDependente) {
                    cpfContribuinte = ((RendAcmDependente)this.rendAcm).getCpfDependente().formatado();
                }
                for (RendAcmTitular lRendAcm : ((Colecao)this.weakColecao.get()).itens()) {
                    String cpfAtual = this.rendAcm instanceof RendAcmDependente ? ((RendAcmDependente)lRendAcm).getCpfDependente().formatado() : ((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().getCpf().formatado();
                    if (!cpfContribuinte.equals(cpfAtual)) continue;
                    if (!registroAtualContabilizado && lRendAcm.getParcIsenta65Anos().formatado().equals(this.rendAcm.getParcIsenta65Anos().formatado())) {
                        registroAtualContabilizado = true;
                        continue;
                    }
                    totalDeclaradoIsento65SemAtual.append('+', (Valor)lRendAcm.getParcIsenta65Anos());
                }
                for (ItemQuadroTransporteDetalhado item : ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().itens()) {
                    if (!item.getCpfBeneficiario().formatado().equals(cpfContribuinte)) continue;
                    totalDeclaradoIsento65SemAtual.append('+', item.getValor());
                }
                disponivel65.setConteudo("22.847,76");
                disponivel65.append('-', totalDeclaradoIsento65SemAtual);
                if (disponivel65.comparacao(">", "0,00")) {
                    if (this.rendAcm.getParcIsenta65Anos().comparacao(">", "1.903,98")) {
                        if (disponivel65.comparacao(">", "1.903,98")) {
                            sobra.setConteudo((Valor)this.rendAcm.getParcIsenta65Anos());
                            sobra.append('-', "1.903,98");
                            rendimento.setConteudo((Valor)this.rendAcm.getRendRecebidosInformado());
                            rendimento.append('+', sobra);
                            isento65.setConteudo("1.903,98");
                            alterouIsento = true;
                        } else {
                            sobra.setConteudo((Valor)this.rendAcm.getParcIsenta65Anos());
                            sobra.append('-', disponivel65);
                            rendimento.setConteudo((Valor)this.rendAcm.getRendRecebidosInformado());
                            rendimento.append('+', sobra);
                            isento65.setConteudo(disponivel65);
                            alterouIsento = true;
                        }
                    } else if (disponivel65.comparacao("<", (Valor)this.rendAcm.getParcIsenta65Anos())) {
                        sobra.setConteudo((Valor)this.rendAcm.getParcIsenta65Anos());
                        sobra.append('-', disponivel65);
                        rendimento.setConteudo((Valor)this.rendAcm.getRendRecebidosInformado());
                        rendimento.append('+', sobra);
                        isento65.setConteudo(disponivel65);
                        alterouIsento = true;
                    } else {
                        rendimento.setConteudo((Valor)this.rendAcm.getRendRecebidosInformado());
                        isento65.setConteudo((Valor)this.rendAcm.getParcIsenta65Anos());
                    }
                } else {
                    rendimento.setConteudo((Valor)this.rendAcm.getRendRecebidosInformado());
                    rendimento.append('+', (Valor)this.rendAcm.getParcIsenta65Anos());
                    isento65.clear();
                    if (!this.rendAcm.getParcIsenta65Anos().isVazio()) {
                        alterouIsento = true;
                    }
                }
                if (alterouIsento) {
                    GuiUtil.mostrarAviso((String)"rendisentos_limite_aposentadoria_rra_excedido", (String[])new String[]{cpfContribuinte});
                }
                this.rendAcm.getRendRecebidosInformado().setConteudo(rendimento);
                this.rendAcm.getParcIsenta65Anos().setConteudo(isento65);
            }
            this.rendAcm.getRendRecebidos().setConteudo(this.rendAcm.getRendRecebidosInformado());
        }
        if (this.rendAcm.getOpcaoTributacao().getNomeCampo().equals(nomePropriedade) && "V".equals((String)valorAntigo) && "A".equals((String)valorNovo)) {
            this.rendAcm.getParcIsenta65Anos().forcaDisparoObservadores();
        }
    }
}

