/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpjexigibilidade;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendPJComExigibilidadeDependente
extends ColecaoRendPJComExigibilidadeTitular {
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public ColecaoRendPJComExigibilidadeDependente(DeclaracaoIRPF dec) {
        super(dec.getIdentificadorDeclaracao());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Rendimentos Tribut\u00e1veis Recebidos de PJ com Exigibilidade Suspensa pelos Dependentes");
    }

    @Override
    public RendPJComExigibilidadeDependente instanciaNovoObjeto() {
        return new RendPJComExigibilidadeDependente((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
    }

    public RendPJComExigibilidadeDependente obterRendimentoPorChave(String niFontePagadora, String cpfBeneficiario) {
        for (RendPJComExigibilidadeTitular rend : this.itens()) {
            RendPJComExigibilidadeDependente rendDep = (RendPJComExigibilidadeDependente)rend;
            if (!rendDep.getNIFontePagadora().naoFormatado().equals(niFontePagadora) || !rendDep.getCpfDependente().naoFormatado().equals(cpfBeneficiario)) continue;
            return rendDep;
        }
        return null;
    }

    public boolean possuiDependenteComCPF(String cpf) {
        if ("".equals(cpf.trim())) {
            return false;
        }
        for (RendPJComExigibilidadeDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf)) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String cpf) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            RendPJComExigibilidadeDependente rend = (RendPJComExigibilidadeDependente)((Object)it.next());
            if (!rend.getCpfDependente().naoFormatado().equals(cpf)) continue;
            it.remove();
        }
    }

    public Valor obterRendimentosRecebidosPorDependente(CPF cpf) {
        Valor retorno = new Valor();
        for (RendPJComExigibilidadeDependente rend : this.itens()) {
            if (!rend.getCpfDependente().naoFormatado().equals(cpf.naoFormatado())) continue;
            retorno.append('+', (Valor)rend.getRendExigSuspensa());
        }
        return retorno;
    }
}

