/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gui.resumo.PainelCalculoImposto;
import serpro.ppgd.irpf.resumo.ObservadorCalcQuotas;
import serpro.ppgd.irpf.resumo.ObservadorContaPagamentoCEF;
import serpro.ppgd.irpf.resumo.ObservadorInfoBancariasVazias;
import serpro.ppgd.irpf.resumo.Parcelamento;
import serpro.ppgd.irpf.resumo.ValidadorInfoBancariasVazias;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.Validador;

public class CalculoImposto
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String CAMPO_DEBITO_AUTOMATICO = "D\u00e9bito autom\u00e1tico";
    public static final String DEBITO_AUTOMATICO_AUTORIZADO = "autorizado";
    public static final String DEBITO_AUTOMATICO_NAO_AUTORIZADO = "N";
    public static final String INDICADOR_QUOTA_VAZIO = "2";
    public static final String NOME_PROPRIEDADE_BANCO = "Banco";
    public static final String NOME_PROPRIEDADE_TIPO_CONTA = "Tipo de Conta";
    public static final String NOME_PROPRIEDADE_TIPO_CONTA_CEF = "TipoContaCEF";
    private static final List<String> bancosDebito = new ArrayList<String>();
    private Valor baseCalculo = new Valor((ObjetoNegocio)this, "baseCalculo");
    private Valor imposto = new Valor((ObjetoNegocio)this, "imposto");
    private Valor deducaoIncentivo = new Valor((ObjetoNegocio)this, "deducaoIncentivo");
    private Valor totalContribEmpregadoDomestico = new Valor((ObjetoNegocio)this, "totalContribEmpregadoDomestico");
    private Valor impostoDevido = new Valor((ObjetoNegocio)this, "impostoDevido");
    private Valor impostoDevidoI = new Valor((ObjetoNegocio)this, "impostoDevidoI");
    private Valor impostoDevidoII = new Valor((ObjetoNegocio)this, "impostoDevidoII");
    private Valor impostoDevidoRRA = new Valor((ObjetoNegocio)this, "impostoDevidoRRA");
    private Valor impostoDevidoLei14754 = new Valor((ObjetoNegocio)this, "impostoLei14754");
    private Valor impostoRetidoFonteTitular = new Valor((ObjetoNegocio)this, "impostoRetidoFonteTitular");
    private Valor impostoRetidoFonteDependentes = new Valor((ObjetoNegocio)this, "impostoRetidoFonteDependentes");
    private Valor impostoRetidoRRA = new Valor((ObjetoNegocio)this, "impostoRetidoRRA");
    private Valor carneLeaoTitular = new Valor((ObjetoNegocio)this, "carneLeaoTitular");
    private Valor carneLeaoDependentes = new Valor((ObjetoNegocio)this, "carneLeaoDependentes");
    private Valor impostoComplementar = new Valor((ObjetoNegocio)this, "impostoComplementar");
    private Valor impostoPagoExterior = new Valor((ObjetoNegocio)this, "impostoPagoExterior");
    private Valor impostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "impostoRetidoFonteLei11033");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "totalImpostoPago");
    private Valor impostoRestituir = new Valor((ObjetoNegocio)this, "impostoRestituir");
    private Codigo banco = new Codigo((ObjetoNegocio)this, "Banco", CadastroTabelasIRPF.recuperarBancosCredito());
    private Codigo tipoConta = new Codigo((ObjetoNegocio)this, "Tipo de Conta", CadastroTabelasIRPF.recuperarTipoConta());
    private Codigo agencia = new Codigo((ObjetoNegocio)this, "Ag\u00eancia", null);
    private Alfa dvAgencia = new Alfa((ObjetoNegocio)this, "dvAgencia");
    private Alfa contaCredito = new Alfa((ObjetoNegocio)this, "Conta para d\u00e9bito");
    private Alfa dvContaCredito = new Alfa((ObjetoNegocio)this, "D\u00edgito verificador", 2);
    private Alfa operacao = new Alfa((ObjetoNegocio)this, "Opera\u00e7\u00e3o");
    private Valor saldoImpostoPagar = new Valor((ObjetoNegocio)this, "saldoImpostoPagar");
    private Valor rendPJRecebidoTitular = new Valor((ObjetoNegocio)this, "rendPJRecebidoTitular");
    private Valor rendPJRecebidoDependentes = new Valor((ObjetoNegocio)this, "rendPJRecebidoDependentes");
    private Valor rendPFEXTRecebidoTitular = new Valor((ObjetoNegocio)this, "rendPFEXTRecebidoTitular");
    private Valor rendPFEXTRecebidoDependentes = new Valor((ObjetoNegocio)this, "rendPFEXTRecebidoDependentes");
    private Valor rendAcmTitular = new Valor((ObjetoNegocio)this, "rendAcmTitular");
    private Valor rendAcmDependentes = new Valor((ObjetoNegocio)this, "rendAcmDependentes");
    private Valor resultadoTributavelAR = new Valor((ObjetoNegocio)this, "resultadoTributavelAR");
    private Valor totalResultadosTributaveis = new Valor((ObjetoNegocio)this, "totalResultadosTributaveis");
    private Valor descontoSimplificado = new Valor((ObjetoNegocio)this, "descontoSimplificado");
    private Valor aliquotaEfetiva = new Valor((ObjetoNegocio)this, "aliquotaEfetiva");
    private Parcelamento parcelamento;
    private IdentificadorDeclaracao identificadorDec;
    private static int numInstancia = 1;

    public CalculoImposto(IdentificadorDeclaracao aIdentificador, Contribuinte contribuinte, DeclaracaoIRPF dec) {
        this.setFicha("C\u00e1lculo do Imposto");
        this.identificadorDec = aIdentificador;
        this.parcelamento = new Parcelamento();
        this.getImposto().setReadOnly(true);
        this.getDeducaoIncentivo().setReadOnly(true);
        this.getTotalContribEmpregadoDomestico().setReadOnly(true);
        this.getImpostoDevido().setReadOnly(true);
        this.getImpostoDevidoI().setReadOnly(true);
        this.getImpostoDevidoII().setReadOnly(true);
        this.getImpostoDevidoRRA().setReadOnly(true);
        this.getImpostoDevidoLei14754().setReadOnly(true);
        this.getCarneLeaoTitular().setReadOnly(true);
        this.getCarneLeaoDependentes().setReadOnly(true);
        this.getImpostoComplementar().setReadOnly(true);
        this.getImpostoPagoExterior().setReadOnly(true);
        this.getTotalImpostoPago().setReadOnly(true);
        this.getAliquotaEfetiva().setReadOnly(true);
        this.getRendPJRecebidoTitular().setReadOnly(true);
        this.getRendPJRecebidoDependentes().setReadOnly(true);
        this.getRendPFEXTRecebidoTitular().setReadOnly(true);
        this.getRendPFEXTRecebidoDependentes().setReadOnly(true);
        this.getRendAcmTitular().setReadOnly(true);
        this.getRendAcmDependentes().setReadOnly(true);
        this.getResultadoTributavelAR().setReadOnly(true);
        this.getTotalResultadosTributaveis().setReadOnly(true);
        this.getDescontoSimplificado().setReadOnly(true);
        this.getBaseCalculo().setReadOnly(true);
        this.getImpostoRetidoFonteTitular().setReadOnly(true);
        this.getImpostoRetidoFonteDependentes().setReadOnly(true);
        this.getImpostoRetidoRRA().setReadOnly(true);
        this.getImpostoRetidoFonteLei11033().setReadOnly(true);
        this.getSaldoImpostoPagar().setReadOnly(true);
        this.getImpostoRestituir().setReadOnly(true);
        this.getValorQuota().setReadOnly(true);
        this.getDebitoAutomatico().addOpcao(DEBITO_AUTOMATICO_AUTORIZADO, "Sim");
        this.getDebitoAutomatico().addOpcao(DEBITO_AUTOMATICO_NAO_AUTORIZADO, "N\u00e3o");
        if (aIdentificador.isAjuste()) {
            this.getDebitoAutomatico().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!CalculoImposto.this.getDebitoAutomatico().isHabilitado() || CalculoImposto.this.getSaldoImpostoPagar().comparacao("<", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor())) {
                        return null;
                    }
                    this.setMensagemValidacao(MensagemUtil.getMensagem("calculo_imposto_debito_automatico_sem_resposta"));
                    return super.validarImplementado();
                }
            });
        }
        this.getIndicadorPrimeiraQuota().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (CalculoImposto.this.getIndicadorPrimeiraQuota().isReadOnly()) {
                    return null;
                }
                if (this.getInformacao().isVazio() || this.getInformacao().naoFormatado().equals(CalculoImposto.INDICADOR_QUOTA_VAZIO)) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("calculo_imposto_quota_sem_resposta"), 3);
                }
                return null;
            }
        });
        this.getSaldoImpostoPagar().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (CalculoImposto.this.getSaldoImpostoPagar().comparacao(">", "0,00") && CalculoImposto.this.getNumQuotas().asInteger() == 0) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("calculo_imposto_saldo_positivo_quota_vazia"), 3);
                }
                if (CalculoImposto.this.getSaldoImpostoPagar().comparacao("<=", "0,00") && CalculoImposto.this.getNumQuotas().asInteger() > 0) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("calculo_imposto_saldo_negativo_quota_preenchida"), 3);
                }
                if (CalculoImposto.this.getSaldoImpostoPagar().comparacao(">", "0,00") && CalculoImposto.this.getValorQuota().comparacao("=", "0,00")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("calculo_imposto_saldo_positivo_quota_vazia"), 3);
                }
                if (CalculoImposto.this.getSaldoImpostoPagar().comparacao("<=", "0,00") && CalculoImposto.this.getValorQuota().comparacao(">", "0,00")) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("calculo_imposto_saldo_negativo_valor_quota_preenchida"), 3);
                }
                return null;
            }
        });
        this.getNumQuotas().setLimiteMinimo(0);
        int qtdeQuotas = 8;
        try {
            qtdeQuotas = Integer.parseInt(TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getNumQuotas().setLimiteMaximo(qtdeQuotas);
        this.getNumQuotas().addObservador((Observador)new ObservadorCalcQuotas(this));
        this.getSaldoImpostoPagar().addObservador((Observador)new ObservadorCalcQuotas(this));
        this.getBanco().addValidador((ValidadorIf)new ValidadorInfoBancariasVazias(3, this));
        this.getBanco().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (CalculoImposto.this.getImpostoRestituir().comparacao("<>", "0,00") || CalculoImposto.this.getSaldoImpostoPagar().comparacao("<>", "0,00") && CalculoImposto.this.getDebitoAutomatico().isHabilitado()) {
                    List colecao = ((Codigo)this.getInformacao()).getColecaoElementoTabela();
                    return Validador.validarElementoTabela((String)this.getInformacao().formatado(), (List)colecao, (String)("\"" + CalculoImposto.this.getBanco().getNomeCampo() + "\" inv\u00e1lido."));
                }
                return null;
            }
        });
        this.getSaldoImpostoPagar().addObservador(this.getSaldoImpostoPagar().getNomeCampo(), new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (CalculoImposto.this.getSaldoImpostoPagar().comparacao(">", "0,00")) {
                    CalculoImposto.this.banco.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarBancosContaPagamento());
                }
            }
        });
        this.getImpostoRestituir().addObservador(this.getImpostoRestituir().getNomeCampo(), new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (CalculoImposto.this.getImpostoRestituir().comparacao(">", "0,00")) {
                    CalculoImposto.this.banco.setColecaoElementoTabela(CadastroTabelasIRPF.recuperarBancosCredito());
                }
            }
        });
        this.getTipoConta().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (CalculoImposto.this.isTipoContaObrigatorio()) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.getAgencia().addObservador((Observador)new ObservadorInfoBancariasVazias(this.getBanco(), this.getAgencia(), this.getContaCredito()));
        this.getContaCredito().addObservador((Observador)new ObservadorInfoBancariasVazias(this.getBanco(), this.getAgencia(), this.getContaCredito()));
        this.getDvContaCredito().addObservador((Observador)new ObservadorInfoBancariasVazias(this.getBanco(), this.getAgencia(), this.getContaCredito()));
        this.getBanco().addObservador(this.getBanco().getNomeCampo(), new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (!"104".equals(CalculoImposto.this.getBanco().naoFormatado())) {
                    CalculoImposto.this.getOperacao().clear();
                }
            }
        });
        this.getDvContaCredito().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                String banco = CalculoImposto.this.getBanco().naoFormatado();
                String agencia = CalculoImposto.this.getAgencia().naoFormatado();
                String conta = CalculoImposto.this.getContaCredito().naoFormatado();
                if (!agencia.trim().isEmpty() && !conta.trim().isEmpty() && bancosDebito.contains(banco)) {
                    return super.validarImplementado();
                }
                return null;
            }
        });
        this.adicionarObservadorContaPagamentoCEF(dec);
    }

    private void adicionarObservadorContaPagamentoCEF(DeclaracaoIRPF dec) {
        ObservadorContaPagamentoCEF ObservadorContaPagamentoCEF2 = new ObservadorContaPagamentoCEF(dec);
        this.getTipoConta().addObservador((Observador)ObservadorContaPagamentoCEF2);
        this.getBanco().addObservador((Observador)ObservadorContaPagamentoCEF2);
    }

    public boolean isTipoContaObrigatorio() {
        boolean dadosBancariosVazio = this.banco.isVazio() && this.contaCredito.isVazio() && this.agencia.isVazio() && this.dvContaCredito.isVazio() && this.operacao.isVazio();
        return this.impostoRestituir() && !dadosBancariosVazio;
    }

    public String getContaCreditoFormatadaTxt() throws AplicacaoException {
        if (!this.getBanco().isVazio()) {
            if (this.getBanco().naoFormatado().equals("104")) {
                String strOperacao;
                String strConta = this.getContaCredito().isVazio() ? "        " : IRPFUtil.formatarZerosEsquerda(this.getContaCredito().naoFormatado().trim(), 12);
                if (this.getOperacao().isVazio()) {
                    strOperacao = "   ";
                } else {
                    strOperacao = IRPFUtil.formatarZerosEsquerda(this.getOperacao().naoFormatado().trim(), 3);
                    strConta = strConta.substring(4);
                }
                return strOperacao + strConta;
            }
            if (this.getDebitoAutomatico().naoFormatado().equals(DEBITO_AUTOMATICO_AUTORIZADO) && !this.getContaCredito().isVazio()) {
                try {
                    return IRPFUtil.formatarZerosEsquerda(this.getContaCredito().naoFormatado().trim(), Integer.parseInt(this.getBanco().getConteudoAtual(6)));
                }
                catch (Exception e) {
                    LogPPGD.erro((String)(e.getStackTrace()[0] + e.getMessage()));
                    return IRPFUtil.formatarZerosEsquerda(this.getContaCredito().naoFormatado().trim(), 13);
                }
            }
        }
        return this.getContaCredito().naoFormatado().trim();
    }

    public boolean validarContaBancaria(List<ElementoTabela> contas) {
        boolean encontrado;
        block1: {
            String dvContaBem;
            String contaBem;
            String agenciaBem;
            ElementoTabela conta;
            String bancoBem;
            String chaveContaBem;
            boolean bl = encontrado = this.getTipoConta().isVazio() || "4".equals(this.getTipoConta().naoFormatado()) || this.getBanco().isVazio() || this.getAgencia().isVazio() || this.getContaCredito().isVazio() || this.getDvContaCredito().isVazio();
            if (encontrado) break block1;
            String chaveContaCalculo = this.getBanco().naoFormatado().trim() + this.getAgencia().naoFormatado().trim() + this.getContaCredito().naoFormatado().trim().replaceAll("(^0+(?=\\d))", "") + this.getDvContaCredito().naoFormatado().trim();
            Iterator<ElementoTabela> iterator = contas.iterator();
            while (iterator.hasNext() && !(encontrado = (chaveContaBem = (bancoBem = (conta = iterator.next()).getConteudo(2).trim()) + (agenciaBem = conta.getConteudo(3).trim()) + (contaBem = conta.getConteudo(4).trim().replaceAll("(^0+(?=\\d))", "")) + (dvContaBem = conta.getConteudo(5).trim())).equals(chaveContaCalculo))) {
            }
        }
        return encontrado;
    }

    public static List<String> getBancosDebito() {
        return bancosDebito;
    }

    public boolean impostoPagarAlto() {
        return this.getSaldoImpostoPagar().comparacao(">=", "200.000,00");
    }

    public boolean impostoRestituirAlto() {
        return this.getImpostoRestituir().comparacao(">=", "100.000,00");
    }

    public boolean impostoRestituir() {
        return this.getImpostoRestituir().comparacao(">", "0,00");
    }

    public boolean bancosSemDV() {
        return this.getBanco().naoFormatado().equals("037") || this.getBanco().naoFormatado().equals("004");
    }

    public boolean isTipoContaPagamento() {
        return this.getTipoConta().naoFormatado().equals("3");
    }

    public boolean isTipoContaPoupanca() {
        return this.getTipoConta().naoFormatado().equals(INDICADOR_QUOTA_VAZIO);
    }

    public Codigo getAgencia() {
        return this.agencia;
    }

    public Codigo getBanco() {
        return this.banco;
    }

    public Valor getBaseCalculo() {
        return this.baseCalculo;
    }

    public Valor getCarneLeaoTitular() {
        return this.carneLeaoTitular;
    }

    public Valor getCarneLeaoDependentes() {
        return this.carneLeaoDependentes;
    }

    public Alfa getContaCredito() {
        return this.contaCredito;
    }

    public Valor getDeducaoIncentivo() {
        return this.deducaoIncentivo;
    }

    public Alfa getDvAgencia() {
        return this.dvAgencia;
    }

    public Alfa getDvContaCredito() {
        return this.dvContaCredito;
    }

    public Valor getImposto() {
        return this.imposto;
    }

    public Valor getImpostoComplementar() {
        return this.impostoComplementar;
    }

    public Valor getImpostoDevido() {
        return this.impostoDevido;
    }

    public Valor getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getImpostoRetidoFonteDependentes() {
        return this.impostoRetidoFonteDependentes;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public Valor getImpostoRetidoFonteTitular() {
        return this.impostoRetidoFonteTitular;
    }

    public Inteiro getNumQuotas() {
        return this.getParcelamento().getNumQuotas();
    }

    public Valor getSaldoImpostoPagar() {
        return this.saldoImpostoPagar;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor getValorQuota() {
        return this.getParcelamento().getValorQuota();
    }

    public Valor getDescontoSimplificado() {
        return this.descontoSimplificado;
    }

    public Valor getRendPJRecebidoDependentes() {
        return this.rendPJRecebidoDependentes;
    }

    public Valor getRendPFEXTRecebidoDependentes() {
        return this.rendPFEXTRecebidoDependentes;
    }

    public Valor getRendPJRecebidoTitular() {
        return this.rendPJRecebidoTitular;
    }

    public Valor getRendPFEXTRecebidoTitular() {
        return this.rendPFEXTRecebidoTitular;
    }

    public Valor getResultadoTributavelAR() {
        return this.resultadoTributavelAR;
    }

    public Valor getTotalResultadosTributaveis() {
        return this.totalResultadosTributaveis;
    }

    public Logico getDebitoAutomatico() {
        return this.getParcelamento().getDebitoAutomatico();
    }

    public boolean isDebitoAutomatico() {
        return DEBITO_AUTOMATICO_AUTORIZADO.equals(this.getParcelamento().getDebitoAutomatico().naoFormatado());
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }

    public Valor getImpostoDevidoII() {
        return this.impostoDevidoII;
    }

    public Valor getAliquotaEfetiva() {
        return this.aliquotaEfetiva;
    }

    public Valor getImpostoDevidoRRA() {
        return this.impostoDevidoRRA;
    }

    public Valor getImpostoDevidoLei14754() {
        return this.impostoDevidoLei14754;
    }

    public Valor getImpostoRetidoRRA() {
        return this.impostoRetidoRRA;
    }

    public Valor getRendAcmTitular() {
        return this.rendAcmTitular;
    }

    public Valor getRendAcmDependentes() {
        return this.rendAcmDependentes;
    }

    public Codigo getTipoConta() {
        return this.tipoConta;
    }

    public void setTipoConta(Codigo tipoConta) {
        this.tipoConta = tipoConta;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List lista = super.recuperarListaCamposPendencia();
        lista.add(this.getBanco());
        lista.add(this.getTipoConta());
        lista.add(this.getAgencia());
        lista.add(this.getContaCredito());
        lista.add(this.getDvContaCredito());
        lista.add(this.getSaldoImpostoPagar());
        return lista;
    }

    public Alfa getIndicadorPrimeiraQuota() {
        return this.getParcelamento().getIndicadorPrimeiraQuota();
    }

    public String getClasseFicha() {
        return PainelCalculoImposto.class.getName();
    }

    public String getNomeAba() {
        return "Informa\u00e7\u00f5es Banc\u00e1rias";
    }

    public Valor getImpostoDevidoI() {
        return this.impostoDevidoI;
    }

    public Parcelamento getParcelamento() {
        return this.parcelamento;
    }

    public String getTituloFichaDashboard() {
        return "C\u00e1lculo do Imposto";
    }

    public Alfa getOperacao() {
        return this.operacao;
    }

    public boolean temOperacao() {
        return false;
    }

    static {
        List<ElementoTabela> listaBancosDebito = CadastroTabelasIRPF.recuperarBancosDebito();
        for (ElementoTabela et : listaBancosDebito) {
            bancosDebito.add(et.getConteudo(0));
        }
    }
}

