/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.resumo;

import java.util.HashMap;
import java.util.Map;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.util.LogPPGD;

public class ValidadorDvContaCorrente
extends ValidadorNaoNuloIRPF {
    private static final Map<String, String> mapeamentoAgenciasBancoNordeste = new HashMap<String, String>();
    private static final Map<String, String> mapeamentoAgenciasBanese = new HashMap<String, String>();
    private static final String BANCO_DO_BRASIL = "001";
    private static final String BANCO_DA_AMAZONIA = "003";
    private static final String BANCO_DO_NORDESTE = "004";
    private static final String BANESTES = "021";
    private static final String SANTANDER = "033";
    private static final String BANPARA = "037";
    private static final String BANRISUL = "041";
    private static final String BANESE = "047";
    private static final String BRB = "070";
    private static final String CAIXA_ECONOMICA_FEDERAL = "104";
    private static final String BRADESCO = "237";
    private static final String ITAU_UNIBANCO = "341";
    private static final String BANCO_MERCANTIL = "389";
    private static final String HSBC = "399";
    private static final String BANCO_SAFRA = "422";
    private static final String CITIBANK = "745";
    private static final String BANSICREDI = "748";
    private static final String BANCOOB = "756";
    private Codigo banco;
    private Codigo agencia;
    private Alfa contaCorrente;
    private Alfa dvContaCorrente;
    private static Codigo grupoBem;
    private static Codigo codigoBem;
    private static Alfa indicadorContaPagamento;

    public ValidadorDvContaCorrente(byte severidade, Codigo banco, Codigo agencia, Alfa contaCorrente, Alfa dvContaCorrente, Codigo grupoBem, Codigo codigoBem, Alfa indicadorContaPagamento) {
        super(severidade);
        this.banco = banco;
        this.agencia = agencia;
        this.contaCorrente = contaCorrente;
        this.dvContaCorrente = dvContaCorrente;
        ValidadorDvContaCorrente.grupoBem = grupoBem;
        ValidadorDvContaCorrente.codigoBem = codigoBem;
        ValidadorDvContaCorrente.indicadorContaPagamento = indicadorContaPagamento;
    }

    public String getMensagemValidacao() {
        if ("2".equals(Bem.obterTipoContaBem(indicadorContaPagamento.naoFormatado(), grupoBem.naoFormatado(), codigoBem.naoFormatado()))) {
            return MensagemUtil.getMensagem("calculo_imposto_dv_conta_poupanca_invalido");
        }
        if ("1".equals(Bem.obterTipoContaBem(indicadorContaPagamento.naoFormatado(), grupoBem.naoFormatado(), codigoBem.naoFormatado()))) {
            return MensagemUtil.getMensagem("calculo_imposto_dv_conta_corrente_invalido");
        }
        if ("3".equals(Bem.obterTipoContaBem(indicadorContaPagamento.naoFormatado(), grupoBem.naoFormatado(), codigoBem.naoFormatado()))) {
            return MensagemUtil.getMensagem("calculo_imposto_dv_conta_pagamento_invalido");
        }
        return "DV da conta inv\u00e1lido";
    }

    @Override
    public RetornoValidacao validarImplementado() {
        RetornoValidacao retornoValidacao = null;
        try {
            String banco = this.banco.naoFormatado();
            String contaCorrente = this.contaCorrente.naoFormatado().trim();
            String dvContaCorrente = this.dvContaCorrente.naoFormatado().trim();
            boolean retorno = true;
            if (contaCorrente != null && !contaCorrente.trim().isEmpty() && dvContaCorrente != null && !dvContaCorrente.trim().isEmpty()) {
                if (banco.equals(BANCO_DO_BRASIL)) {
                    retorno = this.preValidar() && this.validarDvBancoDoBrasil();
                } else if (banco.equals(BANCO_DA_AMAZONIA)) {
                    retorno = this.preValidar() && this.validarDVBancoDaAmazonia();
                } else if (banco.equals(BANCO_DO_NORDESTE)) {
                    retorno = this.preValidar() && this.validarDVBancoDoNordeste();
                } else if (banco.equals(BANESTES)) {
                    retorno = this.preValidar() && this.validarDVBanestes();
                } else if (banco.equals(SANTANDER)) {
                    retorno = this.preValidar() && this.validarDvSantander();
                } else if (banco.equals(BANPARA)) {
                    retorno = this.preValidar() && this.validarDVBanpara();
                } else if (banco.equals(BANRISUL)) {
                    retorno = this.preValidar() && this.validarDvBanrisul();
                } else if (banco.equals(BANESE)) {
                    retorno = this.preValidar() && this.validarDVBanese();
                } else if (banco.equals(BRB)) {
                    retorno = this.preValidar() && this.validarDvBancoBrasilia();
                } else if (banco.equals(CAIXA_ECONOMICA_FEDERAL)) {
                    retorno = this.preValidar() && this.validarDvCaixaTipo2();
                } else if (banco.equals(BRADESCO)) {
                    retorno = this.preValidar() && this.validarDvBradesco();
                } else if (banco.equals(ITAU_UNIBANCO)) {
                    retorno = this.preValidar() && this.validarDvItauUnibanco();
                } else if (banco.equals(BANCO_MERCANTIL)) {
                    retorno = this.preValidar() && this.validarDvBancoMercantil();
                } else if (banco.equals(BANCO_SAFRA)) {
                    retorno = this.preValidar() && this.validarDvBancoSafra();
                } else if (banco.equals(CITIBANK)) {
                    retorno = this.preValidar() && this.validarDvCitibank();
                } else if (banco.equals(BANSICREDI)) {
                    retorno = this.preValidar() && this.validarDvBansicredi();
                } else if (banco.equals(BANCOOB)) {
                    boolean bl = retorno = this.preValidar() && this.validarDvBancoob();
                }
            }
            if (!retorno) {
                retornoValidacao = new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade(), this.getInformacao());
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            retornoValidacao = new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade(), this.getInformacao());
        }
        return retornoValidacao;
    }

    private boolean preValidar() {
        return this.dvContaCorrente.naoFormatado().length() == 1;
    }

    public int modulo11(String numero) {
        int somaDv = 0;
        int i = 0;
        int _i = numero.length() - 1;
        while (i < numero.length()) {
            somaDv += Integer.parseInt(Character.toString(numero.charAt(_i))) * (2 + i % 8);
            ++i;
            --_i;
        }
        return 11 - somaDv % 11;
    }

    public int modulo10(String numero) {
        int somaDv = 0;
        int i = 0;
        int _i = numero.length() - 1;
        while (i < numero.length()) {
            for (int resultado = Integer.parseInt(Character.toString(numero.charAt(_i))) * (2 - i % 2); resultado > 0; resultado /= 10) {
                somaDv += resultado % 10;
            }
            ++i;
            --_i;
        }
        return 10 - somaDv % 10;
    }

    public String getAgenciaFormatada() {
        return IRPFUtil.formatarZerosEsquerda(this.agencia.naoFormatado().trim(), Integer.parseInt(this.banco.getConteudoAtual(5)));
    }

    public String getContaCorrenteFormatada() {
        return IRPFUtil.formatarZerosEsquerda(this.contaCorrente.naoFormatado().trim(), Integer.parseInt(this.banco.getConteudoAtual(6)));
    }

    private boolean validarDvBancoDoBrasil() {
        String dvContaCorrente = this.dvContaCorrente.naoFormatado().toLowerCase().trim();
        int dvCalculado = this.calculoDVBancoBrasil();
        String strDv = dvCalculado == 10 ? "x" : (dvCalculado > 10 ? "0" : String.valueOf(dvCalculado));
        return strDv.equals(dvContaCorrente);
    }

    private int calculoDVBancoBrasil() {
        String contaCorrente = this.contaCorrente.naoFormatado().trim();
        int valorModulo = this.modulo11(contaCorrente);
        return valorModulo;
    }

    private boolean validarDVBancoDaAmazonia() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int dvCalculado = this.modulo11(agencia + contaCorrente);
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDVBancoDoNordeste() {
        String agenciaFormatada = this.getAgenciaFormatada();
        String agencia = mapeamentoAgenciasBancoNordeste.containsKey(agenciaFormatada) ? mapeamentoAgenciasBancoNordeste.get(agenciaFormatada) : agenciaFormatada;
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int somaDv = 0;
        int i = 0;
        int _i = contaCorrente.length() - 1;
        while (i < contaCorrente.length()) {
            somaDv += Integer.parseInt(Character.toString(contaCorrente.charAt(_i))) * (2 + i % 8);
            ++i;
            --_i;
        }
        i = 0;
        _i = agencia.length() - 1;
        while (i < agencia.length()) {
            somaDv += Integer.parseInt(Character.toString(agencia.charAt(_i))) * (7 + i % 8);
            ++i;
            --_i;
        }
        int resto = somaDv % 11;
        int dvCalculado = resto == 0 || resto == 1 ? 0 : 11 - resto;
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDVBanestes() {
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int dvCalculado = this.modulo10(this.contaCorrente.naoFormatado().trim());
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvSantander() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        String aux = agencia + contaCorrente;
        int[] multiplicadores = new int[]{9, 7, 3, 1, 0, 0, 0, 9, 7, 1, 3, 1, 9, 7, 3};
        int somaDv = 0;
        for (int i = 0; i < multiplicadores.length; ++i) {
            somaDv += Integer.parseInt(Character.toString(aux.charAt(i))) * multiplicadores[i] % 10;
        }
        int dvCalculado = 10 - somaDv % 10;
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDVBanpara() {
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int dvCalculado = this.modulo11(this.contaCorrente.naoFormatado().trim());
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvBanrisul() {
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int somaDv = 0;
        int dvCalculado = 0;
        int[] multiplicadores = new int[]{3, 2, 4, 7, 6, 5, 4, 3, 2};
        for (int i = 0; i < multiplicadores.length; ++i) {
            somaDv += Integer.parseInt(Character.toString(contaCorrente.charAt(i))) * multiplicadores[i];
        }
        dvCalculado = 11 - somaDv % 11;
        if (dvCalculado == 10) {
            dvCalculado = 6;
        } else if (dvCalculado == 11) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDVBanese() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.getContaCorrenteFormatada();
        String agenciaEquivalente = mapeamentoAgenciasBanese.get(agencia);
        if (agenciaEquivalente != null) {
            agencia = agenciaEquivalente;
        }
        int dvCalculado = this.modulo11(agencia + contaCorrente);
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvBancoBrasilia() {
        int dvCalculado = this.modulo11(this.contaCorrente.naoFormatado().trim());
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado().trim());
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvCaixaTipo2() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.contaCorrente.naoFormatado().trim();
        String numero = contaCorrente = IRPFUtil.formatarZerosEsquerda(contaCorrente, 9);
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int somaDv = 0;
        int[] multiplicadores = new int[]{2, 9, 8, 7, 6, 5, 4, 3, 2};
        for (int i = 0; i < multiplicadores.length; ++i) {
            somaDv += Integer.parseInt(Character.toString(numero.charAt(i))) * multiplicadores[i];
        }
        int dvCalculado = somaDv * 10 % 11;
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvBradesco() {
        String contaCorrente = this.contaCorrente.naoFormatado().trim();
        String dvContaCorrente = this.dvContaCorrente.naoFormatado().toLowerCase();
        int somaDv = 0;
        int i = 0;
        int _i = contaCorrente.length() - 1;
        while (i < contaCorrente.length()) {
            somaDv += Integer.parseInt(Character.toString(contaCorrente.charAt(_i))) * (2 + i % 6);
            ++i;
            --_i;
        }
        int resto = somaDv % 11;
        String auxSomaDv = resto == 0 ? "0" : (resto == 1 ? "0" : String.valueOf(11 - resto));
        String auxDvContaCorrente = dvContaCorrente.equalsIgnoreCase("p") && resto == 1 ? "0" : dvContaCorrente;
        return auxSomaDv.equals(auxDvContaCorrente);
    }

    private boolean validarDvItauUnibanco() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int dvCalculado = this.modulo10(agencia + contaCorrente);
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvBancoMercantil() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int dvCalculado = this.modulo10(agencia + contaCorrente);
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvHsbc() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        String aux = agencia + contaCorrente;
        int[] multiplicadores = new int[]{8, 9, 2, 3, 4, 5, 6, 7, 8, 9};
        int somaDv = 0;
        for (int i = 0; i < aux.length(); ++i) {
            somaDv += Integer.parseInt(Character.toString(aux.charAt(i))) * multiplicadores[i];
        }
        int resto = somaDv % 11;
        int dvCalculado = resto == 10 ? 0 : resto;
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvBancoSafra() {
        String agencia = this.getAgenciaFormatada();
        String contaCorrente = this.getContaCorrenteFormatada();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int dvCalculado = this.modulo11(agencia + contaCorrente);
        if (dvCalculado == 10) {
            dvCalculado = 0;
        } else if (dvCalculado == 11) {
            dvCalculado = 1;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvCitibank() {
        String contaCorrente = this.contaCorrente.naoFormatado().trim();
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        int somaDv = 0;
        int i = 0;
        int _i = contaCorrente.length() - 1;
        while (i < contaCorrente.length()) {
            somaDv += Integer.parseInt(Character.toString(contaCorrente.charAt(_i))) * (2 + i % 8);
            ++i;
            --_i;
        }
        int dvCalculado = somaDv * 10 % 11;
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    private boolean validarDvBansicredi() {
        return true;
    }

    private boolean validarDvBancoob() {
        int dvContaCorrente = Integer.parseInt(this.dvContaCorrente.naoFormatado());
        String contaCorrente = this.contaCorrente.naoFormatado().trim();
        int somaDv = 0;
        int i = 0;
        int _i = contaCorrente.length() - 1;
        while (i < contaCorrente.length()) {
            somaDv += Integer.parseInt(Character.toString(contaCorrente.charAt(_i))) * (2 + i % 9);
            ++i;
            --_i;
        }
        int dvCalculado = 11 - somaDv % 11;
        if (dvCalculado >= 10) {
            dvCalculado = 0;
        }
        return dvCalculado == dvContaCorrente;
    }

    static {
        mapeamentoAgenciasBancoNordeste.put(BANCO_DO_BRASIL, "099");
        mapeamentoAgenciasBancoNordeste.put("002", "044");
        mapeamentoAgenciasBancoNordeste.put(BANCO_DA_AMAZONIA, "074");
        mapeamentoAgenciasBancoNordeste.put(BANCO_DO_NORDESTE, "073");
        mapeamentoAgenciasBancoNordeste.put("005", "081");
        mapeamentoAgenciasBancoNordeste.put("006", BANCO_DO_BRASIL);
        mapeamentoAgenciasBancoNordeste.put("007", "002");
        mapeamentoAgenciasBancoNordeste.put("008", "053");
        mapeamentoAgenciasBancoNordeste.put("009", "046");
        mapeamentoAgenciasBancoNordeste.put("010", "020");
        mapeamentoAgenciasBancoNordeste.put("011", "082");
        mapeamentoAgenciasBancoNordeste.put("012", BANESE);
        mapeamentoAgenciasBancoNordeste.put("013", "009");
        mapeamentoAgenciasBancoNordeste.put("014", "010");
        mapeamentoAgenciasBancoNordeste.put("015", "054");
        mapeamentoAgenciasBancoNordeste.put("016", "000");
        mapeamentoAgenciasBancoNordeste.put("017", "055");
        mapeamentoAgenciasBancoNordeste.put("018", "083");
        mapeamentoAgenciasBancoNordeste.put("019", "011");
        mapeamentoAgenciasBancoNordeste.put("020", "048");
        mapeamentoAgenciasBancoNordeste.put(BANESTES, "025");
        mapeamentoAgenciasBancoNordeste.put("022", "012");
        mapeamentoAgenciasBancoNordeste.put("023", "049");
        mapeamentoAgenciasBancoNordeste.put("024", "026");
        mapeamentoAgenciasBancoNordeste.put("025", "040");
        mapeamentoAgenciasBancoNordeste.put("026", "075");
        mapeamentoAgenciasBancoNordeste.put("027", "016");
        mapeamentoAgenciasBancoNordeste.put("028", "050");
        mapeamentoAgenciasBancoNordeste.put("029", "027");
        mapeamentoAgenciasBancoNordeste.put("030", "029");
        mapeamentoAgenciasBancoNordeste.put("031", BANCO_DA_AMAZONIA);
        mapeamentoAgenciasBancoNordeste.put("032", BANCO_DO_NORDESTE);
        mapeamentoAgenciasBancoNordeste.put(SANTANDER, "076");
        mapeamentoAgenciasBancoNordeste.put("034", BANRISUL);
        mapeamentoAgenciasBancoNordeste.put("035", "077");
        mapeamentoAgenciasBancoNordeste.put("036", "030");
        mapeamentoAgenciasBancoNordeste.put(BANPARA, "067");
        mapeamentoAgenciasBancoNordeste.put("038", "068");
        mapeamentoAgenciasBancoNordeste.put("039", "078");
        mapeamentoAgenciasBancoNordeste.put("040", "058");
        mapeamentoAgenciasBancoNordeste.put(BANRISUL, "059");
        mapeamentoAgenciasBancoNordeste.put("042", "042");
        mapeamentoAgenciasBancoNordeste.put("043", "031");
        mapeamentoAgenciasBancoNordeste.put("044", "060");
        mapeamentoAgenciasBancoNordeste.put("045", "062");
        mapeamentoAgenciasBancoNordeste.put("046", "017");
        mapeamentoAgenciasBancoNordeste.put(BANESE, "079");
        mapeamentoAgenciasBancoNordeste.put("048", "032");
        mapeamentoAgenciasBancoNordeste.put("049", BRB);
        mapeamentoAgenciasBancoNordeste.put("050", "063");
        mapeamentoAgenciasBancoNordeste.put("051", "086");
        mapeamentoAgenciasBancoNordeste.put("052", SANTANDER);
        mapeamentoAgenciasBancoNordeste.put("053", "052");
        mapeamentoAgenciasBancoNordeste.put("054", "064");
        mapeamentoAgenciasBancoNordeste.put("055", "034");
        mapeamentoAgenciasBancoNordeste.put("056", "071");
        mapeamentoAgenciasBancoNordeste.put("057", "072");
        mapeamentoAgenciasBancoNordeste.put("058", "014");
        mapeamentoAgenciasBancoNordeste.put("059", "038");
        mapeamentoAgenciasBancoNordeste.put("060", "043");
        mapeamentoAgenciasBancoNordeste.put("061", "080");
        mapeamentoAgenciasBancoNordeste.put("062", BANESTES);
        mapeamentoAgenciasBancoNordeste.put("063", "057");
        mapeamentoAgenciasBancoNordeste.put("064", "091");
        mapeamentoAgenciasBancoNordeste.put("066", "006");
        mapeamentoAgenciasBancoNordeste.put("067", "051");
        mapeamentoAgenciasBancoNordeste.put("068", "066");
        mapeamentoAgenciasBancoNordeste.put("069", "085");
        mapeamentoAgenciasBancoNordeste.put(BRB, "039");
        mapeamentoAgenciasBancoNordeste.put("071", "092");
        mapeamentoAgenciasBancoNordeste.put("072", "028");
        mapeamentoAgenciasBancoNordeste.put("073", "019");
        mapeamentoAgenciasBancoNordeste.put("074", "087");
        mapeamentoAgenciasBancoNordeste.put("076", "061");
        mapeamentoAgenciasBancoNordeste.put("077", "088");
        mapeamentoAgenciasBancoNordeste.put("078", "089");
        mapeamentoAgenciasBancoNordeste.put("080", "005");
        mapeamentoAgenciasBancoNordeste.put("081", "090");
        mapeamentoAgenciasBancoNordeste.put("082", "015");
        mapeamentoAgenciasBancoNordeste.put("083", "007");
        mapeamentoAgenciasBancoNordeste.put("084", "013");
        mapeamentoAgenciasBancoNordeste.put("085", "093");
        mapeamentoAgenciasBancoNordeste.put("086", "069");
        mapeamentoAgenciasBancoNordeste.put("087", "094");
        mapeamentoAgenciasBancoNordeste.put("088", "101");
        mapeamentoAgenciasBancoNordeste.put("089", "107");
        mapeamentoAgenciasBancoNordeste.put("090", "095");
        mapeamentoAgenciasBancoNordeste.put("091", "045");
        mapeamentoAgenciasBancoNordeste.put("092", "008");
        mapeamentoAgenciasBancoNordeste.put("093", "035");
        mapeamentoAgenciasBancoNordeste.put("095", "106");
        mapeamentoAgenciasBancoNordeste.put("096", "103");
        mapeamentoAgenciasBancoNordeste.put("097", "117");
        mapeamentoAgenciasBancoNordeste.put("098", "118");
        mapeamentoAgenciasBancoNordeste.put("099", CAIXA_ECONOMICA_FEDERAL);
        mapeamentoAgenciasBancoNordeste.put("100", "108");
        mapeamentoAgenciasBancoNordeste.put("101", "102");
        mapeamentoAgenciasBancoNordeste.put("102", "112");
        mapeamentoAgenciasBancoNordeste.put("103", "113");
        mapeamentoAgenciasBancoNordeste.put(CAIXA_ECONOMICA_FEDERAL, "115");
        mapeamentoAgenciasBancoNordeste.put("105", "105");
        mapeamentoAgenciasBancoNordeste.put("106", "096");
        mapeamentoAgenciasBancoNordeste.put("107", "097");
        mapeamentoAgenciasBancoNordeste.put("108", "024");
        mapeamentoAgenciasBancoNordeste.put("109", "111");
        mapeamentoAgenciasBancoNordeste.put("110", "119");
        mapeamentoAgenciasBancoNordeste.put("111", "084");
        mapeamentoAgenciasBancoNordeste.put("112", "036");
        mapeamentoAgenciasBancoNordeste.put("113", BANPARA);
        mapeamentoAgenciasBancoNordeste.put("114", "114");
        mapeamentoAgenciasBancoNordeste.put("115", "100");
        mapeamentoAgenciasBancoNordeste.put("116", "116");
        mapeamentoAgenciasBancoNordeste.put("117", "056");
        mapeamentoAgenciasBancoNordeste.put("118", "065");
        mapeamentoAgenciasBancoNordeste.put("119", "109");
        mapeamentoAgenciasBanese.put("002", "006");
        mapeamentoAgenciasBanese.put(BANCO_DA_AMAZONIA, "005");
        mapeamentoAgenciasBanese.put(BANCO_DO_NORDESTE, "011");
        mapeamentoAgenciasBanese.put("005", "007");
        mapeamentoAgenciasBanese.put("006", "008");
        mapeamentoAgenciasBanese.put("007", "013");
        mapeamentoAgenciasBanese.put("008", BANCO_DO_NORDESTE);
        mapeamentoAgenciasBanese.put("009", BANCO_DA_AMAZONIA);
        mapeamentoAgenciasBanese.put("010", "010");
        mapeamentoAgenciasBanese.put("011", "002");
        mapeamentoAgenciasBanese.put("012", "012");
        mapeamentoAgenciasBanese.put("013", "009");
        mapeamentoAgenciasBanese.put("014", BANCO_DO_BRASIL);
    }
}

