/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.saida;

import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValidadorNomeIRPF;
import serpro.ppgd.irpf.gui.saida.PainelSaida;
import serpro.ppgd.irpf.rendavariavel.ColecaoFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ColecaoRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.saida.ValidadorAno;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ValidadorIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class Saida
extends ObjetoNegocio
implements ObjetoFicha {
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private CPF cpfProcurador = new CPF((ObjetoNegocio)this, "CPF do Procurador");
    private Alfa nomeProcurador = new Alfa((ObjetoNegocio)this, "Nome do Procurador", 60);
    private Alfa endProcurador = new Alfa((ObjetoNegocio)this, "Endere\u00e7o do Procurador", 80);
    private Data dtCondicaoNaoResidente = new Data((ObjetoNegocio)this, "Data da Caracteriza\u00e7\u00e3o da Condi\u00e7\u00e3o de N\u00e3o Residente");
    private Data dtCondicaoResidente = new Data((ObjetoNegocio)this, "Data da Caracteriza\u00e7\u00e3o da Condi\u00e7\u00e3o de Residente");
    private Codigo paisResidencia = new Codigo((ObjetoNegocio)this, "Pa\u00eds", CadastroTabelasIRPF.recuperarPaisesExterior());

    public Saida(final DeclaracaoIRPF dec) {
        this.identificadorDeclaracao = dec.getIdentificadorDeclaracao();
        CacheNI.getInstancia().registrarNINome((NI)this.cpfProcurador, this.nomeProcurador);
        if (this.identificadorDeclaracao.isSaida()) {
            ValidadorCPF vCPF = new ValidadorCPF(3);
            vCPF.setMensagemValidacao(MensagemUtil.getMensagem("saida_cpf_procurador_invalido"));
            this.cpfProcurador.addValidador((ValidadorIf)vCPF);
            this.cpfProcurador.addValidador((ValidadorIf)new ValidadorDefault(3){

                public RetornoValidacao validarImplementado() {
                    if (Saida.this.getCpfProcurador().naoFormatado().equals(Saida.this.identificadorDeclaracao.getCpf().naoFormatado())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("saida_cpf_procurador_igual_contribuinte"), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.cpfProcurador.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!(Saida.this.getNomeProcurador().isVazio() && Saida.this.getEndProcurador().isVazio() || !Saida.this.getCpfProcurador().isVazio())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("saida_cpf_procurador_branco"), this.getSeveridade());
                    }
                    return null;
                }
            });
            this.nomeProcurador.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2));
            this.nomeProcurador.addValidador((ValidadorIf)new ValidadorNomeIRPF());
            this.dtCondicaoNaoResidente.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
            this.dtCondicaoNaoResidente.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    if (!Saida.this.dtCondicaoNaoResidente.isVazio()) {
                        return ValidadorIRPF.validarData(this.getInformacao(), Integer.valueOf(ConstantesGlobais.ANO_BASE_SEGUINTE));
                    }
                    return null;
                }
            });
            this.dtCondicaoNaoResidente.addValidador((ValidadorIf)new ValidadorAno(3));
            this.dtCondicaoResidente.addValidador((ValidadorIf)new ValidadorAno(3){

                @Override
                public RetornoValidacao validarImplementado() {
                    this.setMensagemValidacao(MensagemUtil.getMensagem("saida_dt_condicao_residente_posterior", new String[]{ConstantesGlobais.ANO_BASE}));
                    return super.validarImplementado();
                }
            });
            this.dtCondicaoResidente.addValidador((ValidadorIf)new ValidadorDefault(3){

                public RetornoValidacao validarImplementado() {
                    if (!Saida.this.dtCondicaoNaoResidente.isVazio() && !Saida.this.dtCondicaoResidente.isVazio() && Saida.this.dtCondicaoResidente.maisNova(Saida.this.dtCondicaoNaoResidente)) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("saida_dt_condicao_residente_posterior", new String[]{ConstantesGlobais.ANO_BASE}), 3);
                    }
                    return null;
                }
            });
            this.dtCondicaoResidente.addObservador(this.dtCondicaoResidente.getNomeCampo(), new Observador(){

                public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                    int mes = 1;
                    if (!valorNovo.toString().trim().isEmpty()) {
                        mes = Integer.valueOf(valorNovo.toString().substring(2, 4).trim());
                    }
                    RendPF rendPFTitular = dec.getRendPFTitular();
                    ColecaoRendPFDependente colecaoRendPFDependente = dec.getRendPFDependente();
                    for (int i = 0; i < mes - 1; ++i) {
                        dec.getAtividadeRural().getBrasil().getReceitasDespesas().getMesReceitaPorIndice(i).clear();
                        rendPFTitular.getContasAno().getArrayMeses()[i].clear();
                        rendPFTitular.getMesRendPFPorIndice(i).clear();
                        for (ItemRendPFDependente itemRendPFDependente : colecaoRendPFDependente.itens()) {
                            itemRendPFDependente.getRendimentos().getContasAno().getArrayMeses()[i].clear();
                            itemRendPFDependente.getRendimentos().getMesRendPFPorIndice(mes).clear();
                        }
                    }
                }
            });
            this.dtCondicaoNaoResidente.addObservador(this.dtCondicaoNaoResidente.getNomeCampo(), new Observador(){

                public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                    int mes = 12;
                    if (!valorNovo.toString().trim().isEmpty()) {
                        mes = Integer.valueOf(valorNovo.toString().substring(2, 4).trim());
                    }
                    RendPF rendPFTitular = dec.getRendPFTitular();
                    ColecaoRendPFDependente colecaoRendPFDependente = dec.getRendPFDependente();
                    FundosInvestimentos fundosInvestimentosTitular = dec.getFundosInvestimentos();
                    ColecaoFundosInvestimentosDependente colecaoFundosInvestimentosDependente = dec.getFundosInvestimentosDependente();
                    RendaVariavel rendaVariavelTitular = dec.getRendaVariavel();
                    ColecaoRendaVariavelDependente colecaoRendaVariavelDependente = dec.getRendaVariavelDependente();
                    for (int i = mes; i < 12; ++i) {
                        dec.getAtividadeRural().getBrasil().getReceitasDespesas().getMesReceitaPorIndice(i).clear();
                        rendPFTitular.getContasAno().getArrayMeses()[i].clear();
                        rendPFTitular.getMesRendPFPorIndice(i).clear();
                        fundosInvestimentosTitular.getMeses()[i].clear();
                        rendaVariavelTitular.getGanhosPorIndice(i).clear();
                        for (ItemRendPFDependente itemRendPFDependente : colecaoRendPFDependente.itens()) {
                            itemRendPFDependente.getRendimentos().getContasAno().getArrayMeses()[i].clear();
                            itemRendPFDependente.getRendimentos().getMesRendPFPorIndice(i).clear();
                        }
                        for (ItemFundosInvestimentosDependente itemFundosInvestimentosDependente : colecaoFundosInvestimentosDependente.itens()) {
                            itemFundosInvestimentosDependente.getFundosInvestimentos().getMeses()[i].clear();
                        }
                        for (ItemRendaVariavelDependente itemRendaVariavelDependente : colecaoRendaVariavelDependente.itens()) {
                            itemRendaVariavelDependente.getRendaVariavel().getGanhosPorIndice(i).clear();
                        }
                    }
                }
            });
        }
        this.nomeProcurador.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.endProcurador.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.setFicha("Sa\u00edda");
    }

    public CPF getCpfProcurador() {
        return this.cpfProcurador;
    }

    public Data getDtCondicaoNaoResidente() {
        return this.dtCondicaoNaoResidente;
    }

    public Data getDtCondicaoResidente() {
        return this.dtCondicaoResidente;
    }

    public Alfa getEndProcurador() {
        return this.endProcurador;
    }

    public Alfa getNomeProcurador() {
        return this.nomeProcurador;
    }

    public Codigo getPaisResidencia() {
        return this.paisResidencia;
    }

    public int getMesInicial() {
        Data dataResidente = this.getDtCondicaoResidente();
        String mes = dataResidente.formatado().substring(3, 5);
        if (mes.trim().isEmpty()) {
            mes = "01";
        }
        return Integer.parseInt(mes);
    }

    public int getMesFinal() {
        Data dataNaoResidente = this.getDtCondicaoNaoResidente();
        String mes = dataNaoResidente.formatado().substring(3, 5);
        if (mes.trim().isEmpty()) {
            mes = "12";
        }
        return Integer.parseInt(mes);
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        return super.recuperarCamposInformacao();
    }

    public String getClasseFicha() {
        return PainelSaida.class.getName();
    }

    public boolean isVazio() {
        return this.cpfProcurador.isVazio() && this.nomeProcurador.isVazio() && this.endProcurador.isVazio() && this.dtCondicaoNaoResidente.isVazio() && this.dtCondicaoResidente.isVazio();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Sa\u00edda";
    }
}

